/*>>> sandsp.c: SAN project simple display routines */

/* Revised: 1993.05.16 */

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sandsp.h"
#include "sanmne.h"
#include "sanmsc.h"
#include "sanrst.h"
#include "sanutl.h"

/*--> SANDspChar: display a character */
nonstatic
void
SANDspChar(char ch)
{
/* this is the choke point function for stdout */

fputc(ch, stdout);
if (do_fptr != NULL)
	fputc(ch, do_fptr);

return;
}

/*--> SANDspStr: display a string */
nonstatic
void
SANDspStr(charptrT s)
{
fputs(s, stdout);
if (do_fptr != NULL)
	fputs(s, do_fptr);

return;
}

/*--> SANDspNL: display a newline */
nonstatic
void
SANDspNL(void)
{
SANDspChar('\n');

return;
}

/*--> SANDspLine: display a string and a newline */
nonstatic
void
SANDspLine(charptrT s)
{
SANDspStr(s);
SANDspNL();

return;
}

/*--> SANDspSTV: display the scratch text vector */
nonstatic
void
SANDspSTV(void)
{
SANDspStr(stv);

return;
}

/*--> SANDspSTVNL: display the scratch text vector and a newline */
nonstatic
void
SANDspSTVNL(void)
{
SANDspSTV();
SANDspNL();

return;
}

/*--> SANDspNote: display a notification */
nonstatic
void
SANDspNote(charptrT s)
{
SANDspStr("*** Note: ");
SANDspStr(s);
SANDspNL();

return;
}

/*--> SANDspError: display an error */
nonstatic
void
SANDspError(charptrT s)
{
SANDspStr("*** Error: ");
SANDspStr(s);
SANDspNL();

return;
}

/*--> SANDspErrorSTV: display an error from the STV */
nonstatic
void
SANDspErrorSTV(void)
{
SANDspError(stv);

return;
}

/*--> SANDspSI: display a short integer */
nonstatic
void
SANDspSI(siT si)
{
char tv[32];

(void) sprintf(tv, "%hd", si);
SANDspStr(tv);

return;
}

/*--> SANDspLI: display a long integer */
nonstatic
void
SANDspLI(liT li)
{
char tv[32];

(void) sprintf(tv, "%ld", li);
SANDspStr(tv);

return;
}

/*--> SANDspStrSI: display a string and a short integer */
nonstatic
void
SANDspStrSI(charptrT s, siT si)
{
SANDspStr(s);
SANDspSI(si);

return;
}

/*--> SANDspStrLI: display a string and a long integer */
nonstatic
void
SANDspStrLI(charptrT s, liT li)
{
SANDspStr(s);
SANDspLI(li);

return;
}

/*--> SANDspStrSINL: display a string, a short int, and a newline */
nonstatic
void
SANDspStrSINL(charptrT s, siT si)
{
SANDspStrSI(s, si);
SANDspNL();

return;
}

/*--> SANDspStrLINL: display a string, a long integer and a newline */
nonstatic
void
SANDspStrLINL(charptrT s, liT li)
{
SANDspStrLI(s, li);
SANDspNL();

return;
}

/*--> SANDspTimestamp: display the current timestamp */
nonstatic
void
SANDspTimestamp(void)
{
stampT stamp;

SANTimestamp(stamp);
SANDspLine(stamp);

return;
}

/*--> SANDspSq: display a square */
nonstatic
void
SANDspSq(sqT sq)
{
SANDspChar(acfv[map_file_sq(sq)]);
SANDspChar(acrv[map_rank_sq(sq)]);

return;
}

/*--> SANDspColor: display color character */
nonstatic
void
SANDspColor(cT c)
{
SANDspChar(accv[c]);

return;
}

/*--> SANDspPiece: display piece character */
nonstatic
void
SANDspPiece(pT p)
{
SANDspChar(acpv[p]);

return;
}

/*--> SANDspColorPiece: display color+piece characters */
nonstatic
void
SANDspColorPiece(cpT cp)
{
SANDspColor(cv_c_cpv[cp]);
SANDspPiece(cv_p_cpv[cp]);

return;
}

/*--> SANDspSAN: SAN display */
nonstatic
void
SANDspSAN(mptrT mptr)
{
sanT san;

SANEncode(mptr, san);
SANDspStr(san);

return;
}

/*--> SANDspSANTB: display SAN with trailing blanks */
nonstatic
void
SANDspSANTB(mptrT mptr)
{
siT i;
sanT san;

SANEncode(mptr, san);
SANDspStr(san);

i = strlen(san);
while (i < sanL)
	{
	SANDspChar(' ');
	i++;
	};

return;
}

/*--> SANDspSANNL: SAN display with newline */
nonstatic
void
SANDspSANNL(mptrT mptr)
{
SANDspSAN(mptr);
SANDspNL();

return;
}

/*--> SANDspFullMove: display full move */
nonstatic
void
SANDspFullMove(siT n, mptrT mptr)
{
sanT san;

SANEncode(mptr, san);
if (cv_c_cpv[mptr->m_frcp] == c_w)
	(void) sprintf(stv, "%3hd. %s", n, san);
else
	(void) sprintf(stv, "%3hd.  ...   %s", n, san);
SANDspSTVNL();

return;
}

/*--> SANDspPath: display the current path */
nonstatic
void
SANDspPath(void)
{
siT i;

SANDspStr("Path:");
for (i = 0; i < an; i++)
	{
	SANDspChar(' ');
	if (av[i].a_g.g_curr != NULL)
		SANDspSAN(av[i].a_g.g_curr);
	};
SANDspNL();


return;
}

/*--> SANDspBoard: quick board display */
nonstatic
void
SANDspBoard(void)
{
rankT rank;
fileT file;
cpT cp;

for (rank = rank_8; rank >= rank_1; rank--)
	{
	/* note that this is for a black text on a white backround display */

	for (file = file_a; file <= file_h; file++)
		{
		cp = gb.bm[rank][file];
		if (cp != cp_v0)
			SANDspColorPiece(cp);
		else
			if ((rank % 2) == (file % 2))
				SANDspStr("::");
			else
				SANDspStr("  ");
		};
	SANDspNL();
	};

return;
}

/*--> SANDspOptions: active options display */
nonstatic
void
SANDspOptions(void)
{
optnT optn;
siT col;

SANDspLine("Active options:");
col = 0;
for (optn = 0; optn < optnL; optn++)
	if (optnv[optn])
		{
		if (col == 10)
			{
			SANDspNL();
			col = 0;
			};
		if (col > 0)
			SANDspChar(' ');
		SANDspStr(optnnamev[optn]);
		col++;
		};
if (col > 0)
	SANDspNL();
SANDspNL();

return;
}

/*--> SANDspStatus: quick status display */
nonstatic
void
SANDspStatus(void)
{
SANDspBoard();

SANDspStrSI("actc: ", curr_e.e_actc);
SANDspStrSI("   cast: ", curr_e.e_cast);
SANDspStrSI("   epsq: ", curr_e.e_epsq);
SANDspStrSI("   hmvc: ", curr_e.e_hmvc);
SANDspStrSI("   fmvn: ", curr_e.e_fmvn);
SANDspNL();

SANDspStrSI("census: ", SANCensus());
SANDspStrSI("  status: ", SANStatus());
SANDspStrSI("  setup: ", setup);
SANDspStrSI("  level: ", level);
SANDspStrLI("  response time: ", artsec);
SANDspNL();

SANDspOptions();

return;
}

/*--> SANGateChar: gate a character output to a file */
nonstatic
void
SANGateChar(FILEptrT fptr, char ch)
{
if (fptr == stdout)
	SANDspChar(ch);
else
	(void) fputc(ch, fptr);

return;
}

/*--> SANGateStr: gate a string output to a file */
nonstatic
void
SANGateStr(FILEptrT fptr, charptrT s)
{
if (fptr == stdout)
	SANDspStr(s);
else
	(void) fputs(s, fptr);

return;
}

/*--> SANBadParmForm: issue "bad parameter form" diagnostic */
nonstatic
void
SANBadParmForm(siT n)
{
(void) sprintf(stv, "bad parameter form (%hd)", n);
SANDspError(stv);

return;
}

/*--> SANBadParmValue: issue "bad parameter value" diagnostic */
nonstatic
void
SANBadParmValue(siT n)
{
(void) sprintf(stv, "bad parameter value (%hd)", n);
SANDspError(stv);

return;
}

/*<<< sandsp.c: EOF */
