/*>>> sandrw.c: SAN project draw related utilities */

/* Revised: 1993.03.26 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanatk.h"
#include "sandrw.h"
#include "sanmlm.h"

/*--> SANDrawTestSmat: test for stalemate draw */
nonstatic
siT
SANDrawTestSmat(void)
{
siT flag;

SANMLEnsurePolice();
if ((curr_g.g_gmvc == 0) &&
	!SANAttack(curr_e.e_pasc, plv[curr_e.e_actc][kingslot]))
	flag = 1;
else
	flag = 0;

return (flag);
}

/*--> SANDrawTestIMat: test for insufficient material draw */
nonstatic
siT
SANDrawTestIMat(void)
{
siT flag;
siT wsm, bsm, ncpv[cpL];
cpT cp;
sqT sq;

/* assume no draw */

flag = 0;

/* scan */

for (cp = 0; cp < cpL; cp++)
	ncpv[cp] = 0;
for (sq = sq_a1; sq <= sq_h8; sq++)
	ncpv[gb.bv[sq]]++;
if ((ncpv[cp_wp] == 0) && (ncpv[cp_bp] == 0))
	if ((ncpv[cp_wr] == 0) && (ncpv[cp_br] == 0))
		if ((ncpv[cp_wq] == 0) && (ncpv[cp_bq] == 0))
			{
			/* no pawns or major pieces */

			wsm = (ncpv[cp_wb] > 1) ||
				((ncpv[cp_wb] == 1) && (ncpv[cp_wn] > 0)) ||
				((ncpv[cp_wb] == 0) && (ncpv[cp_wn] > 2));
			bsm = (ncpv[cp_bb] > 1) ||
				((ncpv[cp_bb] == 1) && (ncpv[cp_bn] > 0)) ||
				((ncpv[cp_bb] == 0) && (ncpv[cp_bn] > 2));
			if (!wsm && !bsm)
				flag = 1;
			};

return (flag);
}

/*<<< sandrw.c: EOF */
