/*>>> sanbap.c: SAN project Beal Auto Protocol (automated competition) */

/* Revised: 1993.05.16 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanbap.h"
#include "sandsp.h"
#include "sanmpu.h"
#include "sanmsc.h"
#include "sanrst.h"
#include "sansel.h"
#include "sanutl.h"

/* system prototype */

void sleep(unsigned int);

/* nonlocal prototypes */

int auto_startup(void);
int auto_readmove(int *move);
int auto_makemove(int move);

/* prototypes for local nonstatic functions */

void execmove_auto(int move);
void error_auto(char *string);

/*--> execmove_auto: execute an incoming move */
nonstatic
void
execmove_auto(int move)
{
mT m;

/* convert to internal format */

m = *SANBAPConvSI(move);

/* locate move in current list */

curr_g.g_curr = SANFindMove(&m);
if (curr_g.g_curr == NULL)
	SANFatal("execmove_auto: can't find move");

/* play the move */

SANPlayMove(curr_g.g_curr);

return;
}

/*--> error_auto: issue error message */
nonstatic
void
error_auto(char *string)
{
fprintf(stderr, "%s\n", string);

return;
}

/*--> SANBAPAuto: handle autoplay for the given color */
nonstatic
void
SANBAPAuto(cT c)
{
siT flag;
mT m;
siT msi;
int mi;

/* invoke protocol */

flag = (auto_startup() == 0);

/* play a game */

while (flag && (SANStatus() == gs_norm))
	{
	if (curr_e.e_actc == c)
		{
		/* select a move */

		SANSelect();
		m = select_m;
		SANPlayMove(&m);
		msi = SANBAPConvM(&m);
		flag = (auto_makemove(msi) == 0);
		}
	else
		{
		/* receive a move */

		if (auto_readmove(&mi) != 0)
			sleep(1);
		else
			{
			msi = mi;
			m = *SANBAPConvSI(msi);
			curr_g.g_curr = SANFindMove(&m);
			if (curr_g.g_curr == NULL)
				SANFatal("SANBAPAuto: bad input");
			SANPlayMove(curr_g.g_curr);
			};
		};
	};

/* check for abnormal completion */

if (!flag)
	SANDspError("Fault: autoplay: abnormal completion");

return;
}

/*--> SANBAPConvSI: convert a short int move represenation to a move */
nonstatic
mptrT
SANBAPConvSI(siT msi)
{
static mT m;

m.m_flag = 0;
m.m_frsq = msi & sqM;
m.m_frcp = gb.bv[m.m_frsq];
m.m_tosq = (msi >> sqQ) & sqM;
m.m_tocp = gb.bv[m.m_tosq];

switch ((msi >> sqsqQ) & 0x7)
	{
	case 0:
		m.m_scmv = scmv_reg;
		break;

	case 1:
		m.m_scmv = scmv_ppq;
		break;

	case 2:
		m.m_scmv = scmv_ppr;
		break;

	case 3:
		m.m_scmv = scmv_ppb;
		break;

	case 4:
		m.m_scmv = scmv_ppn;
		break;
	};

if (m.m_scmv == scmv_reg)
	{
	if ((m.m_frcp == cp_wk) && (m.m_frsq == sq_e1))
		{
		if (m.m_tosq == sq_g1)
			m.m_scmv = scmv_cks;
		if (m.m_tosq == sq_c1)
			m.m_scmv = scmv_cqs;
		};
	if ((m.m_frcp == cp_bk) && (m.m_frsq == sq_e8))
		{
		if (m.m_tosq == sq_g8)
			m.m_scmv = scmv_cks;
		if (m.m_tosq == sq_c8)
			m.m_scmv = scmv_cqs;
		};
	};

if (m.m_scmv == scmv_reg)
	if ((cv_p_cpv[m.m_frcp] == p_p) && (m.m_tosq == curr_e.e_epsq) &&
		(map_file_sq(m.m_frsq) != map_file_sq(curr_e.e_epsq)))
		m.m_scmv = scmv_epc;

return (&m);
}

/*--> SANBAPConvM: convert a move to a short int move represenation */
nonstatic
siT
SANBAPConvM(mptrT mptr)
{
siT msi;

msi = ((mptr->m_tosq << sqQ) | mptr->m_frsq);
switch (mptr->m_scmv)
	{
	case scmv_ppn:
		msi |= (4 << sqsqQ);
		break;

	case scmv_ppb:
		msi |= (3 << sqsqQ);
		break;

	case scmv_ppr:
		msi |= (2 << sqsqQ);
		break;

	case scmv_ppq:
		msi |= (1 << sqsqQ);
		break;

	default:
		break;
	};

return (msi);
}

/*<<< sanbap.c: EOF */
