PROGRAM FindDupLines;
CONST
     ProgData = 'FDUPLINS- Free DOS utility: text file duplicate line deleter.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

      Usage1 = 'Usage:  FDUPLINS source_file new_destination_file [/c[y|N]] [/d#]';
      Usage2 = ' where "/cy" is case sensitive, "/cn" is case insensitive, and';
      Usage3 = ' where "d#" is the number of characters at the beginning of the';
      Usage4 = ' line to disregard, e.g. - "/d5" ignores the first 5 characters.';
VAR
   PS1, PS2,
   Line_CA, Line_NA,
   ULine_Current, ULine_Next,
   Line_Current,Line_Next    : String;
   Source_File,Dest_File     : Text;
   CaseSens                  : Boolean;
   CParm                     : String;
   NumbDisChars, i           : Byte;

FUNCTION ConvertToUpper(w : String) : String;
VAR
   cp  : Integer;        {The position of the character to change.}
BEGIN
     FOR cp := 1 TO Length(w) DO
         w[cp] := UpCase(w[cp]);
     ConvertToUpper := w;
END;

PROCEDURE CaseSensitive;
BEGIN
     ReadLn(Source_File,Line_Next);

     Line_NA := Line_Next;
     Delete(Line_NA,1,NumbDisChars);

     WHILE NOT Eof(Source_File) DO
     BEGIN
           Line_Current  := Line_Next;
           Line_CA       := Line_NA;

           ReadLn(Source_File,Line_Next);

           Line_NA       := Line_Next;
           Delete(Line_NA,1,NumbDisChars);

           IF Line_CA <> Line_NA THEN
              WriteLn(Dest_File,Line_Current);
     END;
     WriteLn(Dest_File,Line_Next);
END;

PROCEDURE CaseInSensitive;
BEGIN
     ReadLn(Source_File,Line_Next);
     ULine_Next := ConvertToUpper(Line_Next);
     Line_NA := ULine_Next;
     Delete(Line_NA,1,NumbDisChars);

     WHILE NOT Eof(Source_File) DO
     BEGIN
           Line_Current  := Line_Next;
           Line_CA       := Line_NA;

           ReadLn(Source_File,Line_Next);
           ULine_Next    := ConvertToUpper(Line_Next);
           Line_NA       := ULine_Next;
           Delete(Line_NA,1,NumbDisChars);

           IF Line_CA <> Line_NA THEN
              WriteLn(Dest_File,Line_Current);
     END;
     WriteLn(Dest_File,Line_Next);
END;

FUNCTION StrToByte(s : String) : Byte;
VAR code : integer;
    mid  : byte;
BEGIN
     Val(s, mid, code);
     StrToByte := mid;
END;

BEGIN
     Writeln;
     Writeln(ProgData);
     Writeln(ProgDat2);
     Writeln;

     If (ParamCount < 2) THEN Begin
        Writeln(Usage1);
        Writeln(Usage2);
        Writeln(Usage3);
        Writeln(Usage4);

        Halt;
     End;
     PS1 := ParamStr(1);
     PS2 := ParamStr(2);

     Assign(Source_File,PS1);
{$I-} Reset(Source_File); {$I+}                    { Check if file exists.}
     IF (IOResult <> 0) THEN                       { If it                }
     BEGIN                                         {    doesn't, then     }
         Writeln('Unable to open "', PS1, '".');   {  quit with message.  }
         Halt;
     END;

     Assign(Dest_File,PS2);
{$I-} Reset(Dest_File);  {$I+}
      IF (IOResult <> 0) Then Begin
         Rewrite(Dest_File);
      End
      Else Begin
Writeln('Destination "',PS2,'" exists!  Rename, delete, or specify alternate.');
         Halt;
      End;

     CaseSens     := False;
     NumbDisChars := 0;

     For i := 3 to ParamCount DO
     Begin
      CParm := ParamStr(i);
      Case CParm[2] of
      'c' :   CaseSens     := ((CParm[3] = 'y') OR (CParm[3] = 'Y'));
      'C' :   CaseSens     := ((CParm[3] = 'y') OR (CParm[3] = 'Y'));
      'd' :   NumbDisChars := StrToByte(Copy(ParamStr(i),3,3));
      'D' :   NumbDisChars := StrToByte(Copy(ParamStr(i),3,3));
      End;
     End;

     Writeln('Source: ',Ps1,'; Destination: ',Ps2,'.');
     Writeln('Case Sensitive: ',CaseSens,'; Disregarded Chars: ',NumbdisChars,'.');

     If CaseSens Then
        CaseSensitive
     Else
        CaseInSensitive;

     Close(Source_File);
     Close(Dest_File);
     Writeln('Done!');
END.
