{*************************************************************************}
{ Report Printer Collection - written by Jim Gunkel                       }
{ Copyright (c), 1995, Nevrona Designs, all rights reserved               }
{*************************************************************************}

unit RPReg;


interface

uses
  Classes,
  DsgnIntf,
  Dialogs,
  SysUtils,
  TypInfo,
  RPBase,
  RPFiler,
  RPCanvas,
  RPrinter,
  RPFPrint,
  RPreview;

type
  TNewFloatProperty = class(TFloatProperty)
  public
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end; { TNewFloatProperty }

  procedure Register;

implementation

  function TNewFloatProperty.GetValue: string;

  const
    Precisions: array[TFloatType] of Integer = (7,15,17,17);

  begin { GetValue }
    Result := FloatToStrF(GetFloatValue,ffGeneral,
     Precisions[GetTypeData(GetPropType)^.FloatType],0);
  end;  { GetValue }


  procedure TNewFloatProperty.SetValue(const Value: string);

  var
    FloatVar: extended;
    ErrCode: integer;

  begin { SetValue }
    Val(Value,FloatVar,ErrCode);
    If ErrCode <> 0 then begin
      MessageDlg('"' + Value + '" is not a valid floating point.',mtError,
       [mbOk],0);
    end else begin
      SetFloatValue(FloatVar);
    end; { else }
  end;  { SetValue }

  procedure Register;

  begin { Register }
    RegisterPropertyEditor(TypeInfo(single),nil,'',TNewFloatProperty);
    RegisterPropertyEditor(TypeInfo(double),nil,'',TNewFloatProperty);
    RegisterPropertyEditor(TypeInfo(extended),nil,'',TNewFloatProperty);
    RegisterPropertyEditor(TypeInfo(comp),nil,'',TNewFloatProperty);
    RegisterComponents('Report',[TReportPrinter,TReportFiler,TFilePrinter,
     TFilePreview]);
  end;  { Register }


end. { RPReg }
