#!../bin/i386-linux/RPGwish -f
catch "destroy .c"
canvas .c -width 400 -height 700 -background {white}
pack .c
set bitmaps { {{text BM} Name Size Description}
              {{bitmap Center} Center {30x30} {Used for center (up/down) 
movement button}}
              {{bitmap Down} Down {30x30} {Used for down (south)
movement button}}
              {{bitmap DownLeft} DownLeft {30x30} {Used for downleft (southwest)
movement button}}
              {{bitmap DownRight} DownRight {30x30} {Used for downright (southeast)
movement button}}
              {{bitmap Up} Up {30x30} {Used for up (north)
movement button}}
              {{bitmap UpLeft} UpLeft {30x30} {Used for upleft (northwest)
movement button}}
              {{bitmap UpRight} UpRight {30x30} {Used for upright (northeast)
movement button}}
              {{bitmap Left} Left {30x30} {Used for left (west)
movement button}}
              {{bitmap Right} Right {30x30} {Used for right (east)
movement button}}
              {{bitmap door} door {16x16} {Used for door exits}}
	      {{bitmap doorlocked} doorlocked {16x16} {Used for doorlocked exits}}
	      {{bitmap dooroneway} dooroneway {16x16} {Used for dooroneway exits}}
	      {{bitmap doorsecret} doorsecret {16x16} {Used for doorsecret exits}}
	      {{bitmap rampdown} rampdown {16x16} {Used for rampdown exits}}
	      {{bitmap rampup} rampup {16x16} {Used for rampup exits}}
	      {{bitmap stairsdown} stairsdown {16x16} {Used for stairsdown exits}}
	      {{bitmap stairsup} stairsup {16x16} {Used for stairsup exits}}
	   }

set ypos 5
.c create line 5 $ypos 394 $ypos -width 2 
incr ypos 5
set line 1
foreach l $bitmaps {
  set graphic [lindex $l 0]
  set name    [lindex $l 1]
  set size    [lindex $l 2]
  set descr   [lindex $l 3]
  set tag "Line$line"
  if {$graphic != {}} {
    set gtype [lindex $graphic 0]
    set gparm [lindex $graphic 1]
    if {$gtype == {rect}} {
      .c create rectangle 10 $ypos [expr 10 + $gparm] [expr $ypos + $gparm] \
			  -fill white -tag $tag
    } elseif {$gtype == {bitmap}} {
      .c create bitmap 10 $ypos -bitmap $gparm -background white \
			-foreground black -anchor nw -tag $tag
    } elseif {$gtype == {text}} {
      .c create text 10 $ypos -text "$gparm" -anchor nw -tag $tag
    }
  }
  .c create text 50 $ypos -anchor nw -text "$name" -tag $tag
  .c create text 150 $ypos -anchor nw -text "$size" -tag $tag
  .c create text 200 $ypos -anchor nw -text "$descr" -tag $tag
  set bbox [.c bbox $tag]
  set ypos [expr [lindex $bbox 3] + 5]
  .c create line 5 $ypos 394 $ypos -width 2 
  incr ypos 5
  incr line
}
.c configure -height $ypos
.c create line 5 5 5 [expr $ypos - 5]  -width 2
.c create line 45 5 45 [expr $ypos - 5]  -width 2
.c create line 145 5 145 [expr $ypos - 5]  -width 2
.c create line 195 5 195 [expr $ypos - 5]  -width 2
.c create line 394 5 394 [expr $ypos - 5]  -width 2
update idletasks
.c postscript -file bitmaps.ps -pageheight 6.75i


