@echo off

REM  Called by Rombrain to read or transfer a file from within an archive
REM  %1 = Full Path/Name of the Archive File to process
REM  %2 = Type of Archive: ARC, ZIP, ARJ, LZH, PAK, etc.
REM  %3 = Name of the file to extract or Read from the Archive
REM  %4 = Destination Work Directory and Filename
REM  %5 = View, Read or Transfer Flag

if %5 == VIEW goto view

if %2 == ZIP goto ExtractZip
if %2 == EXE goto ExtractZip
if %2 == ARC goto ExtractArc
if %2 == LZH goto ExtractLzh
if %2 == ARJ goto ExtractArj
goto end


:ExtractZip
pkunzip /o %1 %3 %4
goto end

:ExtractArc
pkunpak -r %1 %3 %4
goto end

:ExtractArj
arj e %1 %3 %4
goto end

:ExtractLzh
lha e %1 %3 %4
goto end

:view
if %2 == ZIP goto ViewZip  
if %2 == EXE goto ViewZip
if %2 == ARC goto ViewArc
if %2 == LZH goto ViewLzh
if %2 == ARJ goto ViewArj
goto end

:ViewZip
pkunzip -v %1 >%4
goto end

:ViewArc
pkunpak -v %1 >%4
goto end

:ViewArj
arj v %1 >%4
goto end


:ViewLzh
lha %1 >%4

:end
