{Ŀ
                    * ROK Player File Structures *  
                                                                      
                                     ROK, created byDevon Brooks, of 
                                     Blazing Fire Software - (C)1997 
                                                           
                                     Distribute Freely To Everyone!  
                                                                     
                                    Create External EGO's, Utilities 
                              for the SysOp, Bulletins, etc!  
 }

{Hi there!I'm Devon Brooks, the Author of ROK.  I'm writing this STRUCTS.PAS }
{ file for 3rd Party Authors to create stuff for ROK.  Feel free to charge    }
{ anything you wish for your program -- we do not require any "Royalty"fee on }
{ 3rdParty Programs -- so ask for a registration that you see fit.       }

{ NOTE - These structs and the following information is based on a programming }
{        language called "Turbo Pascal". If you do not have this language, you }
{        will have to somehow convert these records into your own format.      }

{ Hey, you want to write an EGO?  Excellent!  It is really quite simple.  It's }
{ basically a three step process, like this:                                   }
{                     1. Read in ROKINFO.<x>, where <x> is the node number of  }
{                        the current online user.                              }
{                     2. Load up the PLAYER.DAT file, and find the player name }
{                        that matches the name in the ROKINFO.<x> file.        }
{                     3. That's it!  You're on your way -- start your program! }

{ In future versions of ROK, possibly the next version, an EGO Development Kit }
{ will be included in the ROKV*.ZIP Archive to help 3rd Party Authors create a }
{ ROK EGO, or any other program relating to ROK.   Unfortunately, for now, you }
{ are basically on your own.   Here are a few tips to help you out in creating }
{ your own program for ROK :                                                   }

{ 1. Download a copy of the latest version of DDPlus - DDPLUS71.ZIP. It should }
{    be available from almost any BBS system in your area, or somewhere on the }
{    Internet.  We used DDPlus to create ROK. It is a simple to use DoorDriver }
{    which should easily take care of most of your problems with your program. }
{ 2. To trap errors in your program I suggest using a Unit that is included in }
{    the DDPLUS71.ZIP Archive - ELOG.PAS. It will trap and log all errors that }
{    might occur in your program, and will help you in finding the cause.      }
{ 3. Ask one of your friends who knows TP, or someone in the FidoNet Echo, for }
{    a procedure which will save bad error exits.  What this means is that if, }
{    for some reason, your program has an error and halts - it will not save a }
{    user's new information.   With a procedure/function at the end to save no }
{    matter what type of an exit, your program will run much smoother, regard- }
{    less of what happens while inside the program.  If you cannot find such a }
{    procedure/function, contact Devon Brooks, the Author of ROK, and he might }
{    be able to give you the same procedure that is used to trap exits in ROK. }
{ 4. There is nothing more that we can really help you out in.    Turbo Pascal }
{    programming experience would be nice - but, the Author of ROK started his }
{    first program in Turbo Pascal when he had NO previous experience.   Thus, }
{    even if you have never looked at TP before you can learn it quite easily. }
{    If you want some assistance from the ROK Author, feel free to contact him }
{    anytime.  There are quite a few different ways, as listed in CONTACT.DOC, }
{    which would be included in the same archive of which you found this file. }

{ All user variables in PLAYER.DAT are commented here for your convenience.    }

Type UserRecord = Record

RealName         : String[40]; {User Name from BBS DropFile}
Alias            : String[30]; {User's Alias in ROK}
Date             : String[15]; {Today's Date}
TimesOn          : Integer;    {Number of times this player has played}
OnNow            : Integer; {equals one if online, else 0}
Dead             : Integer; {0 = alive, 1 = dead}
King             : Boolean; {Yes = player is king, else not king}
TaxToday         : Boolean; {Has this player paid the taxes today?}
Jailed           : Boolean; {Is this player jailed for trying to bribe TaxMan?}
Hand_Gold        : LongInt; {Gold On Hand}
Bank_Gold        : LongInt; {Gold In Bank}
Hit_Points       : LongInt; {Current Hit Points}
Hit_Points_Max   : LongInt; {Maximum Possible Hit Points}
Sleeping         : Integer; {0 if out in open, 1 if in inn, 2 if in palace}
Social_Ranking   : Integer; {1 if squire, 2 if duke, 3 if prince}
                            {4 if squiress, 5 if dutchess, 6 if princess}
Sex              : Integer; {1 if male, 2 if female}
Player_Fights    : Integer; {Player vs. Player battles remaining today}
Field_Fights     : Integer; {Field fights remaining today}
Flirted          : Boolean; {True if flirted with Hope/Logan today}
Charisma         : Integer; {Good looking o-meter}
Strength         : LongInt; {Player's strength}
Defense          : LongInt; {Player's defense}
Experience       : LongInt; {Player's experience}
Level            : Integer; {Player's current level (Max is 20)}
Weapon_Num       : Integer; {Weapon Number, corresponds to Weapon_Name}
Weapon_Name      : String[20]; {Name of the weapon player is using}
Armour_Num       : Integer; {Armour Number, corresponds to Armour_Name}
Armour_Name      : String[20]; {Name of the armour player is using}
Married_Hope     : Boolean; {True if this player is married to Hope}
Hope_Loyalty     : Integer; {Hope's loyalty to stay with that player}
Married_Logan    : Boolean; {True if this player is married to Logan}
Logan_Loyalty    : Integer; {Logan's loyalty to stay with that player}
Flirted_Player   : Boolean; {Has this player mail flirted with another?}
Married_To       : Integer; {-1 if not married, account = who they're married to}
Seen_Guild_Story : Boolean; {Has player viewed Astradam's Guild Story?}
Guild_Number     : Integer; {1 if Paladin Guild, 2 if Clerical Guild,
                            {3 if Sorcerer Guild, 4 if Assassin Guild,
                            {5 if Warrior Guild}
Guild_Master     : Integer; {Equals the number of the Guild that the
                            {player belongs to if he/she is guildmaster}
Prayed           : Boolean; {Paladin's Guild - Have they prayed today?}
Spells_Chosen    : Integer; {Number of Spells the P. GuildMaster has chosen}
Spells_Remaining : Integer; {Number of Spells the P. GuildMaster has left}
Paladin_Skill    : Integer; {Rate of Magical Skill the Paladin is at}
Paladin_Spell_1  : Integer; {Paladin's Guild - Player's First Spell}
Paladin_Spell_2  : Integer; {Paladin's Guild - Player's Second Spell}
Paladin_Spell_3  : Integer; {Paladin's Guild - Player's Third Spell}
Cleric_Skill     : Integer; {Rate of Magical Skill the Cleric is at}
Cleric_Spell_1   : Integer; {Cleric's Guild - Player's First Spell}
Cleric_Spell_2   : Integer; {Cleric's Guild - Player's Second Spell}
Cleric_Spell_3   : Integer; {Cleric's Guild - Player's Third Spell}
Cleric_Spell_4   : Integer; {Cleric's Guild - Player's Fourth Spell}
Cleric_Spell_5   : Integer; {Cleric's Guild - Player's Fifth Spell}
Sorcerer_Skill   : Integer; {Rate of Magical Skill the Sorcerer is at}
Sorcerer_Spell_1 : Integer; {Sorcerer's Guild - Player's First Spell}
Sorcerer_Spell_2 : Integer; {Sorcerer's Guild - Player's Second Spell}
Sorcerer_Spell_3 : Integer; {Sorcerer's Guild - Player's Third Spell}
Sorcerer_Spell_4 : Integer; {Sorcerer's Guild - Player's Fourth Spell}
Sorcerer_Spell_5 : Integer; {Sorcerer's Guild - Player's Fifth Spell}
Assassin_Skill   : Integer; {Rate of Technique Skill the Assassin is at}
Assassin_Tech_1  : Integer; {Assassin's Guild - Player's First Technique}
Assassin_Tech_2  : Integer; {Assassin's Guild - Player's Second Technique}
Assassin_Tech_3  : Integer; {Assassin's Guild - Player's Third Technique}
Used_A_Tech_1    : Boolean; {Assassin's Guild - Has player used Tech #1 Today?}
Used_A_Tech_2    : Boolean; {Assassin's Guild - Has player used Tech #2 Today?}
Used_A_Tech_3    : Boolean; {Assassin's Guild - Has player used Tech #3 Today?}
Warrior_SKLeft   : Integer; {Number of points unused for transfer in WGuild}
LepStory         : Boolean; {Has this player seen Kirin's story?}
Sk_Left          : Integer; {Guild Skills left for today}
OnToday          : Boolean; {Has this player played ROK yet today?}
Master_Fight     : Boolean; {Fought Level Master and Lost/Ran yet today?}
Atma_Fought      : Boolean; {Has this player fought Atma yet today?}
Committed_Suicide: Boolean; {Has this player committed suicide?}
Days_Suicide     : Integer; {Days left to play again after comitting suicide}
Robbed_Bank      : Boolean; {Has this player Robbed the Bank today?}
Voted            : Boolean; {Has player voted on EGO yet today?}
Seen_Book        : Boolean; {Has player seen the Book of Many Secrets yet today?}
Resurrected      : Boolean; {Has player resurrected another player already today?}
Cursed           : Integer; {0 = Normal, 1 = Cursed, 2 = Blessed}

End;

{ Below is the record structure for the 200 monsters in ROK. (ROKMON.DAT)      }

MonData = Record

Name     : String[40]; { Monster's name }
Weapon   : String[40]; { Monster's weapon name }
Strength : LongInt;    { It's strength }
Gold     : LongInt;    { Gold reward to player when killed }
Exp      : LongInt;    { Experience reward to player when killed }
HP       : LongInt;    { Total Hit Points of monster }

End;

{ Below is the record structure for the Level Masters in ROK. (TRAINER.DAT)    }

TrainData = Record

Exp      : LongInt;    { Experience required before player can challenge him }
Name     : String[40]; { Level Master's name }
Weapon   : String[40]; { Name of Master's weapon }
Strength : LongInt;    { Master's strength }
Defense  : LongInt;    { It's defense }
HP       : LongInt;    { Total Hit Points of the Master }

End;

{ Here is the record file structure for the Gangs in ROK (GANGS.DAT).  }

GangData = Record

First_Member  : String[15]; { Name of the first member of the Gang }
Second_Member : String[15]; { Name of the second member }
Third_Member  : String[15]; { Name of the third member }
Password      : String[15]; { Password to enter this Gang }
Combined_XP   : LongInt;    { Combined experience of all members }
Gang_Name     : String[15]; { Name of the Gang }

End;

{ Lastly, below is the record structure for EGO's. (EGOS.DAT)                  }

EGOData = Record

EGO_Name   : String[40]; { Name of the EGO }
EGO_Path   : String;     { Path to EGO Executable }
EGO_Cost   : LongInt;    { Cost for Kingdom to construct EGO }
EGO_Built  : Boolean;    { Is this EGO built yet? }
EGO_Desc1,
EGO_Desc2,
EGO_Desc3,
EGO_Desc4  : String[75]; { A four-line max description of this EGO }

End;

{ SOME INFORMATION REGARDING EGO DEVELOPMENT:                                  }
{ We at BFS want to stress the importance of following the set guidelines for  }
{ EGO developers.  When creating your EGO, keep these points in mind:          }
{                             1. A Maximum of 10 EGO's can be in the EGOS.DAT  }
{                                file.  When installing your EGO, check to see }
{                                if 10 EGO's are already installed, to prevent }
{                                possible mix-ups.
{                             2. Please have an option for an uninstall of     }
{                                your EGO.  This must take out ALL the info    }
{                                that your installation procedure entered into }
{                                the EGOS.DAT file -- including description,   }
{                                path, and everything else.                    }
{                             3. One thing to remember upon installation of    }
{                                your EGO is to check if it's already been     }
{                                installed.  Always a good thing.              }
{ That's it!  Or, at least, that's all we can think of at this point.  To get  }
{ your EGO/Utility/3rdParty product on the list in EGOLIST.TXT, refer to the   }
{ bottom of that file for more information.                                    }

{ Well, that's all of them!  As mentioned above, if you require assistance in  }
{ regards to the structs shown here, please feel free to contact us anytime.   }

{ Please refer to the EGOLIST.TXT file, included in this archive, for more EGO }
{ and other 3rdParty related products. For your product to be recognized by us }
{ in the EGOLIST.TXT, you must receive the "BFS Stamp of Approval".  More info }
{ is given at the bottom of EGOLIST.TXT.                                       }

{ Best of luck to you and your program(s) from all of us at BFS!               }
{                                                           - The BFS guys     }

Begin
End.
