{$M 4096,0,0}{$I-}
Program Convert_ROBOMAIL_Textfiles_to_QWK;
Uses CRT, DOS;
Const MaxBytes = 61440;
Type  ROBOarray = Array[1..MaxBytes] of char;

Const cursorState : byte = 1;  {0..3}
      cursorData : array [0..3] of char = (#179, #47, #196, #92);
      lineNumb : longint = 0;  MSGnum : word = 0;
{===========================================================================}

procedure cursorOff; forward;
procedure cursorOn; forward;
function IntToStr(const vint: longint): string; forward;

procedure showhelp(const problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
const
  progdesc = 'RoboQ - Free DOS utility: Convert Robomail "Text files" to pseud-QWK files.';
  author   = 'v1.00: February 17, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage: RoboQ <Robomail "Text file(s)">  (DOS wildcards are permitted.)';
  example  = 'Example:  RoboQ startrek.msg            (creates "STARTREK.RBQ")';
var
  message : string[79];
begin
  writeln;
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  writeln(example);   writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'Command line error: no files matching specification found to process.';
      2 : message := 'A MESSAGES.DAT file already exists.  Move, REName, or DELete it.';
      3 : message := 'A RBQ with the same name as the "Text file" exists.  Move, REName or DELete it.';
      4 : message := 'Invalid header portion encountered around line number: '+IntToStr(lineNumb)+' - fix file!';
      5 : message := 'Error archiving MESSAGES.DAT - try archiving it manually.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Unexpected error reading or writing file(s), unable to continue.';
    else  message := 'Unknown error.';
    end;
    writeln (#7, 'Error encountered:'); writeln (message);
  end;
  cursorOn;
  halt(problem)
end;

procedure cursorOff;assembler;asm
  mov ah,3; mov bh,0; int $10; or ch,$20; mov ah,1; int $10;
end;

procedure cursorOn;assembler;asm
  mov ah,3; mov bh,0; int $10; and ch,not $20; mov ah,1; int $10;
end;

function IntToStr(const vint: longint): string;
var s: string;
begin
  Str(vint, s);
  IntToStr := s;
end;

Function LeadingZero(w : Word) : String;
Var
  s : String[2];
Begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
End;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then showhelp(7);
end;

function fileexists(const filename:pathstr):boolean;
var
  attr : word;
  f    : file;
begin
  assign (f, filename);
  getfattr (f, attr);
  if (DOSerror <> 0) OR ((attr and directory) = directory) then
    fileexists := FALSE
  else
    fileexists := TRUE;
end;

procedure updateCursor;  {code written by Sean Palmer, found in SWAG}
begin
  cursorState := succ(cursorState) and 3;
  write(cursorData[cursorState], ^H);
end;

Function RPad(bstr: string; Const len: byte): string;
Begin
  while (length(bstr) < len) do
    bstr := bstr + #32;
  RPad := bstr;
End;

Function StrToDoubleChar(ROBOconf: string): string;
Var
  i, VErr : integer;
Begin
  while ROBOconf[1] = #32 do
    ROBOconf := Copy(ROBOconf,2,length(ROBOconf)-1);
  Val(ROBOconf,i,VErr);
  if (VErr <> 0) then i := 0;
  ROBOconf := Chr(i mod 256) + Chr(i div 256);
  StrToDoubleChar := ROBOconf;
End;

Procedure PrepareFiles(var ROBOname: pathstr; var ROBOfile: text;
                       var DATname: string; var DATfile: file);
Const
  QmailLine : Array[1..128] of char =
          'Produced by Qmail...Copyright (c) 1995 by ReignWare.  All Rights'+
          ' Reserved       Above for Compatibility with Qmail              ';

Var ROBOnameQ: pathstr;

Begin
  DATname := 'MESSAGES.DAT';
  if fileexists(DATname) then showhelp(2);

  if NOT fileexists(ROBOname) then showhelp(1);
  Assign(ROBOfile,ROBOname);
  Reset(ROBOfile); iocheck(ioresult);

  ROBOnameQ := ROBOname;
  if (pos('.', ROBOnameQ) > 0) then
    ROBOnameQ := Copy(ROBOnameQ, 1, pos('.', ROBOnameQ) - 1);
  if fileexists(ROBOnameQ+'.rbq') then showhelp(3);

  cursorOff;
  Write('Converting ', ROBOname, ' to MESSAGES.DAT, please wait ... ');
  ROBOname := ROBOnameQ;

  Assign(DATfile,DATname);
  Rewrite(DATfile,1); iocheck(ioresult);
  BlockWrite(DATfile, QmailLine, 128); iocheck(ioresult);
End;

Function GetROBOdate(datestr: string): string;
Begin
  datestr[3] := #45;  { replace '/' with '-' }
  datestr[6] := #45;
  GetROBOdate := datestr;
End;

Function GetROBOstat(Const ROBOstat: string): string;
Begin
  if ROBOstat = 'u' then
    GetROBOstat := #32   { unread, public }    (*  ' ' = public, unread   *)
  else                                         (*  '-' = public, read     *)
    GetROBOstat := #43;  { unread, private }   (*  '+' = private, unread  *)
                                               (*  '*' = private, read    *)
End;

function ExtractCNum(dataline: string): string;
begin
  if (pos(' - ',dataline) > 0) then begin
    Delete(dataline,1,2+pos(' - ',dataline));
    if (pos(' - ',dataline) > 0) then
      dataline := Copy(dataline,1,pos(' - ',dataline)-1)
    else
      dataline := '0';
  end
  else
    dataline := '0';
  ExtractCNum := dataline;
end;

Function Verify(Const control, variable: string; const offset: byte): BOOLEAN;
Begin
  if (Copy(control,offset,length(variable)) <> variable) then
    showhelp(4)
  else
    Verify := TRUE;
End;

Function ReadROBOheader(var ROBOfile: text): string;
Const hyphens='-----------------------------------'+
              '-----------------------------------';
  ROBOpass = #32#32#32#32#32#32#32#32#32#32#32#32; { 12 spaces }
  ROBOchnk = #32#32#32#32#32#32;  { 6 spaces }
Var
  ROBOline: string;
  ROBOfrom, ROBOto, ROBOsubj: string[25];
  ROBOdate: string[8];  ROBOtime: string[5];
  ROBOnumb: string[7];  ROBOrfer: string[8];
  ROBOconf: string[5];  ROBOstat: string[1];
Begin
  repeat
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
  until (EOF(ROBOfile)) OR (Copy(ROBOline,1,8)=('Origin: '));
  if EOF(ROBOfile) then
    ReadROBOheader := ''
  else begin
        ROBOconf := StrToDoubleChar(ExtractCNum(ROBOline));
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
      Verify(ROBOline,'    To:', 1);
        ROBOto := RPad(Copy(ROBOline,9,length(ROBOline)-8),25);
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
      Verify(ROBOline,'  From:', 1);
        ROBOfrom := Copy(ROBOline,9,25);
        ROBOstat := GetROBOstat(ROBOline[40]);
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
      Verify(ROBOline,'  Date:', 1);
        ROBOdate := GetROBOdate(Copy(ROBOline,9,8));
        ROBOtime := Copy(ROBOline,21,5);
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
      Verify(ROBOline,'    Re:', 1);
        ROBOsubj := RPad(Copy(ROBOline,9,length(ROBOline)-8),25);
    readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
      Verify(ROBOline, hyphens, 1);
        {discard hyphen line}

    Inc(MSGnum);
      Str(MSGnum,ROBOnumb);
      ROBOnumb := RPad(ROBOnumb,7);
      ROBOrfer := RPad('0',8);

    ReadROBOheader := (ROBOstat+ROBOnumb+ROBOdate+ROBOtime+  {  1+7+8+5 = 21 }
                       ROBOto+ROBOfrom+ROBOsubj+             { 25+25+25 = 75 }
                       ROBOpass+ROBOrfer+ROBOchnk+#225+      { 12+8+6+1 = 27 }
                       ROBOconf+#0#0#42);                    { 2+3      =  5 }
  end;
End;

Function AddToArray(var ROBOmsg: ROBOarray;
                    Const offset: word; Const line: string): word;
Var
  index: word;
Begin
  if (length(line) > 0) then begin
    for index := (offset+1) to (offset+length(line)) do begin
      if (index <= MaxBytes) then
        ROBOmsg[index] := line[index-offset];
    end
  end
  else index := offset;
  if (index > 128) and (index < MaxBytes) then begin
    Inc(index);
    ROBOmsg[index] := #227;
  end;
  AddToArray := index;
End;

function FigureMSGsize(const bytes: word; var chunks: word): string;
var
  ROBOchnk : string[6];
Begin
  chunks := (bytes div 128);
  if ((bytes mod 128) <> 0) then inc(chunks);
  Str(chunks, ROBOchnk);
  ROBOchnk := RPad(ROBOchnk,6);
  FigureMSGsize := ROBOchnk;
End;

procedure InitCompressor(var Compressor: pathstr);
var
  epath, cpath  : pathstr;
    {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: dirstr; ename: namestr; eext: extstr;
  config        : text;
  configline    : string[80];
begin
  epath := (paramstr (0));
  fsplit(fexpand(epath),edir,ename,eext); { break up path into components }
  cpath := edir+ename+'.cfg';

  Compressor := 'pkzip -# -m';
  if fileexists(cpath) then
  begin
    assign (config, cpath);
    reset (config); iocheck(ioresult);
    repeat  { find vars }
      readln(config,configline);
      if (length(configline) > 11) and
        (copy(configline,1,11) = 'compressor=') then
        Compressor := Copy(configline,12,length(configline)-11);
    until eof(config); { loop back to read another line }
    close (config);
  end;
end;

function CompressDAT(const QWKfile, DATfile: string;
                     Const Compressor: pathstr): boolean;
var
  x,y : byte;
begin
  x:=WhereX;
  y:=WhereY;
  write('> ',Compressor);
  swapvectors;
     exec (getenv ('COMSPEC'),' /c '+compressor+' '+QWKfile+' '+DATfile);
     if doserror <> 0 then showhelp(5);
  swapvectors;
  GotoXY(x,y);
  ClrEOL;
  cursorOff;
  CompressDAT := fileexists(QWKfile)
end;
{===========================================================================}

Label CLEANUP;

Const SepLine='<*>';

Var
  ROBOname: pathstr;  DATname: string;
  ROBOfile: text;     DATfile: file;
  ROBOline: string;   ROBOmsg : ROBOarray;
  index, bytes, chunks: word;
  Compressor : pathstr;

  dirinfo   : searchrec;  { contains filespec info.    }
  spath     : pathstr;    { source file path,          }
  sdir      : dirstr;     {             directory,     }
  sname     : namestr;    {             name,          }
  sext      : extstr;     {             extension.     }
  filesdone : word;

begin
  if paramcount <> 1 then
    showhelp(0)
  else
    spath := ParamStr(1);

  if spath[1] in ['/','-'] then showhelp(0);
  fsplit(fexpand(spath),sdir,sname,sext); if (sname = '')  then showhelp(6);
  findfirst(spath, archive, dirinfo);

  filesdone := 0;
  while (DOSerror = 0) do begin
     inc(filesdone);
     ROBOname := sdir+dirinfo.name;
     PrepareFiles(ROBOname, ROBOfile, DATname, DATfile);

     ROBOline := SepLine;
     repeat
       if (ROBOline = SepLine) and (NOT EOF(ROBOfile)) then begin
         bytes := 0;  updateCursor;
         ROBOline := ReadROBOheader(ROBOfile);
         if ROBOline = '' then goto CLEANUP;

         while (ROBOline <> SepLine) and (NOT EOF(ROBOfile)) do begin
           if (bytes < MaxBytes) then
             bytes := AddToArray(ROBOmsg, bytes, ROBOline);
           readln(ROBOfile,ROBOline); iocheck(ioresult); inc(lineNumb);
         end;
         if (bytes > MaxBytes) then bytes := MaxBytes;

         index := AddToArray(ROBOmsg, 116, FigureMSGsize(bytes, chunks));
         if (chunks > 1) then begin
           for index := (bytes+1) to (chunks*128) do
             ROBOmsg[index] := #32;
         end;

         BlockWrite(DATfile, ROBOmsg, chunks*128); iocheck(ioresult);
       end
       else begin
         readln(ROBOfile); iocheck(ioresult); inc(lineNumb); {discard invalid lines}
       end;
       CLEANUP:
     until EOF(ROBOfile);

     Close(ROBOfile); iocheck(ioresult);
     Close(DATfile); iocheck(ioresult);
     writeln('done!');

     InitCompressor(Compressor);
     write('Compressing MESSAGES.DAT into ',ROBOname,'.rbq ... ');
     if CompressDat(ROBOname+'.rbq', DATname, Compressor) then
       writeln('done!')
     else
       showhelp(5);

     findnext(dirinfo);
  end;
  if (filesdone=0) then
    showhelp(1)
  else
    writeln('Processed ', filesdone, ' file(s).');

  cursorOn
end.
