{$S-,R-,F-,I-}

{$IFDEF DPMI}
  Error - this program must be compiled as a real mode target
{$ENDIF}
{$IFDEF Windows}
  Error - this program must be compiled as a real mode target
{$ENDIF}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{$IFDEF Tracing}
{$M 4096, 0, 32768}
{$ELSE}
{$M 4096, 0, 16384}
{$ENDIF}

{.$DEFINE Debug}    {Define for a debugging report}

program RemoteControl;
  {-Remote control program, lets remote computer control this computer}

uses
  {-----RTL}
  Dos,
  {-----APRO}
  Dpmi,
  ApMisc,
  ApPort,
  ApUart,
  ApCom;

const
  {Configuration}
  ModeToggleChar : Char = ^U;           {Toggles between DOS and block mode}
  PgmName : PathStr = '';               {Program to EXEC}
  LinesPerTic = 2;                      {Number of lines checked each tick}
  ScreenWidth = 80;                     {Screen forced to 80x25}
  ScreenHeight = 25;                    {Current screen height}
  {$IFDEF Debug}
  Int08StackSize = 8192;                {Clock stack size}
  {$ELSE}
  Int08StackSize = 3082;                {Clock stack size}
  {$ENDIF}
  Int10StackSize = 1024;                {BIOS write clock size}

type
  {Screen array}
  ScreenChar = record
    C : Char;
    A : Byte;
  end;
  ScreenLine = array[1..80] of ScreenChar;
  ScreenArray = array[1..25] of ScreenLine;
  ScreenPtr = ^ScreenArray;

  {Misc.}
  String8 = String[8];
  String14 = String[14];
  Dummy5 = array[1..5] of Word;
  IntRegisters =
    record
      case Byte of
        1 : (BP, ES, DS, DI, SI, DX, CX, BX, AX, IP, CS, Flags : Word);
        2 : (Dummy : Dummy5; DL, DH, CL, CH, BL, BH, AL, AH : Byte);
    end;

var
  ComPort : PortRecPtr;                          {COM port}
  Screen : ScreenArray;                          {Saved screen image}
  Int08Stack : array[1..Int08StackSize] of Byte; {Clock ISR stack}
  Int10Stack : array[1..Int10StackSize] of Byte; {Clock ISR stack}
  RealScreen : ScreenPtr;                        {Pointer to physical screen}
  ExitSave : Pointer;                            {Our exit procedure}
  OurVector : Pointer;                           {Our installed serial vector}
  CurVector : ^Pointer;                          {Pointer to replaced vector}
  BaseAddr : Word;                               {Our base address}

  {$IFDEF Debug}
  DebugIndex : Word;
  DebugArray : array [1..500] of String[90];
  {$ENDIF}

const
  {Initialized variables}
  CurrentAttr : Byte = 0;                {Last attribute we sent}
  OrigInt10 : Pointer = nil;             {Old int 10 vector}
  OrigInt08 : Pointer = nil;             {Old int 08 vector}
  AnsiPrefix = #27'[';                   {Standard ANSI escape prefix}
  BlockMode : Boolean = False;           {True for block mode}
  ComX : ComNameType = Com2;             {Com port}
  Baud : LongInt = 9600;                 {Baud rate}
  BaudSpecified : Boolean = False;       {True if /B on command line}
  MonitorDCD : Boolean = False;          {True to reboot on dropped carrier}

{$L RMTCTL.OBJ}
{$F+}
procedure EmulateInt(var Regs : IntRegisters; IntAddr : Pointer); external;
{$F-}

procedure IntOff; inline($9C/$FA);      {PUSHF/CLI}
procedure IntOn; inline($9D);           {POPF}

procedure Abort(Msg : String);
  {-Show message and stop}
begin
  WriteLn(Msg);
  Halt;
end;

procedure Reboot;
  {-Reboot the machine}
  inline(
    $B8/$40/$00/             {mov ax,$40}
    $8E/$D8/                 {mov ds,ax}
    $C7/$06/$72/$00/$34/$12/ {mov word ptr [$0072],$1234}
    $EA/$00/$00/$FF/$FF);    {jmp far $FFFF:$0000}

function Long2Str(L : LongInt) : string;
  {-Convert a long/word/integer/byte/shortint to a string}
var
  S : string;
begin
  Str(L, S);
  Long2Str := S;
end;

function CompStruct(var S1, S2; Size : word) : Boolean;
  {-Compare S1 and S2 for Size, return true if equal}
begin
  asm
    mov     dx,ds                   {Save DS}
    mov     ax,1                    {AX holds temporary result (Equal)}
    mov     cx,Size                 {Size in CX}
    jcxz    @CSDone                 {Make sure size isn't zero}
    les     di,S1                   {ES:DI points to S2}
    lds     si,S2                   {DS:SI points to S1}
    cld                             {Go forward}
    repe    cmpsb                   {Compare until no match or CX = 0}
    je      @CSDone                 {Equal, result already set}
    dec     ax                      {Say not equal}
@CSDone:
    mov     ds,dx                   {Restore DS}
    mov     [bp-1],al
  end;
end;

procedure InitVideo;
  {-Force 80x25 text, note screen segment}
var
  VideoMode : Byte;
begin
  asm
    {Get current mode}
    mov      word ptr RealScreen+2,$B000
    mov      ax,$0F00
    int      $10
    mov      VideoMode, al
    cmp      al,2
    je       @SetMode
    cmp      al,7
    je       @SetMode
    mov      VideoMode,3
    mov      word ptr RealScreen+2,$B800
@SetMode:
    {Force 80x25 text mode}
    mov      al,VideoMode
    mov      ah,0
    int      $10
  end;
end;

procedure MoveScreen(var Source, Dest; Length : Word);
  {-Move Length words from Source to Dest, don't bother snow checking}
begin
  asm
    push    ds                      {Save DS}
    xor     ah,ah                   {AH = 0}
    les     di,Dest                 {ES:DI points to Dest}
    lds     si,Source               {DS:SI points to Source}
    mov     CX,Length               {CX = Length}
    jcxz    @MSExit                 {Exit if CX = 0}
    cld                             {Assume forward}
    mov     bx,ds                   {BX = DS}
    mov     dx,es                   {DX = ES}
    cmp     dx,bx                   {Same segment?}
    mov     bl,0                    {Clear same-segment flag}
    jne     @MSForward              {If not, go forward}
    inc     bl                      {Set same-segment flags}
    cmp     si,di                   {Check for potential overlap}
    jae     @MSForward              {Go forward if Source at higher offset}

    std                             {Go backwards}
    dec     cx                      {CX = Number of words to add to SI/DI}
    add     di,cx                   {Point DI to end of Dest area}
    add     di,cx
    add     si,cx                   {Point SI to end of Source area}
    add     si,cx
    inc     cx                      {Reset CX}
    inc     ah                      {Flag to indicate we're going backward}

@MSForward:
    rep     movsw                   {move it}
@MSExit:
    cld                             {Reset direction flag}
    pop     ds                      {Restore DS}
  end;
end;

procedure WhereXYdirect(var X, Y : Byte);
  {-Read the current position of the cursor directly from the CRT controller}
var
  CrtPort : Word;  {absolute $40:$63;}
  CrtWidth : Word; {absolute $40:$4A;}
  CrtLen   : Word; {absolute $40:$4C;}
  XP, XY : Word;
begin
  CrtPort := Word(Ptr(BiosDataSele, $63)^);
  CrtWidth := Word(Ptr(BiosDataSele, $4A)^);
  CrtLen := Word(Ptr(BiosDataSele, $4C)^);
  Port[CrtPort] := 14;
  XP := Port[CrtPort+1];
  Port[CrtPort] := 15;
  XY := ((XP shl 8)+Port[CrtPort+1]) mod (CrtLen shr 1);
  Y := Succ(XY div CrtWidth);
  X := Succ(XY mod CrtWidth);
end;

procedure ChainInt(var Regs : IntRegisters; JumpAddr : Pointer);
  {-Restores stack, registers from Regs and 'jumps' to JumpAddr}
  inline(
    $5B/                     {pop bx          ;BX = Ofs(JumpAddr^)}
    $58/                     {pop ax          ;AX = Seg(JumpAddr^)}
    $5E/                     {pop si          ;SI = Ofs(Regs)}
    $1F/                     {pop ds          ;DS:SI => Regs}
                             {;Change stack so RETF passes control to JumpAddr;
                              restore Flags}
    $87/$5C/$0E/             {xchg bx,[si+14] ;Switch old BX and Ofs(JumpAddr^)}
    $87/$44/$10/             {xchg ax,[si+16] ;Switch old AX and Seg(JumpAddr^)}
    $8B/$54/$16/             {mov  dx,[si+22] ;Old Flags into DX}
    $52/                     {push dx         ;Push altered flags}
    $9D/                     {popf            ;Pop them into place}
                             {;Switch stacks -- make SS:SP point to Regs.BP}
    $8C/$DA/                 {mov dx,ds       ;DX = Seg(Regs)}
    $FA/                     {cli             ;Interrupts off}
    $8E/$D2/                 {mov ss,dx       ;Restore SS from DX}
    $89/$F4/                 {mov sp,si       ;Restore SP from SI}
    $FB/                     {sti             ;Interrupts on}
    $5D/                     {pop bp          ;Restore BP}
    $07/                     {pop es          ;Restore ES}
    $1F/                     {pop ds          ;Restore DS}
    $5F/                     {pop di          ;Restore DI}
    $5E/                     {pop si          ;Restore SI}
    $5A/                     {pop dx          ;Restore DX}
    $59/                     {pop cx          ;Restore CX}
                             {;BX and AX restored earlier; their places on stack}
                             {;now have JumpAddr, which is where return will go}
    $CB);                    {retf            ;Chain to JumpAddr}

procedure SwapStackAndCall(Routine, SP : Pointer; var Regs : IntRegisters);
  {-Switches to stack designated by SP and calls Routine with Regs as a
    parameter. The Routine must be a FAR call from the current ISR.}
  inline(
    $9C/                     {pushf         ;Save flags}
    $59/                     {pop cx}
    $8C/$D0/                 {mov ax,ss     ;AX = SS}
    $8E/$C0/                 {mov es,ax     ;ES = SS}
    $58/                     {pop ax        ;AX = Ofs(Regs)}
    $5A/                     {pop dx        ;DX = Seg(Regs)}
    $5B/                     {pop bx        ;BX = new SP}
    $5F/                     {pop di        ;DI = new SS}
                             {              ;address of Routine now at SS:SP}
    $FA/                     {cli           ;Force interrupts off}
    $8E/$D7/                 {mov ss,di     ;Switch stack segments}
    $87/$E3/                 {xchg bx,sp    ;Get new SP and save old in BX}
                             {              ;ES:BX now points to Routine}
    $51/                     {push cx       ;Restore flags}
    $9D/                     {popf}
    $9C/                     {pushf         ;Save flags again}
    $06/                     {push es       ;Save old SS on stack}
    $53/                     {push bx       ;Save old SP}
    $52/                     {push dx       ;Push Seg(Regs)}
    $50/                     {push ax       ;Push Ofs(Regs)}
    $26/                     {es:}
    $FF/$1F/                 {call far [bx] ;Call Routine}
    $FA/                     {cli           ;Force interrupts off}
    $58/                     {pop ax        ;Get back old SP}
    $5A/                     {pop dx        ;Get back old SS}
    $59/                     {pop cx        ;Get back old flags}
    $8E/$D2/                 {mov ss,dx     ;Restore SS}
    $89/$C4/                 {mov sp,ax     ;Restore SP}
    $51/                     {push cx       ;Restore flags}
    $9D/                     {popf}
    $83/$C4/$04);            {add sp,4      ;Get Routine off the stack}

{$F+}
procedure RemoteExit;
  {-Restore interrupt vectors}
begin
  ExitProc := ExitSave;

  {Reset handlers}
  if OrigInt10 <> nil then
    SetIntVec($10, OrigInt10);
  if OrigInt08 <> nil then
    SetIntVec($08, OrigInt08);

  {$IFDEF Tracing}
  DumpTrace('RMTCTL.TRC');
  {$ENDIF}
end;
{$F-}

procedure WriteHelp;
  {-Write help and halt}
begin
  WriteLn('Usage: RMTCTL [options]');
  WriteLn('  /B BaudRate  Baudrate [no default]');
  WriteLn('  /C #         Comport number [1, 2, 3, 4]');
  WriteLn('  /T C         BIOS/BlockMode toggle key [default = ^U]');
  WriteLn('  /P PgmName   Program to EXEC [default = C:\COMMAND.COM]');
  WriteLn('  /L           Start in block mode [default = BIOS mode]');
  WriteLn('  /M           Monitor DCD, reboot if dropped [default = off]');
  Halt;
end;

procedure ParseCommandLine;
  {-Gets command line options and sets various parameters.}
var
  Code : Word;
  Param : String;
  Cnt : Word;
  ComNum : Word;
  C : Char;
begin
  {Scan command line}
  if ParamCount = 0 then
    WriteHelp;
  Param := ParamStr(1);
  Cnt := 2;

  while True do begin
    case Param[1] of
      '/', '-' :
        if Length(Param) <> 2 then
          Abort('Invalid parameter: '+Param)
        else
          case Upcase(Param[2]) of

            'B' : {Set baud rate}
              begin
                BaudSpecified := True;
                Param := ParamStr(Cnt);
                Inc(Cnt);
                Val(Param, Baud, Code);
                if Code <> 0 then
                  Abort('Invalid baud rate: '+Param);
              end;

            'C' : {Set Com port}
              begin
                Param := ParamStr(Cnt);
                Inc(Cnt);
                Val(Param, ComNum, Code);
                if Code <> 0 then
                  Abort('Invalid com port: '+Param);
                if (ComNum < 1) or (ComNum > 4) then
                  Abort('Com port number out of range: '+Param);
                ComX := ComNameType(ComNum-1);
              end;

            'T' : {Change toggle key}
              begin
                Param := ParamStr(Cnt);
                Inc(Cnt);
                C := Param[1];
                ModeToggleChar := Char(Byte(Upcase(C))-64);
              end;

            'P' : {Program to execute}
              begin
                PgmName := ParamStr(Cnt);
                Inc(Cnt);
              end;

            'L' : {Start in block mode}
              BlockMode := True;

            'M' : {Reboot if DCD dropped}
              MonitorDCD := True;

            '?' : {Request for help}
              WriteHelp;

          else
            Abort('Invalid parameter: '+Param);
          end;
    end;

    {Get next parameter}
    if Cnt > ParamCount then
      Exit;
    Param := ParamStr(Cnt);
    Inc(Cnt);
  end;
end;

function AnsiToRowCol(Row, Col : Byte) : String8;
  {-Return an ANSI command to move to Row, Col}
var
  S : String8;
begin
  S := AnsiPrefix + Long2Str(Row);
  S := S + ';';
  S := S + Long2Str(Col);
  S := S + 'H';
  AnsiToRowCol := S;
end;

function ScreenDiff(Row : Byte) : Boolean;
  {-Return True if current screen line is different from saved line}
var
  I : Word;
begin
  ScreenDiff := not CompStruct(Screen[Row], RealScreen^[Row], 160);
end;

function AnsiColor(A : Byte) : String14;
  {-Return an ANSI color command for attribute A}
const
  Foreground : array[0..7] of String[2] =
    ('30', '34', '32', '36', '31', '35', '33', '37');
  Background : array[0..7] of String[2] =
    ('40', '44', '42', '46', '41', '45', '43', '47');
var
  FS, BS : String14;
begin
  case A and $0F of
    $0..$7 : FS := '0;' + Foreground[A and $0F];
    $8..$F : FS := '1;' + Foreground[A and $07];
  end;
  BS := ';' + Background[(A shr 4) and $07];
  AnsiColor := AnsiPrefix + FS + BS + 'm';
end;

procedure CompressLine(var S : String);
  {-Replace trailing blanks with a ClearPart command}
var
  I : Word;
  Count : Word;
begin
  Count := 0;
  I := Length(S);
  while I > 1 do begin
    if S[I] = ' ' then
      Inc(Count)
    else begin
      {No more trailing blanks, enough to compress?}
      if Count > 4 then begin
        S[0] := Char(I);
        S := S + AnsiPrefix;
        S := S + '0K';
      end;
      Exit;
    end;
    Dec(I);
  end;
end;

procedure UpdateLine(Row : Byte);
  {-Format an ASCII sequence to update Row}
var
  S : String;
  I : Word;
  AttrChanged : Boolean;
  Collecting : Boolean;
  C : Char;
  A : Byte;
  TrailingChars : Boolean;
  BW : Word;

  {$IFDEF Debug}
  OldLine : String;
  NewLine : String;
  {$ENDIF}

  function CheckC(C : Char) : Char;
    {-Change control chars to '.'}
  begin
    case C of
      cSoh..cUS : CheckC := '.';
      else        CheckC := C;
    end;
  end;

begin
  {Inits}
  S := '';
  Collecting := False;
  AttrChanged := False;

  {Check entire line...}
  TrailingChars := False;
  for I := 1 to ScreenWidth do begin
    {Get simple copies of C and A (character and attribute}
    C := RealScreen^[Row, I].C;
    A := RealScreen^[Row, I].A;

    {Check attr first}
    if (A <> Screen[Row, I].A) then begin
      {Attr is different}
      if AttrChanged then begin
        {Same attr as last change?}
        if A <> CurrentAttr then begin
          {No, issue new color command}
          CurrentAttr := A;
          S := S + AnsiColor(A);
        end;
        S := S + CheckC(C);
      end else begin
        {First color change, issue color command}
        Collecting := True;
        AttrChanged := True;
        TrailingChars := False;
        CurrentAttr := A;
        S := S + AnsiToRowCol(Row, I);
        S := S + AnsiColor(A);
        S := S + CheckC(C);
      end;
    end else if (C <> Screen[Row, I].C) then begin
      {Character is different}
      if Collecting then begin
        {Already collecting characters, just add this one}
        if A <> CurrentAttr then begin
          {Attr is different too, issue new color command}
          CurrentAttr := A;
          S := S + AnsiColor(A);
        end;
        S := S + CheckC(C)
      end else begin
        {New change, issue goto command}
        Collecting := True;
        TrailingChars := False;
        S := S + AnsiToRowCol(Row, I);
        if CurrentAttr <> A then begin
          {Attr is different also}
          CurrentAttr := A;
          S := S + AnsiColor(A);
        end;
        S := S + CheckC(C);
      end;
    end else begin
      {Chars and attr equal, stop collecting}
      Collecting := False;
      AttrChanged := False;
      TrailingChars := True;
    end;

    {Send S if its nearing capacity}
    if Length(S) > 240 then begin
      PutString(ComPort, S);
      S := '';
    end;
  end;

  {Send the command line}
  if Length(S) <> 0 then begin
    if not TrailingChars then
      CompressLine(S);
    PutString(ComPort, S);
  end;

  {$IFDEF Debug}
  if DebugIndex <= 497 then begin
    for I := 1 to 80 do begin
      OldLine[I] := Screen[Row, I].C;
      NewLine[I] := RealScreen^[Row, I].C;
    end;
    OldLine[0] := #80;
    NewLine[0] := #80;
    DebugArray[DebugIndex+1] := 'Old '+Long2Str(Row)+' '+OldLine;
    DebugArray[DebugIndex+2] := 'New '+Long2Str(Row)+' '+NewLine;
    DebugArray[DebugIndex+3] := S;
    Inc(DebugIndex, 3);
  end;
  {$ENDIF}

  {Update our copy of this row}
  MoveScreen(RealScreen^[Row], Screen[Row], 80);
end;

function ValidXY(X, Y : Byte) : Boolean;
  {-Return True if X and Y are within the screen range}
begin
  ValidXY := (X <= ScreenWidth) and (Y <= ScreenHeight);
end;

{$F+}
procedure CheckScreen(var Regs : IntRegisters);
  {-Update remote if different from current}
var
  I : Word;
  Lines : Word;
  Diff : Boolean;
  X,Y : Byte;
  SwapSP : Word;
begin
  {Don't do anything unless at least 1K of buffer space is free}
  if OutBuffFree(ComPort) < 1024 then
    Exit;

  {Compare lines but don't send more than LinesPerTics lines each pass}
  Lines := 0;
  I := 1;
  while (I <= ScreenHeight) and (Lines < LinesPerTic) do begin
    if ScreenDiff(I) then begin
      UpdateLine(I);
      Inc(Lines);
    end;
    Inc(I);
  end;

  {Put the cursor back where it belongs}
  if Lines > 0 then begin
    WhereXYDirect(X, Y);
    if ValidXY(X, Y) then
      PutString(ComPort, AnsiToRowCol(Y, X));
  end;
end;
{$F-}

function CharToWord(C : Char) : Word;
  {-Return scan/key for C}
const
  ScanCodes : array[0..63] of Byte =
  (
    $03, {@} $1E, {A} $30, {B} $2E, {C} $20, {D} $12, {E} $21, {F} $22, {G}
    $23, {H} $17, {I} $24, {J} $25, {K} $26, {L} $32, {M} $31, {N} $18, {O}
    $19, {P} $10, {Q} $13, {R} $1f, {S} $14, {T} $16, {U} $2f, {V} $11, {W}
    $2d, {X} $15, {Y} $2c, {Z} $1a, {[} $2b, {\} $1b, {]} $07, {^} $0c, {_}
    $39, { } $02, {!} $28, {"} $04, {#} $5, { $} $06, {%} $08, {&} $28, {'}
    $0A, {(} $0b, {)} $09, {*} $0d, {+} $33, {,} $0c, {-} $34, {.} $35, {/}
    $0b, {0} $02, {1} $03, {2} $04, {3} $05, {4} $06, {5} $07, {6} $08, {7}
    $09, {8} $0A, {9} $27, {:} $27, {;} $33, {<} $0d, {=} $34, {>} $35 {?}
    );
var
  CharCode : Byte absolute C;
begin
  case C of
    ^M : CharToWord := $1C0D;
    ^[ : CharToWord := $011B;
    #0..'?' : CharToWord := (ScanCodes[CharCode] shl 8) or CharCode;
    '@'..'_' : CharToWord := (ScanCodes[CharCode-64] shl 8) or CharCode;
    '`', '~' : CharToWord := $2900 or CharCode;
    'a'..'}' : CharToWord := (ScanCodes[CharCode-96] shl 8) or CharCode;
    #127 : CharToWord := $0EFF;
  else CharToWord := CharCode;
  end;
end;

procedure StuffKey(W : Word);
  {-Stuff one key into the keyboard buffer}
const
  KbdStart = $1E;
  KbdEnd = $3C;
var
  KbdHead : ^Word;
  KbdTail : ^Word;
  SaveKbdTail : Word;
begin
  KbdHead := Ptr(BiosDataSele, $1A);
  KbdTail := Ptr(BiosDataSele, $1C);
  SaveKbdTail := KbdTail^;
  if KbdTail^ = KbdEnd then
    KbdTail^ := KbdStart
  else
    Inc(KbdTail^, 2);
  if KbdTail^ = KbdHead^ then
    KbdTail^ := SaveKbdTail
  else
    Word(Ptr(BiosDataSele, SaveKbdTail)^) := W;
end;

{$F+}
procedure UpdateCursor(var Regs : IntRegisters);
begin
  IntOff;
  with Regs do
    PutString(ComPort, AnsiToRowCol(Hi(DX)+1, Lo(DX)+1));
  IntOn;
end;
{$F-}

{$F+}
function PortOK : Boolean;
  {-Return True if we still own vector}
var
  MC  : Byte;
  PIC : Byte;
  Reset : Boolean;
begin
  PortOK := OurVector = CurVector^;

  if OurVector = CurVector^ then begin
    {Check OUT2 and PIC}
    MC := Port[$3FC];
    PIC := Port[$21];
    Reset := ((MC and $08) <> $08) or ((PIC and $10) = $10);

    if Reset then begin
      MC := MC or $0F;
      Port[$3FC] := MC;
      PIC := PIC and $EF;
      Port[$21] := PIC;

      while Port[$3FA] <> $01 do begin
        MC := Port[$3F8];
        MC := Port[$3FA];
        MC := Port[$3FD];
        MC := Port[$3FE];
      end;
      Port[$3F9] := $0D;
      ComPort^.TxReady := True;
    end;
  end;
end;
{$F-}

procedure Int10(BP : Word); interrupt;
  {-When in BIOS mode, echo what we do here to the remote}
var
  Regs : IntRegisters absolute BP;
begin
  with Regs do begin
    if not BlockMode then
      case AH of
        $09,
        $0A,
        $0E :  {Display a character}
          if PortOk then
            PutChar(ComPort, Char(AL));

        $02 : {Moving cursor}
          if PortOk then
            SwapStackAndCall(@UpdateCursor, @Int10Stack[Int10StackSize], Regs);
      end;

    {Let BIOS see it as well}
    ChainInt(Regs, OrigInt10);
  end;
end;

procedure Int08(BP : Word); interrupt;
  {-Get input data from remote. Handle screen updates when in block mode}
const
  CharPending : Boolean = False;
  Busy : Boolean = False;
var
  Regs : IntRegisters absolute BP;
  C : Char;
  W : Word;

  procedure GetExtendedChar;
    {-Get the second part of an extended char}
  begin
    CharPending := False;
    GetChar(ComPort, C);
    W := Ord(C) shl 8;
    StuffKey(W);
  end;

begin
  {Reboot if DCD drops}
  if MonitorDCD and not CheckDCD(ComPort) then
    Reboot;

  if not Busy and PortOk then begin
    {Prevent re-entering on slow machines}
    Busy := True;

    {Let previous ISR handle and clear interrupt}
    EmulateInt(Regs, OrigInt08);

    {Turn interrupts back on so we don't miss any incoming data}
    asm
      sti
    end;

    with Regs do begin
      {Get input data from remote}
      while CharReady(ComPort) do begin
        if CharPending then
          GetExtendedChar
        else begin
          GetChar(ComPort, C);
          if C = #0 then
            {Loop around for next byte of extended char}
            CharPending := True
          else if C = ModeToggleChar then begin
            {Requesting a mode switch}
            BlockMode := not BlockMode;
            FillChar(Screen, SizeOf(Screen), 0);
          end else
            {Normal char, just stuff it}
            StuffKey(CharToWord(C));
        end;
      end;

      {If in block mode, see if remote's screen needs to be updated}
      if BlockMode then
        SwapStackAndCall(@CheckScreen, @Int08Stack[Int08StackSize], Regs);
    end;

    {Say we're not busy anymore}
    Busy := False;
  end else
    {Last Int08 work still in progress, just pass this tick to old ISR}
    ChainInt(Regs, OrigInt08);
end;

{$IFDEF Debug}
procedure DumpDebugReport;
  {-Create report of old/new lines and data sent to remote}
var
  Debug : Text;
  I : Word;
begin
  Assign(Debug, 'DEBUG.TRC');
  Rewrite(Debug);
  for I := 1 to DebugIndex do begin
    WriteLn(Debug, DebugArray[I]);
    if I mod 3 = 0 then
      WriteLn(Debug);
  end;
  Close(Debug);
end;
{$ENDIF}

begin
  {Get arguments}
  ParseCommandLine;

  {Default program to COMMAND.COM}
  if PgmName = '' then
    PgmName := GetEnv('COMSPEC');

  {Set video mode}
  InitVideo;

  {Say no initial screen}
  FillChar(Screen, SizeOf(Screen), 0);

  {Install exit procedure}
  ExitSave := ExitProc;
  ExitProc := @RemoteExit;

  {Open a port}
  if BaudSpecified then
    InitPort(ComPort, ComX, Baud, NoParity, 8, 1, 16, 4096, DefPortOptions)
  else begin
    InitPortKeep(ComPort, ComX, 16, 4096);
    ptOptionsOff(ComPort, ptRestoreOnClose or ptDropModemOnClose);
  end;
  if AsyncStatus <> ecOk then
    Abort('Failed to open com port, error was '+Long2Str(AsyncStatus));

  {Note our vector and base address for fast compares later}
  GetIntVec(DefComVector[ComX], OurVector);
  BaseAddr := GetBaseAddr(ComPort);

  {Get a pointer to the replaced vector}
  CurVector := Ptr($0, DefComVector[ComX]*4);

  {Install int 10 handler}
  GetIntVec($10, OrigInt10);
  SetIntVec($10, @Int10);

  {Install int 08 handler}
  GetIntVec($08, OrigInt08);
  SetIntVec($08, @Int08);

  {Use hardware flow control for output only}
  HWFlowEnable(ComPort, 14, 12, hfRequireCTS);

  {$IFDEF Tracing}
  {Start tracing}
  InitTracing(5000);
  {$ENDIF}

  {Clear remote screen}
  PutString(ComPort, AnsiPrefix+'2J');

  {Shell to program}
  SwapVectors;
  Exec(PgmName, '');
  SwapVectors;
  if DosError <> 0 then
    Abort('Failed to EXEC program, error was '+Long2Str(DosError));

  {$IFDEF Debug}
  DumpDebugReport;
  {$ENDIF}

  {Exit procedure will restore vectors and dump trace}
end.
