Program edit_lng;

uses crt,dos,strings;

Type
  index = record
			 lib   : string;
			 max   : shortInt;
			 trail : shortint;
			 end;

  screen = array[1..2000] of record
				 characters : char;
				 attr       : byte;
				 end;

  Pscreen = ^screen;

Var
  chem,
  directory,
  trailing,
  future,
  present   : string;
  DirInfo   : SearchRec;
  modified,
  one_file  : boolean;
  f,h       : text;
  g         : file of index;
  ind       : index;
  nb_file,
  line,
  lineon,
  lineoff,
  column    : shortint;
  filelist  : array[1..80] of string;
  i,
  code      : integer;
  Mono      : screen ABSOLUTE $B000:0000;         {mono  display}
  Color     : screen ABSOLUTE $B800:0000;         {color display}


Function ColorDisplay : boolean;
var regs : registers;
begin
Intr($11,Regs);                      {Software-INTERRUPT}
if Regs.ax and $30=$30
	then ColorDisplay:=false
	else ColorDisplay:=true;
end;

Procedure SaveScreen(Var name: Pscreen);
begin
if ColorDisplay then name^:= Color
					 else name^:= Mono;
end;

Procedure RestoreScreen(name : Pscreen);
begin
if ColorDisplay then Color:=name^
					 else Mono:=name^;
end;

Procedure header;
begin
TextColor(White);
TextBackGround(LightCyan);
gotoXY(9,1);
writeln('ͻ');
gotoXY(9,2);
writeln('                   Edit-Lng for RBBS-PC v1.01                     ');
gotoXY(9,3);
writeln('                (c) Eric Van Hyfte 1995 - Freeware                ');
gotoXY(9,4);
writeln('ͼ');
TextColor(LightGray);
TextBackGround(Black);
end;



Procedure usage;
begin
clrscr;
writeln('Edit_lng v1.01 - (c) Eric Van Hyfte 1995 - Freeware');
writeln;
writeln('usage: edit_lng [[[path][lng_file][.lng]]|[/?]]');
writeln;
writeln('if launching without any parameter, the program try to find');
writeln('all .lng files in the current directory and display them, if');
writeln('any found, in a selection box. Then you can select one.');
writeln;
writeln('You can also specified a path without file name, so the search');
writeln('of .lng files is made in this directory.');
writeln;
writeln('You can specified too a specific file name with or without any');
writeln('path and/or extension (default is .lng) which is, in this case,');
writeln('open directly for editing. If extension is empty _ADD_ the final');
writeln('point in the file name.');
writeln;
writeln('You can also used /? which display this help');
halt(1);
end;


Procedure list_of_files;
begin
FindFirst(chem, AnyFile, DirInfo);
if DosError<>0 then
  begin
  clrscr;
  writeln('unable to find file(s) in ',chem,'... program halted !');
  halt(2);
  end;
nb_file:=0;
while DosError = 0 do
  begin
  inc(nb_file);
  filelist[nb_file]:=DirInfo.Name;
  FindNext(DirInfo);
  end;
end;

Procedure display_list;
begin
header;
writeln;
writeln('                         Choose .lng file to edit (and compil)              ');
writeln('        Ŀ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('                                                                          ');
writeln('        ');
line:=8;
column:=11;
for i:=1 to nb_file do
  begin
  if i=1 then TextColor(Yellow) else TextColor(LightGray);
  gotoXY(column,line);
  inc(column,13);
  if column=76 then
	 begin
	 inc(line);
	 column:=11;
	 end;
  write(filelist[i]);
  end;
end;


Procedure select_file;
var active : shortInt;
	 c      : char;
begin
active:=1;
line:=8;
column:=11;
gotoXY(column,line);
repeat
  c:=readkey;
  if c=#0 then
	 begin
	 c:=readkey;
	 TextColor(LightGray);
	 write(filelist[active]);
	 case c of
		#75: begin
			  dec(active);
			  if active=0 then active:=nb_file;
			  end;
		#77: begin
			  inc(active);
			  if active>nb_file then active:=1;
			  end;
		#80: begin
			  inc(active,5);
			  if active>nb_file then
				 begin
				 active:=active mod 5;
				 if active=0 then active:=5;
				 end;
			  end;
		#72: begin
			  dec(active,5);
			  if active<1 then
				 begin
				 inc(active,5);
				 active:=(((nb_file DIV 5)-1)*5)+active;
				 if active+5 <= nb_file then inc(active,5);
				 end;
			  end;
		#71: begin
			  active:=1;
			  end;
		#79: begin
			  active:=nb_file;
			  end;
		end;
	 line:=(active DIV 5)+8;
	 if (active mod 5) = 0 then dec(line);
	 column:=11+((active mod 5)-1)*13;
	 if column=-2 then column:=63;
	 TextColor(yellow);
	 gotoXY(column,line);
	 write(filelist[active]);
	 gotoXY(column,line);
	 end;
until (c=#13) or (c=#27);
TextColor(lightgray);
if c=#27 then
  begin
  clrscr;
  halt(0);
  end;
chem:=directory+filelist[active];
end;



Procedure parse_cmd_line;
begin
if (paramstr(1)='/?') or (paramcount>1) then usage;
chem:=paramstr(1);
if chem='' then chem:='*.lng';
if chem[length(chem)]='\' then
  begin
  directory:=chem;
  chem:=chem+'*.lng';
  one_file:=false;
  end
  else
  begin
  if pos('*',chem)<>0 then
	 begin
	 one_file:=false;
	 directory:=chem;
	 while (directory[length(directory)]<>'\') and (directory<>'') do delete(directory,length(directory),1);
	 end
	 else
	 begin
	 if (pos('.',chem)=length(chem)) and (chem<>'') then
		begin
		one_file:=true;
		end
		else
		begin
		if pos('.',chem)<>0 then
		  begin
		  one_file:=true;
		  end
		  else
		  begin
		  assign(f,chem);
		  {$I-}
		  reset(f);
		  {$I+}
		  if IOResult<>0 then
			 begin
			 one_file:=false;
			 if chem<>'' then
				begin
				directory:=chem+'\';
				chem:=chem+'\*.lng';
				end
				else
				begin
				directory:='';
				chem:=chem+'*.lng';
				end;
			 end
			 else
			 begin
			 close(f);
			 one_file:=true;
			 end;
		  end;
		end;
	 end;
  end;
if not one_file then
  begin
  list_of_files;
  clrscr;
  display_list;
  select_file;
  end;
end;


Function revert(s : string): string;
var i,j : shortInt;
	 c   : char;
begin
i:=1;
j:=length(s);
repeat
  c:=s[i];
  s[i]:=s[j];
  s[j]:=c;
  inc(i);
  dec(j);
until (i=j) or (i>j);
revert:=s;
end;

Procedure quit;
Const
  anim : string = '**/**\';
Type
  indexs = record
			  offset : longint;
			  long   : integer;
			  end;
var
  temp,
  ligne,
  expr  : string;
  c     : char;
  a     : byte;
  z     : file;
  y     : file of indexs;
  indx  : indexs;
begin
header;
if modified then
  begin
  TextColor(White);
  TextBackground(LightBlue);
  gotoXY(26,15);
  write('Save modifications ? (Y/n) ');
  TextColor(LightGray);
  TextBackground(Black);
  repeat
	c:=readkey;
  until (upcase(c)='Y') or (upcase(c)='N') or (c=#13);
  if upcase(c)<>'N' then
	 begin
	 seek(g,0);
	 assign(h,'new.lng');
	 rewrite(h);
	 reset(f);
	 TextColor(LightRed+128);
	 gotoXY(36,11);
	 write('Working...');
	 TextColor(LightGreen);
	 a:=0;
	 while not eof(g) do
		begin
		repeat
		  readln(f,ligne);
		  if ligne[1]=';' then writeln(h,ligne);
		until (ligne[1]<>';') or (eof(f));
		read(g,ind);
		str(filepos(g),temp);
		while length(temp)<4 do temp:=temp+'-';
		temp:=temp+': "';
		str(ind.max,expr);
		expr:='",'+expr;
		inc(a);
		if a=9 then a:=1;
		gotoXY(40,12);
		write(anim[a]);
		while ind.lib[length(ind.lib)]=' ' do delete(ind.lib,length(ind.lib),1);
		trailing:='';
		while length(trailing)<ind.trail do trailing:=trailing+' ';
		writeln(h,temp+ind.lib+trailing+expr);
		end;
	 if not eof(f) then
		repeat
		  readln(f,ligne);
		  if ligne[1]=';' then writeln(h,ligne);
		until (ligne[1]<>';') or (eof(f));
	 close(f);
	 close(h);
	 erase(f);
	 rename(h,chem);
	 end;
  end;
TextColor(LightGray);
gotoXY(1,11);
clreol;
gotoXY(1,12);
clreol;
gotoXY(1,15);
clreol;
TextColor(White);
TextBackground(LightBlue);
gotoXY(28,15);
write('Compil language ? (Y/n) ');
TextColor(LightGray);
TextBackground(Black);
repeat
  c:=readkey;
until (upcase(c)='Y') or (upcase(c)='N') or (c=#13);
if upcase(c)<>'N' then
  begin
  delete(chem,pos('.',chem),4);
  chem:=chem+'.cpl';
  assign(z,chem);
  rewrite(z,1);
  delete(chem,pos('.',chem),4);
  chem:=chem+'.idx';
  assign(y,chem);
  rewrite(y);
  seek(g,0);
  indx.offset:=0;
  indx.long:=0;
  TextColor(LightRed+128);
  gotoXY(36,11);
  write('Working...');
  TextColor(LightGreen);
  a:=0;
  while not eof(g) do
	 begin
	 read(g,ind);
	 while ind.lib[length(ind.lib)]=' ' do delete(ind.lib,length(ind.lib),1);
	 indx.long:=length(ind.lib);
	 write(y,indx);
	 indx.offset:=indx.offset+indx.long+1;
	 blockwrite(z,ind.lib,length(ind.lib)+1);
	 inc(a);
	 if a=9 then a:=1;
	 gotoXY(40,12);
	 write(anim[a]);
	 end;
  close(y);
  close(z);
  end;
close(g);
erase(g);
TextColor(LightGray);
TextBackground(Black);
end;


Procedure edit_line;
const
 long   : byte = 74;
 first  : byte = 7;
 nbline : byte = 13;
var
 lines,
 current,
 currentline,
 currentindex,
 this,
 max,
 p         : shortInt;
 code      : integer;
 s         : string;
 space     : string[80];
 c         : char;
 modif,
 insertion : boolean;
 table     : array[1..13] of index;

 procedure end_active_color;
 begin
 TextBackGround(Cyan);
 TextColor(White);
 end;

 procedure active_color;
 begin
 TextBackground(LightGreen);
 TextColor(White);
 end;

 procedure inactive_color;
 begin
 TextBackground(White);
 TextColor(LightGreen);
 end;

 procedure standard_color;
 begin
 TextBackground(Black);
 TextColor(LightGray);
 end;

 procedure memo_color;
 begin
 TextColor(White);
 TextBackground(LightRed);
 end;

 procedure footer_color;
 begin
 TextColor(White);
 TextBackground(LightBlue);
 end;

 procedure l_color;
 begin
 TextColor(LightBlue);
 TextBackground(Black);
 end;

 procedure num_color;
 begin
 TextColor(White);
 TextBackground(Black);
 end;

 procedure help_color;
 begin
 TextColor(White);
 TextBackGround(Blue);
 end;

 procedure help_item_color;
 begin
 TextColor(Yellow);
 TextBackGround(Blue);
 end;

 procedure not_enough_trailing;
 var
  save : Pscreen;
  ch   : char;
 begin
 new(save);
 SaveScreen(save);
 help_color;
 gotoXY(9,9);
 write('Ŀ');
 gotoXY(9,10);
 write(' Hey men !                                                  ');
 gotoXY(9,11);
 write(' You need, at least, leave x trailing spaces in this line ! ');
 gotoXY(9,12);
 write(' See the status line and try again please...                ');
 gotoXY(9,13);
 write('');
 repeat until keypressed;
 ch:=readkey;
 RestoreScreen(save);
 dispose(save);
 active_color;
 end;

 procedure help;
 var
  save : Pscreen;
  i    : byte;
  ch   : char;
 begin
 new(save);
 SaveScreen(save);
 standard_color;
 clrscr;
 header;
 help_color;
 for i:=5 to 24 do
	begin
	gotoXY(1,i);
	clreol;
	end;
 gotoXY(34,5);
 TextColor(LightGreen);
 write('Help Screen');
 gotoXY(2,6);
 TextColor(LightRed);
 write('Keys usage:');
 gotoXY(2,8);
 help_item_color;
 write('Esc:');
 help_color;
 write(' quit editing');
 gotoXY(2,9);
 help_item_color;
 write('Enter:');
 help_color;
 write(' save modifications of currently editing line and go next line');
 gotoXY(2,10);
 help_item_color;
 write('Cursor left:');
 help_color;
 write(' move cursor one char left on currently editing line');
 gotoXY(2,11);
 help_item_color;
 write('Cursor right:');
 help_color;
 write(' move cursor one char right on currently editing line');
 gotoXY(2,12);
 help_item_color;
 write('End:');
 help_color;
 write(' move cursor to last char on currently editing line');
 gotoXY(2,13);
 help_item_color;
 write('Home:');
 help_color;
 write(' move cursor to first char on currently editing line');
 gotoXY(2,14);
 help_item_color;
 write('Ctrl-Cursor left:');
 help_color;
 write(' move cursor to next word on currently editing line');
 gotoXY(2,15);
 help_item_color;
 write('Ctrl-Cursor right:');
 help_color;
 write(' move cursor to previous word on currently editing line');
 gotoXY(2,16);
 help_item_color;
 write('Cursor Dn:');
 help_color;
 write(' go to next line (don''t save modifications)');
 gotoXY(2,17);
 help_item_color;
 write('Cursor Up:');
 help_color;
 write(' go to previous line (don''t save modifications)');
 gotoXY(2,18);
 help_item_color;
 write('Pg Dn:');
 help_color;
 write(' go one screen down and go on the first line (don''t save modifications)');
 gotoXY(2,19);
 help_item_color;
 write('Pg Up:');
 help_color;
 write(' go one screen up and go on the first line (don''t save modifications)');
 gotoXY(2,20);
 help_item_color;
 write('Ctrl-Home:');
 help_color;
 write(' go to first line of .LNG file (don''t save modifications)');
 gotoXY(2,21);
 help_item_color;
 write('Ctrl-End:');
 help_color;
 write(' go to last line of .LNG file (don''t save modifications)');
 gotoXY(2,22);
 help_item_color;
 write('Insert:');
 help_color;
 write(' toggle between overwrite and insert mode on editing');
 gotoXY(2,23);
 help_item_color;
 write('Del:');
 help_color;
 write(' delete char under cursor');
 gotoXY(2,24);
 help_item_color;
 write('BackSpace:');
 help_color;
 write(' delete char on the left of the cursor');
 repeat
	ch:=readkey;
 until ch=#27;
 RestoreScreen(save);
 dispose(save);
 end;

 procedure update_line;
 begin
 gotoXY(first,currentline);
 s:=table[currentindex].lib;
 max:=table[currentindex].max;
 lineon:=1;
 if max>long then lineoff:=long
				 else lineoff:=length(s);
 gotoXY(1,23);
 standard_color;
 clreol;
 memo_color;
 gotoXY(7,23);
 write(copy(s,1,long));
 footer_color;
 gotoXY(41,24);
 write('    ');
 gotoXY(41,24);
 write(table[currentindex].trail);
 gotoXY(first,currentline);
 end_active_color;
 write(space);
 active_color;
 gotoXY(first,currentline);
 write(copy(s,lineon,lineoff-lineon+1));
 gotoXY(first,currentline);
 current:=1;
 end;

 procedure write_file;
 begin
 seek(g,filepos(g)-lines);
 for i:=1 to lines do write(g,table[i]);
 end;

 procedure read_file;
 begin
 currentline:=6;
 if filepos(g)<>0 then seek(g,filepos(g)-nbline);
 i:=0;
 repeat
	inc(i);
	read(g,table[i]);
	while length(table[i].lib)<table[i].max do table[i].lib:=table[i].lib+' ';
	gotoXY(1,currentline);
	standard_color;
	write('      ');
	l_color;
	gotoXY(1,currentline);
	write('L');
	num_color;
	write(filepos(g));
	inactive_color;
	gotoXY(first,currentline);
	write(space);
	gotoXY(first,currentline);
	if length(table[i].lib)<long then write(table[i].lib)
										  else write(copy(table[i].lib,1,long));
	inc(currentline);
 until (i=nbline) or (eof(g));
 lines:=i;
 end;

begin
insertion:=false;
modified:=false;
modif:=false;
space:='';
while length(space)<long do space:=space+' ';
standard_color;
for i:=21 to 23 do
  begin
  gotoXY(1,i);
  write(space);
  end;
TextColor(Yellow);
gotoXY(6,21);
write('          1         2         3         4         5         6         7');
gotoXY(6,22);
write('0....5....0....5....0....5....0....5....0....5....0....5....0....5....0');
gotoXY(1,24);
footer_color;
write(space);
gotoXY(1,24);
write('Insert: Off  Modified: False  Trailing:           <ESC>: end  <F1>: Help Screen ');
if filesize(g)<nbline then nbline:=filesize(g);
read_file;
currentindex:=1;
currentline:=6;
update_line;
repeat
  c:=readkey;
  if c=#0 then
	 begin
	 c:=readkey;
	 case ord(c) of
		75 : begin {flche gauche}
			  if current>1 then
				 begin
				 if current=lineon then
					begin
					dec(lineon);
					dec(lineoff);
					gotoXY(first,currentline);
					write(copy(s,lineon,lineoff-lineon+1));
					end;
				 gotoXY(current-lineon+(first-1),currentline);
				 dec(current);
				 end;
			  end;
		77 : begin {flche droite}
			  if current<max then
				 begin
				 if current=lineoff then
					begin
					inc(lineon);
					inc(lineoff);
					gotoXY(first,currentline);
					write(copy(s,lineon,lineoff-lineon+1));
					end;
				 inc(current);
				 gotoXY(current-lineon+first,currentline);
				 end;
			  end;
		83 : begin {suppression}
			  modif:=true;
			  gotoXY(14,24);
			  footer_color;
			  write('Modified: True ');
			  active_color;
			  delete(s,current,1);
			  s:=s+' ';
			  gotoXY(first,currentline);
			  write(copy(s,lineon,lineoff-lineon+1));
			  gotoXY(current-lineon+first,currentline);
			  end;
		82 : begin {Insert}
			  insertion:=not(insertion);
			  gotoXY(1,24);
			  footer_color;
			  if insertion then write('Insert: On ')
								else write('Insert: Off');
			  active_color;
			  gotoXY(current-lineon+first,currentline);
			  end;
		116: begin {Ctrl-flche droite}
			  p:=pos(' ',copy(s,current+1,length(s)));
			  if p<>0 then
				 begin
				 while (s[current+p]=' ') and ((current+p)<max) do inc(p);
				 if (current+p=max) and (s[current+p]=' ') then p:=0;
				 current:=current+p;
				 if current>lineoff then
					begin
					lineoff:=current;
					lineon:=lineoff-long+1;
					gotoXY(first,currentline);
					write(copy(s,lineon,lineoff-lineon+1));
					end;
				 end;
			  gotoXY(current-lineon+first,currentline);
			  end;
		115: begin {Ctrl-flche gauche}
			  if current<>1 then
				 begin
				 this:=1+(max-current);
				 s:=revert(s);
				 p:=pos(' ',copy(s,this+1,length(s)));
				 if p<>0 then
					begin
					while (s[this+p]=' ') and ((this+p)<max) do inc(p);
					if (this+p=max) and (s[this+p]=' ') then p:=0;
					s:=revert(s);
					current:=current-p; {dernire lettre du mot prcdant}
					this:=current;
					repeat              {revenir au mot actuel si on tait}
					  inc(this);        {pas sur sa 1re lettre}
					until (s[this]<>' ') or (this>=current+p);
					if not (this>=current+p) then current:=this
					  else
					  begin             {sinon trouver la 1re lettre du mot prcdant}
					  repeat
						 dec(current);
					  until (current=0) or (s[current]=' ');
					  inc(current);
					  end;
					end
					else
					begin
					s:=revert(s);
					current:=1;
					end;
				 if current<lineon then
					begin
					lineon:=current;
					lineoff:=lineon+long-1;
					gotoXY(first,currentline);
					write(copy(s,lineon,lineoff-lineon+1));
					end;
				 gotoXY(current-lineon+first,currentline);
				 end;
			  end;
		71 : begin {home}
			  current:=1;
			  lineon:=1;
			  lineoff:=length(s);
			  if lineoff>long then lineoff:=long;
			  gotoXY(first,currentline);
			  write(copy(s,lineon,lineoff-lineon+1));
			  gotoXY(first,currentline);
			  end;
		79 : begin {end}
			  current:=max;
			  if max>long then lineon:=max-long+1;
			  if lineoff<>max then
				 begin
				 lineoff:=max;
				 gotoXY(first,currentline);
				 write(copy(s,lineon,lineoff-lineon+1));
				 end;
			  gotoXY(current-lineon+first,currentline);
			  end;
		80 : begin {flche bas}
			  if modif and not modified then
				 begin
				 modif:=false;
				 gotoXY(14,24);
				 footer_color;
				 write('Modified: False');
				 end;
			  if currentindex<nbline then
				 begin
				 gotoXY(first,currentline);
				 inactive_color;
				 write(space);
				 gotoXY(first,currentline);
				 write(copy(table[currentindex].lib,lineon,lineoff-lineon+1));
				 inc(currentline);
				 inc(currentindex);
				 update_line;
				 end
				 else
				 begin
				 write_file;
				 if not eof(g) then
					begin
					seek(g,filepos(g)+1);
					read_file;
					end;
				 currentindex:=lines;
				 currentline:=6+lines-1;
				 update_line;
				 end;
			  end;
		72 : begin {flche haut}
			  if modif and not modified then
				 begin
				 modif:=false;
				 gotoXY(14,24);
				 footer_color;
				 write('Modified: False');
				 end;
			  if currentline>6 then
				 begin
				 gotoXY(first,currentline);
				 inactive_color;
				 write(space);
				 gotoXY(first,currentline);
				 write(copy(table[currentindex].lib,lineon,lineoff-lineon+1));
				 dec(currentline);
				 dec(currentindex);
				 update_line;
				 end
				 else
				 begin
				 write_file;
				 if filepos(g)>nbline then
					begin
					seek(g,filepos(g)-1);
					read_file;
					end;
				 currentindex:=1;
				 currentline:=6;
				 update_line;
				 end;
			  end;
		119 : begin {Ctrl-Home}
				if modif and not modified then
				  begin
				  modif:=false;
				  gotoXY(14,24);
				  footer_color;
				  write('Modified: False');
				  end;
				write_file;
				seek(g,nbline);
				read_file;
				current:=1;
				currentindex:=1;
				currentline:=6;
				update_line;
				end;
		117 : begin {Ctrl-End}
				if modif and not modified then
				  begin
				  modif:=false;
				  gotoXY(14,24);
				  footer_color;
				  write('Modified: False');
				  end;
				write_file;
				seek(g,filesize(g));
				read_file;
				current:=1;
				currentindex:=nbline;
				currentline:=6+lines-1;
				update_line;
				end;
		81 : begin {Page down}
			  if filepos(g)<>filesize(g) then
				 begin
				 if modif and not modified then
					begin
					modif:=false;
					gotoXY(14,24);
					footer_color;
					write('Modified: False');
					end;
				 write_file;
				 if filepos(g)+nbline<=filesize(g)
					then seek(g,filepos(g)+nbline)
					else seek(g,filesize(g));
				 read_file;
				 current:=1;
				 currentindex:=1;
				 currentline:=6;
				 update_line;
				 end;
			  end;
		73 : begin {Page up}
			  if filepos(g)<>nbline then
				 begin
				 if modif and not modified then
					begin
					modif:=false;
					gotoXY(14,24);
					footer_color;
					write('Modified: False');
					end;
				 write_file;
				 if filepos(g)<30
					then seek(g,nbline)
					else seek(g,filepos(g)-nbline);
				 read_file;
				 current:=1;
				 currentindex:=1;
				 currentline:=6;
				 update_line;
				 end;
			  end;
		59 : begin {F1}
			  help;
			  gotoXY(current-lineon+first,currentline);
			  end;
		end;
	 end
	 else
	 begin
	 case c of
		#1..#7 : ; {code contrle}
		#8 : begin {backspace}
			  if current<>1 then
				 begin
				 modif:=true;
				 gotoXY(14,24);
				 footer_color;
				 write('Modified: True ');
				 active_color;
				 delete(s,current-1,1);
				 s:=s+' ';
				 dec(current);
				 if current<lineon then
					begin
					dec(lineon);
					dec(lineoff);
					end;
				 gotoXY(first,currentline);
				 write(copy(s,lineon,lineoff-lineon+1));
				 gotoXY(current-lineon+first,currentline);
				 end;
			  end;
		#9..#12 : ; {code contrle}
		#13: begin {enter}
			  trailing:='';
			  if table[currentindex].trail<>0 then
				 begin
				 while length(trailing)<table[currentindex].trail do trailing:=trailing+' ';
				 if copy(s,length(s)-length(trailing)+1,length(trailing))<>trailing then
					begin
					not_enough_trailing;
					gotoXY(current-lineon+first,currentline);
					end
					else
					begin
					trailing:='';
					end;
				 end;
			  if trailing='' then
				 begin
				 table[currentindex].lib:=s;
				 if modif then modified:=true;
				 if currentindex<nbline then
					begin
					gotoXY(first,currentline);
					inactive_color;
					write(space);
					gotoXY(first,currentline);
					write(copy(s,lineon,lineoff-lineon+1));
					inc(currentline);
					inc(currentindex);
					update_line;
					end
					else
					begin
					write_file;
					if not eof(g) then
					  begin
					  seek(g,filepos(g)+1);
					  read_file;
					  end;
					currentindex:=lines;
					currentline:=6+lines-1;
					update_line;
					end;
				 end;
			  end;
		#14..#26 : ; {code contrle}
		#27 : write_file; {escape}
		#28..#31 : ; {code contrle}
		else
		  begin     {caractres imprimable}
		  if insertion then
			 begin
			 insert(c,s,current);
			 delete(s,max+1,1);
			 gotoXY(first,currentline);
			 if current<max then inc(current);
			 if current>lineoff then
				begin
				inc(lineoff);
				inc(lineon);
				end;
			 write(copy(s,lineon,lineoff-lineon+1));
			 gotoXY(current-lineon+first,currentline);
			 end
			 else
			 begin
			 write(c);
			 s[current]:=c;
			 if current<max then inc(current);
			 end;
		  modif:=true;
		  gotoXY(14,24);
		  footer_color;
		  write('Modified: True ');
		  active_color;
		  gotoXY(current-lineon+first,currentline);
		  end;
		end;
	 end;
until c=#27;
table[currentindex].lib:=s;
write_file;
standard_color;
clrscr;
quit;
end;

procedure woops_now(l : word);
var
 ch   : Char;
begin
close(f);
close(g);
erase(g);
clrscr;
header;
TextColor(White);
TextBackGround(LightRed);
GotoXY(21,9);
write('                Error !!!                ');
TextBackGround(Blue);
for i:=10 to 16 do
  begin
  GotoXY(21,i);
  write('                                         ');
  end;
GotoXY(22,11);
write('Problem with text in line #',l,'...');
GotoXY(22,13);
write('His size is longer than authorized one.');
GotoXY(22,15);
write('Correct this before running EDIT_LNG!');
TextBackGround(Green);
GotoXY(21,17);
write('                          <Enter> to end ');
repeat
 GotoXY(61,17);
 write(' ');
 GotoXY(61,17);
 ch:=readkey;
until ch=#13;
TextColor(LightGray);
TextBackground(Black);
halt(255);
end;


var c: char;
	 l: word;

BEGIN
clrscr;
{
repeat
  c:=readkey;
  if c=#0 then
	 begin
	 c:=readkey;
	 write(c,' ',ord(c),' ');
	 end;
until c=#27;
end.
}
repeat
  c:=#0;
  parse_cmd_line;
  if c<>#27 then
	 begin
	 clrscr;
	 header;
	 assign(f,chem);
	 {$I-}
	 reset(f);
	 {$I+}
	 if IOResult<>0 then
		begin
		writeln('Unable to open file "',chem,'"... program halted !');
		halt(2);
		end;
	 assign(g,'lng.ind');
	 rewrite(g);
	 l:=0;
	 while not eof(f) do
		begin
		readln(f,present);
		if present[1]<>';' then
		  begin
		  inc(l);
		  delete(present,1,pos('"',present));
		  ind.lib:=copy(present,1,pos('",',present)-1);
		  delete(present,1,pos('",',present)+1);
		  val(present,ind.max,code);
		  if length(ind.lib) > ind.max then woops_now(l);
		  ind.trail:=0;
		  while ind.lib[length(ind.lib)-ind.trail]=' ' do inc(ind.trail);
		  write(g,ind);
		  end;
		end;
	 close(f);
	 seek(g,0);
	 edit_line;
	 if one_file then c:=#27 else c:=#0;
	 end;
until c=#27;
clrscr;
halt(0);
END.