// class RMIServer.java jlouie 3.97
// RMIServer --> default connectionName "TestConnection"
// RMIServer name --> connectionName name

import java.rmi.*;
import java.util.*;
import java.net.*;
import java.rmi.server.*;
import jlouie.rmi.*;

public class RMIServer implements ListenerInterface {
   
   public static void main(String[] args) {
      String processName= "TestConnection";
      if (args.length >1) {
         System.out.println("Invalid Argument.");
         System.out.println("Use: RMIServer [processName]");
         return;
      }
      if (args.length > 0) {
         processName= args[0];
      } 
      new RMIServer(processName);
   }
   
   public RMIServer(String processName) {
      System.setSecurityManager(new RMISecurityManager());
      try {
         RMIConnection c= new RMIConnection(processName);
         InetAddress hostIP= InetAddress.getLocalHost();
         if (this instanceof ListenerInterface) {
            c.addListener((ListenerInterface)this);
         }
         c.setSignOn("Welcome to RMIServer.");
         Naming.rebind(processName, c);
         System.out.println(processName + 
            " bound successfully on host "+ hostIP+ ".");
      }
      catch (Exception e) {
         System.out.println(e);
         e.printStackTrace();
      }
   
   }
   
   public void notify(BroadcasterInterface broadcaster) {
      if (broadcaster != null) {
            System.out.println(broadcaster.getMessage()); // For GUI feedback.
      }
   }
   
}
