// file RMIConnection.java jlouie 3.97

package jlouie.rmi;

import java.rmi.*;
import java.util.*;
import java.net.*;
import java.rmi.server.*;
import jlouie.rmi.*;

public class RMIConnection  extends UnicastRemoteObject 
                        implements RMIConnectionInterface,
                                   BroadcasterInterface {
   
   private String processName= "";  // name used to bind object
   private String signOnMessage= "Welcome to the Java Remote Server.";
   private Administrator administrator= null;
   private Anonymous anonymous= null;
   private Vector vListeners= new Vector();
   private String message= "";
   private Vector vMessages= new Vector();
  
   
   public RMIConnection(String processName) 
      throws      java.rmi.RemoteException, 
                  RMIException {
      super();
      this.processName= processName; 
      anonymous= new Anonymous();
      //if (!(anonymous instanceof ClientInterface)) {
            //throw new jlouie.rmi.RMIException(); 
      //}
      administrator= new Administrator(anonymous);
      //if (!(administrator instanceof ClientInterface)) {
            //throw new jlouie.rmi.RMIException();
      //}          
   }
   
   
   public synchronized String getProcessName()
                   throws java.rmi.RemoteException {
      return processName;
   } 
   
   public synchronized String getSignOn()
                   throws java.rmi.RemoteException {
      return signOnMessage;
   } 
   
   public synchronized String getHost()
                   throws java.rmi.RemoteException {
      try {
         InetAddress hostIP= InetAddress.getLocalHost();
         return hostIP.toString();
      }
      catch (java.net.UnknownHostException e) {
         return ("Unknown Host.");
      }           
   }
   
   public synchronized  ClientInterface logOn(String id, String password)
                  throws java.rmi.RemoteException,
                         jlouie.rmi.RMIException,
                         jlouie.rmi.InvalidPasswordException,
                         jlouie.rmi.InvalidIDException {
      if ((administrator == null)||(! (administrator instanceof ClientInterface))) {
            throw new jlouie.rmi.RMIException();
      }
      if ((anonymous == null)||(! (anonymous instanceof ClientInterface))) {
            throw new jlouie.rmi.RMIException();
      }
      if ((id == null)||(id.length()<Constants.MIN_ID_LENGTH)) {
            throw new jlouie.rmi.InvalidIDException();            
      }
      if ((password == null)||(password.length()<Constants.MIN_PW_LENGTH)) {
            throw new jlouie.rmi.InvalidPasswordException();
      }
      if ((administrator.isValidID(id))&&(administrator.isValidPassword(password))) {
            messageServer("Client logged on as: "+id+".");
            return (ClientInterface)administrator;
      }
      // default is "Anonymous","anonymous"
      if ( !(anonymous.isValidID(id))) {
            messageServer("Failed log on attempt as: "+id+".");
            throw new jlouie.rmi.InvalidIDException();
      }
      if (anonymous.isValidPassword(password)) {
            messageServer("Client logged on as: "+id+".");
            return (ClientInterface)anonymous;
      }
      else { 
            messageServer("Failed log on attempt as: "+id+".");
            throw new jlouie.rmi.InvalidPasswordException();
      }                  
   }


   public void setSignOn(String signOnMessage) {
       this.signOnMessage= signOnMessage;
   }
   
   public void setAdminPassword(String password) 
            throws jlouie.rmi.InvalidPasswordException,
                   jlouie.rmi.RMIException {
        if (administrator == null) throw new jlouie.rmi.RMIException();
        administrator.setInternalPassword(password); // may throw InvalidPWE
   }
   
   public void setAnonymousPassword(String password) 
            throws jlouie.rmi.InvalidPasswordException,
                   jlouie.rmi.RMIException {
        if (anonymous == null) throw new jlouie.rmi.RMIException();
        anonymous.setInternalPassword(password); // may throw InvalidPWE        
   }
   
   public void setAdminID(String id) 
            throws jlouie.rmi.InvalidIDException,
                   jlouie.rmi.RMIException {
        if (administrator == null) throw new jlouie.rmi.RMIException();
        administrator.setInternalID(id); // may throw InvalidPIDE
   }
   
   public void setAnonymousID(String id) 
            throws jlouie.rmi.InvalidIDException,
                   jlouie.rmi.RMIException {
        if (anonymous == null) throw new jlouie.rmi.RMIException();
        anonymous.setInternalID(id); // may throw InvalidIDE        
   }
   
   public void addListener(ListenerInterface listener) {
      vListeners.addElement(listener);
   }
   
   public void resetListeners() {
      vListeners= null;
      vListeners= new Vector();
   }
   
   public String getMessage() {
      return message;
   }
   
   public Vector getVector() {
      return vMessages;
   }
   
   private void setMessage(String message) {
      this.message= message;
   }
   
   private void messageServer(String message) {
      setMessage(message);
      Enumeration e= vListeners.elements();
      while(e.hasMoreElements()) {
            Object o= e.nextElement();
            if (o instanceof ListenerInterface) {
                  ((ListenerInterface)o).notify((BroadcasterInterface)this);
            }
      }  
   }
   
   
}
