// file LogOn.java jlouie 4.97

package jlouie.rmi;

import java.awt.event.*;
import java.awt.*;
import java.util.*;

public class LogOn extends jlouie.rmi.WFrame
                  implements ActionListener,
                             jlouie.rmi.BroadcasterInterface {
                             
      public static final String TITLE= "Log On.";

      public static void main(String[] args) {
            (new LogOn("Self Test")).show();
      }
      
      private TextField tfPassword= new TextField();
      private TextField tfID= new TextField();
      private Label     lPassword= new Label("Password: ");
      private Label     lID= new Label("ID: ");
      private Button    bSubmit= new Button("Submit <Enter>");
      private Button    bCancel= new Button("Cancel");
      private Vector    vListeners= new Vector();
      private String    message= "";
      private Vector    vMessages= new Vector();
      private String    pw= Constants.ANONYMOUS_PW;
      private String    id= Constants.ANONYMOUS_ID;

      public LogOn() {
            this(TITLE);
      }
      
      public LogOn(String title) {
            super(title);
            addNotify();
            setLayout(new BorderLayout());
            Panel p= new Panel();
            p.setLayout(new GridLayout(2,1));
            p.add(lID);
            p.add(lPassword);
            add("West", p);
            p= new Panel();
            p.setLayout(new GridLayout(2,1));
            p.add(tfID);
            tfPassword.setEchoChar('*');
            p.add(tfPassword);
            add("Center",p);
            p= new Panel();
            p.setLayout(new GridLayout(1,2));
            p.add(bSubmit);
            p.add(bCancel);
            add("South",p);
            setSize(300,100);
            registerListeners();
      }
      
      public synchronized void show() {
            setLocation(30,30);
            super.show();
            tfID.requestFocus();
      }
      
      private void registerListeners() {
            addWindowListener(this);
            tfID.addActionListener(this);
            tfPassword.addActionListener(this);
            bSubmit.addActionListener(this);
            bCancel.addActionListener(this);
      }
      
      private void doHide() {
            setVisible(false);
            tfID.setText("");
            tfPassword.setText("");
      }
      
      // event implementations
      
      public void windowClosing(WindowEvent e) {
            doHide();
      }
      
      public void actionPerformed(ActionEvent e) {
            Object source= e.getSource();
            if (source instanceof TextField) {
                  submit();
            }
            else if (source instanceof Button) {
                  if (source == bSubmit) submit();
                  else if (source == bCancel) cancel();
            }
      }
      
      // application methods
      
      private void submit() {
            String tempID= tfID.getText();
            String tempPW= tfPassword.getText();
            if(tempID.length()>= Constants.MIN_ID_LENGTH) {
                  id= tempID;
            }
            else {
                  id= Constants.ANONYMOUS_ID;
            }
            if (tempPW.length()>= Constants.MIN_PW_LENGTH) {
                  pw= tempPW;            
            }
            else {
                  pw= Constants.ANONYMOUS_PW;
            }
            messageApplication(id,pw);
            doHide();    
      }
      
      private void cancel() {
            doHide();
      }
      
      // broadcaster implementations
      
      public void addListener(ListenerInterface listener) {
            vListeners.addElement(listener);
      }
   
      public void resetListeners() {
            vListeners= null;
            vListeners= new Vector();
      }
   
      public String getMessage() {
            return message;
      }
   
      public java.util.Vector getVector() {
            return vMessages;
      }
      
      // internal methods
   
      private void setMessage(String message) {
            this.message= message;
      }
      
      private void setVector(Vector v) {
            this.vMessages= v;
      }
   
      private void messageApplication(String id, String pw) {
            Vector temp= new Vector();
            temp.addElement(id);
            temp.addElement(pw);
            setVector(temp);
            Enumeration e= vListeners.elements();
            while(e.hasMoreElements()) {
                  Object o= e.nextElement();
                  if (o instanceof ListenerInterface) {
                        ((ListenerInterface)o).notify((BroadcasterInterface)this);
                  }
            }  
      }

}
