// file ChangeAdministratorPW.java jlouie 4.97

package jlouie.rmi;

import java.awt.event.*;
import java.awt.*;
import java.util.*;

public class ChangeAdministratorPW extends jlouie.rmi.WFrame
                  implements ActionListener,
                             jlouie.rmi.BroadcasterInterface {
      public static final String TITLE= "Change *Administrator* Password.";

      public static void main(String[] args) {
            (new ChangeAdministratorPW("Self Test")).show();
      }
      
      private TextField tfOldPW= new TextField();
      private TextField tfNewPW= new TextField();
      private TextField tfRepeatPW= new TextField();
      private Label     lOldPW= new Label("Old Password: ");
      private Label     lNewPW= new Label("New Password: ");
      private Label     lRepeatPW= new Label("New Password: ");
      private Button    bSubmit= new Button("Submit <Enter>");
      private Button    bCancel= new Button("Cancel");
      private Vector    vListeners= new Vector();
      private String    message= "";
      private Vector    vMessages= new Vector();
      private String    oldPW= "";
      private String    newPW= "";

      public ChangeAdministratorPW() {
            this(TITLE);
      }
      
      public ChangeAdministratorPW(String title) {
            super(title);
            addNotify();
            setLayout(new BorderLayout());
            Panel p= new Panel();
            p.setLayout(new GridLayout(3,1));
            p.add(lOldPW);
            p.add(lNewPW);
            p.add(lRepeatPW);
            add("West", p);
            p= new Panel();
            p.setLayout(new GridLayout(3,1));
            p.add(tfOldPW);
            p.add(tfNewPW);
            p.add(tfRepeatPW);
            tfNewPW.setEchoChar('*');
            tfRepeatPW.setEchoChar('*');
            add("Center",p);
            p= new Panel();
            p.setLayout(new GridLayout(1,2));
            p.add(bSubmit);
            p.add(bCancel);
            add("South",p);
            setSize(300,125);
            registerListeners();
      }
      
      public synchronized void show() {
            setLocation(30,30);
            super.show();
            tfOldPW.requestFocus();
      }
      
      private void registerListeners() {
            addWindowListener(this);
            tfNewPW.addActionListener(this);
            tfOldPW.addActionListener(this);
            tfRepeatPW.addActionListener(this);
            bSubmit.addActionListener(this);
            bCancel.addActionListener(this);
      }
      
      private void doHide() {
            setVisible(false);
            tfNewPW.setText("");
            tfOldPW.setText("");
            tfRepeatPW.setText("");
      }
      
      // event implementations
      
      public void windowClosing(WindowEvent e) {
            doHide();
      }
      
      public void actionPerformed(ActionEvent e) {
            Object source= e.getSource();
            if (source instanceof TextField) {
                  submit();
            }
            else if (source instanceof Button) {
                  if (source == bSubmit) submit();
                  else if (source == bCancel) cancel();
            }
      }
      
      // application methods
      
      private void submit() {
            String tempOldPW= tfOldPW.getText();
            String tempNewPW= tfNewPW.getText();
            String tempRepeatPW= tfRepeatPW.getText();
            if ((tempOldPW.length()>= Constants.MIN_PW_LENGTH)&&
                  (tempNewPW.equals(tempRepeatPW))) {
                  oldPW= tempOldPW;
                  newPW= tempNewPW;
            }
            else {
                  newPW= "";
            }
            messageApplication(oldPW,newPW);
            doHide();    
      }
      
      private void cancel() {
            doHide();
      }
      
      // broadcaster implementations
      
      public void addListener(ListenerInterface listener) {
            vListeners.addElement(listener);
      }
   
      public void resetListeners() {
            vListeners= null;
            vListeners= new Vector();
      }
   
      public String getMessage() {
            return message;
      }
   
      public java.util.Vector getVector() {
            return vMessages;
      }
      
      // internal methods
   
      private void setMessage(String message) {
            this.message= message;
      }
      
      private void setVector(Vector v) {
            this.vMessages= v;
      }
   
      private void messageApplication(String oldPW, String newPW) {
            Vector temp= new Vector();
            temp.addElement(oldPW);
            temp.addElement(newPW);
            setVector(temp);
            Enumeration e= vListeners.elements();
            while(e.hasMoreElements()) {
                  Object o= e.nextElement();
                  if (o instanceof ListenerInterface) {
                        ((ListenerInterface)o).notify((BroadcasterInterface)this);
                  }
            }  
      }

}
