// file Anonymous.java jlouie 3.97

package jlouie.rmi;

import java.rmi.*;
import java.util.*;
import java.net.*;
import java.rmi.server.*;
import jlouie.rmi.*;

public class Anonymous  extends UnicastRemoteObject 
                        implements ClientInterface {
                         
   private static final String DEFAULT_PRIVILEGES= "Anonymous";
   private int privileges= Constants.ANONYMOUS;
   private String password= Constants.ANONYMOUS_PW;
   private String id= Constants.ANONYMOUS_ID;
  
   
   public Anonymous() throws java.rmi.RemoteException {
      super();
   }
      
   public synchronized int getPrivileges()
                   throws java.rmi.RemoteException {
      return privileges;
   }
   
   public synchronized void setMyPassword(String password)
            throws jlouie.rmi.AccessDeniedException {
      throw new jlouie.rmi.AccessDeniedException();
   }
   
   public synchronized String getEcho(String echo) {
      return echo;
   }
   
   public synchronized boolean isValidPassword(String submit) {
      if (submit != null) {
            return submit.equals(password);
      }
      else return false;
   }
   
   public synchronized boolean isValidID(String submit) {
      if (submit != null) {
            return submit.equals(id);
      }
      else return false;
   }
   
   public synchronized void setAnonymousID(String id)
                  throws java.rmi.RemoteException,
                         jlouie.rmi.AccessDeniedException {
      throw new jlouie.rmi.AccessDeniedException();                 
   } 
   
   public synchronized  void setAnonymousPassword(String password)
                  throws java.rmi.RemoteException,
                         jlouie.rmi.AccessDeniedException {
      throw new jlouie.rmi.AccessDeniedException(); 
   } 
   
   public void setInternalID(String id)
                  throws jlouie.rmi.InvalidIDException {
      if (password.length() >= Constants.MIN_ID_LENGTH) {
            this.id= id;
      }
      else throw new jlouie.rmi.InvalidIDException();                 
                  
   } 
   
   public void setInternalPassword(String password)
                  throws jlouie.rmi.InvalidPasswordException {
      if (password.length() >= Constants.MIN_PW_LENGTH) {
            this.password= password;
      }
      else {
            throw new jlouie.rmi.InvalidPasswordException();
      }   
   } 
}
