// file Administrator.java jlouie 3.97

package jlouie.rmi;

import java.rmi.*;
import java.util.*;
import java.net.*;
import java.rmi.server.*;
import jlouie.rmi.*;

public class Administrator  extends UnicastRemoteObject 
                        implements ClientInterface {
                         
   private static final String DEFAULT_PRIVILEGES= "Administrator";
   private int privileges= Constants.ADMINISTRATOR;
   private String password= Constants.ADMIN_PW;
   private String id= Constants.ADMIN_ID;
   private Anonymous anonymous= null;
  
   public Administrator(Anonymous anonymous) 
            throws java.rmi.RemoteException,
                   jlouie.rmi.RMIException {
      super();
      if (anonymous != null) {
            this.anonymous= anonymous;
      }
      else {
            throw new jlouie.rmi.RMIException();
      }
   }
   
   public synchronized void setMyPassword(String password)
            throws jlouie.rmi.InvalidPasswordException {
      if ((password != null)&&(password.length()>=Constants.MIN_PW_LENGTH)) {
            this.password= password;
      } 
      else {
            throw new jlouie.rmi.InvalidPasswordException();
      }                 
   }
   
   
   public synchronized int getPrivileges()
                   throws java.rmi.RemoteException {
      return privileges;
   }
   
   public synchronized String getEcho(String echo) {
      return echo;
   }
   
   public synchronized boolean isValidPassword(String submit) {
      return submit.equals(password);
   }
   
   public synchronized boolean isValidID(String submit) {
      if (submit != null) {
            return submit.equals(id);
      }
      else return false;
   }
   
   public void setMyID(String id)
                  throws jlouie.rmi.InvalidIDException {
      if (password.length() >= Constants.MIN_ID_LENGTH) {
            this.id= id;
      }
      else throw new jlouie.rmi.InvalidIDException();                 
                  
   } 
   
   public synchronized void setAnonymousPassword(String password)
                  throws java.rmi.RemoteException,     
                         jlouie.rmi.InvalidPasswordException,
                         jlouie.rmi.RMIException {
      if (anonymous != null) {
            anonymous.setInternalPassword(password); // may throw IPE
      }
      else throw new jlouie.rmi.RMIException();
   } 
   
   public synchronized void setAnonymousID(String id)
                  throws java.rmi.RemoteException,
                         jlouie.rmi.InvalidIDException,
                         jlouie.rmi.RMIException {
      if (id != null) {
            anonymous.setInternalID(id); // may throw IIDE
      }
      else throw new jlouie.rmi.RMIException();
   }
   
   public void setInternalID(String id)
                  throws jlouie.rmi.InvalidIDException {
      if (password.length() >= Constants.MIN_ID_LENGTH) {
            this.id= id;
      }
      else throw new jlouie.rmi.InvalidIDException();                 
                  
   } 
   
   public void setInternalPassword(String password)
                  throws jlouie.rmi.InvalidPasswordException {
      if (password.length() >= Constants.MIN_PW_LENGTH) {
            this.password= password;
      }
      else throw new jlouie.rmi.InvalidPasswordException();   
   }  
}
