/**/
v="$VER: WFreqList  Rexx WPL Freq List Creator Williamson 53.04"
/*
   Based on Falcon File Manager by Robert Williamson 1:167/104.0
        Originally Modified for Falcon CBCS By Tony Jones (2:255/35)
        from Tim Aston's TransAmiga BBS script, FileUtil.trans

      Be sure to change the List command exclusion parameters (EXCLUDE)  
      for those files you want ignored in listings

    Config File Format: (bbslist)
    AREA 1
    NAME "Communications SOFTWARE"
    PATH "BBSFILES:comms/"
    LEVEL NORMAL
    PASSWORD areapassword               <---optional password for area
*/
debug=0
sort=0
/* LIST exclusion parameters    */
EXCLUDE     =   '~(empty|area.text|files.bbs|LZTEMP.#?|.info)'
/* WB2 List Lformat parameters  */
LFFREQ      =   '"%N %F%N"'                       /* freq.lst         */

/*  You must create these files */
bbslist     = "RAM:config/fileareas.bbs"               /* filearea config  */
mtext       = "CFG:MAGIC.TXT"                   /* FREQ Magic names */

/* System description header */
/* This should also contain the list of MAGIC filenames accepted */
htext       = "CFG:filelistheader.txt" 

fldir       = "Mail:FILELISTS"                 /* Freqable filelists dir */
/* Note: some Freq makers require that this standard be followed */
all_list     = "01670104.LST"                   /* Normal Level List */
all_arc      = "01670104.LHA"                   /* Archived Normal List */
new_list     = "NEWFILES.LST"                   /* Newfiles list */


/* output files - edit names to suit */
freqlist     = "MAIL:freq.lst"                  /* filename, full path */


/* Configuration of Magic File Names for FREQ List              */
/* Standard MAGIC FileNames That Never Change                   */
/* DO NOT change these entries, these are configured above      */
magic.1 = "FILES    > "addslash(fldir)||all_arc     /* configured above */
magic.2 = "NEWFILES > "addslash(fldir)||new_list    /* configured above */
magic.3 = "NEW      > "addslash(fldir)||new_list    /* configured above */
magic.4 = "MAGIC    > "htext                         /* configured above */
magic.5 = "ABOUT    > "htext                         /* configured above */

/* add your FIXED MAGIC names here */
magic.6     = "ROOFREXX > bbsf6:ROOF/ROOF_REXX.LHA"
magic.7     = "ROOFDOS  > bbsf6:ROOF/ROOF_DOS.LHA"
magic.8     = "ROOFDOCS > bbsf6:ROOF/ROOF_DOCS.LHA"
magic.9     = "ROOFBIN  > bbsf6:ROOF/ROOF_BIN.LHA"
magic.10    = "ROOFRCP  > bbsf6:ROOF/ROOF_RCP.LHA"
magic.11    = "ROOFWPL  > BBSF6:ROOF/ROOF_WPL.LHA"
magic.12    = "ROOF     > BBSF6:ROOF/ROOF.LHA"

/* FileNames that require updating to the latest version should */
/* use '^' instead of '>'                                       */
magic.13    = "FILEMGR      ^ BBSF6:ROOF/FILEMGR_V??.??.LHA"
magic.14    = "FANSI        ^ BBSF4:G&S/FANSI_V?.?.LHA"
magic.15    = "DEKSID       ^ BBSF6:DUTIL/DEK???.LHA"
magic.16    = "BBSLIST      ^ BBSF5:MTL-BBS/BBS?????.LST"

/* Where more than one file will be sent for a MAGIC name       */
/* just have multiple entries pointing to same magic name       */
magic.17 = "WELMAT          > BBSF6:WPL/WPL_DOC.LHA"

magic.18 = "MAILSCAN        > BBSF6:FALCON/MailScan_v1.39.LHA"
magic.19 = "ROOFBBS         > bbsf6:ROOF/Roof_BBS.LHA"
magic.20 = "ROOFRCP         > BBSF6:ROOF/ROOF_RCP.LHA"
magic.21 = "ROOFTA          > BBSF6:ROOF/ROOF_TA.LHA"
magic.22 = "ROOFDLG         > BBSF6:ROOF/ROOF_DLG.LHA"

magic.23 = "AREAMGR         ^ BBSF6:ROOF/AM_v????.LHA"
magic.24 = "CFG             > CFG:WPL/ROOF.WPL"
magic.25 = "CFG             > CFG:WPL/ROOFCFG.WPL"
magic.26 = "CFG             > CFG:WPL/ROOFMENUS.WPL"
magic.27 = "CFG             > CFG:WPL/ROOFNOTIFY.WPL"
magic.28 = "CFG             > CFG:ROOF.CFG"
magic.29 = "BTC             > S:BTC"
magic.30 = "RFS              > BBSF6:ROOF/RFS.LHA"
magic.31 = "WPL             > BBSF6:WPL/WPL_DOC.LHA"
magic.32 = "UMBRELLA        > BBSF6:wpl/UMBRELLA.LHA"
magic.33 = "GENMAILER       > BBSF6:wpl/GENMAILER.LHA"
magic.34 = "GAZEBO          > BBSF6:wpl/GAZEBO.LHA"
magic.35 = "PORTICUS        > BBSF6:wpl/PORTICUS.LHA"
magics = 35
magic.0 = 35
/* NUMBER of MAGIC NAMES */

/* used internally */
freqtemp = "T:FLST-"Pragma('ID')            /* temporary freq list */

script  = "WFreqList"
ver     = "v"||right(v,5)
lf      = '0a'x
CSI     = '9b'x
OFF     = CSI||'0m'
BOLD    = CSI||'1m'
ULINE   = CSI||'4m'
ITALICS = CSI||'3;40m'
quote   = '"'

fmvers  = BOLD||'[36;40m'script ver||OFF
options results
options failat 20
signal on halt
signal on ioerr
signal on break_c
signal on break_d

    call close('STDOUT')
    call open('STDOUT',"RAW:0/10/640/100/"script ver"/CLOSE",'w')
    call close('STDIN')
    call open('STDIN','*','R')

if ~show("L", "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then
        do
                call writeln(STDOUT, "Couldn't access support.library !")
                exit 20
        end


    if ~open('dlst',bbslist, 'R') then
    do
        call writeln(STDOUT, "Couldn't open fileareas list !")
        exit 20
    end
    if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Updating Freq Listing'
    call writeln(STDOUT, lf||ITALICS||" "fmvers||lf||" by Robert Williamson 1:167/104.0@fidonet"||OFF)
    /* Start Area Processing */
    call writeln(STDOUT, 'Reading file area configuration')
    area = 0
    do while ~eof('dlst')
        call writech(STDOUT,'.')
        blstln=readln('dlst')
        if blstln="" then iterate
        blstkey=upper(left(blstln, 4))
        select
            when blstkey = 'AREA' then
            do
                area=area+1
                Number.area=strip(word(blstln,2) )
            end
            when blstkey= 'NAME' then Name.area=strip( substr(blstln,6,79) )
            when blstkey= 'PATH' then Path.area=strip( dequote(substr(blstln,6,40) ))
            when blstkey= 'PASS' then Password.area=strip(word(blstln,2) )
            when blstkey= 'LEVE' then
            do
                lvl=word(blstln,2)
                if lvl = 'TWIT' | lvl="DISGRACE" | lvl="NORMAL" then Level.area='INCLUDE'
                    else Level.area='EXCLUDE'   
            end
            otherwise NOP
        end  /* select */

        if Level.area="EXCLUDE" then 
        do
            call writeln(STDOUT,lf||'Area' Number.area Name.area 'excluded')
            if area >1 then 
            do
                Level.area=""
                area=area-1
                Iterate
            end
        end
    end /*eof*/

    areas=area-1
    call writeln(STDOUT,lf||'Found 'areas' file areas')

    call writeln(STDOUT, BOLD||"Generating File Request Listing"||OFF||lf)
    if exists(mtext) then address COMMAND 'Copy' mtext freqtemp
    else do
        call open('lstf',freqtemp,'W')      /* create the file */
        call close('lstf')                 /* delete old one  */
    end
    if (magics ~= 0) then
    do
        CR='0a'x
        if ~open('tfl',freqtemp,'A') then
        do
            call writeln(STDOUT, 'Unable to open 'freqtemp)
            exit 10
        end
        call writeln(STDOUT, 'Updating 'magics' Magic names')
        do i=1 to magics
            call writech(STDOUT,'.')
            /*                                                  file/magicname           !password                fullpath */
            if left(word(magic.i,2),1) = '!' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,2))' 'strip(word(magic.i,3))||CR)
                else if word(magic.i,2) = '>' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,3))||CR)
            if word(magic.i,2) = '^' then
            do
                close('tfl')
                cmd='List >>'freqtemp word(magic.i,3) LFORMAT '"'word(magic.i,1)' %P%N"'
                address COMMAND cmd
                open('tfl',freqtemp,'A')
            end
        end
        call close('tfl')
    end

    call writeln(STDOUT, lf||'Processing')
    do area=1 to areas
/*        if ~debug then call writech(STDOUT,'.')   */
        if ~debug then call writeln(STDOUT,Path.area)
        else do
            /* Display info on a area */
            call writeln(STDOUT, BOLD||'Area       '||OFF Number.area)
            call writeln(STDOUT, BOLD||'Name       '||OFF Name.area)
            call writeln(STDOUT, BOLD||'Path       '||OFF Path.area)
        end
        if Password.area = "PASSWORD."area | Password.area = "" then 
        do
            if debug then call writeln(STDOUT, BOLD||'Password   '||OFF 'none')
            address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT='LFFREQ
        end
        else do
            if debug then call writeln(STDOUT, BOLD||'Password   '||OFF Password.area)
            address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT="%N !'Password.area' %F%N"'
        end
    end
    
    if sort then
    do
        call writeln(STDOUT, BOLD||'Sorting 'freqtemp' to 'freqlist||OFF)
        address COMMAND 'SORT' freqtemp freqlist
    end
    else do
        address COMMAND 'COPY' freqtemp freqlist
        if RC=0 then call delete(freqtemp)      
    end
    if exists("RAM:FREQ.LST") then address COMMAND 'Copy' freqlist "RAM:FREQ.LST"
    call writeln(STDOUT, 'Freq Listing completed')
    if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Freq Listing completed'
exit

/* a useful procedure by Walt Sullivan  */
dequote:
    parse arg thing
    parse var thing '"' unq_thing '"'
    if unq_thing ~= "" then return unq_thing
return thing

addslash:
    curr = arg(1)
    select
        when right(curr, 1) = ":" then nop
            when right(curr, 1) = "/" then nop
                otherwise curr = curr"/"
    end
return curr
   
/*
  Error handling
*/

halt:
ioerr:
break_c:
break_d:
    call writech(STDOUT,lf)
    exit 10

