/**/
v="$VER: RFSfreqList  Rexx WPL Freq List Creator Williamson 54.02"
/*
   Based on Falcon File Manager by Robert Williamson 1:167/104.0
        Originally Modified for Falcon CBCS By Tony Jones (2:255/35)
        from Tim Aston's TransAmiga BBS script, FileUtil.trans

      Be sure to change the List command exclusion parameters (EXCLUDE)  
      for those files you want ignored in listings

    Config File Format:
    AREA# "PATH" "NAME"
*/
call Pragma("P",-1)
debug=0
sort=1
/* LIST exclusion parameters    */
EXCLUDE     =   '~(empty|area.text|files.bbs|LZTEMP.#?|.info)'
/* WB2 List Lformat parameters  */
LFFREQ      =   '"%N %F%N"'                       /* freq.lst         */

/*  You must create these files */
bbslist     = "BBS:text/bbsn.list"               /* filearea config  */
mtext       = "CFG:MAGIC.TXT"                    /* FREQ Magic names */

/* System description header */
/* This should also contain the list of MAGIC filenames accepted */
htext       = "CFG:filelistheader.txt" 

fldir       = "Mail:FILELISTS"                 /* Freqable filelists dir */
/* Note: some Freq makers require that this standard be followed */
all_list     = "01670104.LST"                   /* Normal Level List */
all_arc      = "01670104.LHA"                   /* Archived Normal List */
new_list     = "NEWFILES.LST"                   /* Newfiles list */


/* output files - edit names to suit */
freqlist     = "MAIL:freq.lst"                  /* filename, full path */


/* Configuration of Magic File Names for FREQ List              */
/* Standard MAGIC FileNames That Never Change                   */
/* DO NOT change these entries, these are configured above      */
magic.1 = "FILES    > "addslash(fldir)||all_arc     /* configured above */
magic.2 = "NEWFILES > "addslash(fldir)||new_list    /* configured above */
magic.3 = "NEW      > "addslash(fldir)||new_list    /* configured above */
magic.4 = "MAGIC    > "htext                         /* configured above */
magic.5 = "ABOUT    > "htext                         /* configured above */

/* add your FIXED MAGIC names here */
magic.6     = "ROOFREXX > bbsf6:ROOF/ROOF_REXX.LHA"
magic.7     = "ROOFDOS  > bbsf6:ROOF/ROOF_DOS.LHA"
magic.8     = "ROOFDOCS > bbsf6:ROOF/ROOF_DOCS.LHA"
magic.9     = "ROOFBIN  > bbsf6:ROOF/ROOF_BIN.LHA"
magic.10    = "ROOFRCP  > bbsf6:ROOF/ROOF_RCP.LHA"
magic.11    = "ROOFWPL  > BBSF6:ROOF/ROOF_WPL.LHA"
magic.12    = "ROOF     > BBSF6:ROOF/ROOF.LHA"
magic.13    = "UMBRELLA > BBSF6:wpl/UMBRELLA.LHA"
magic.14    = "XPACK    > BBSF6:wpl/XPACK.LHA"
magic.15    = "GAZEBO   > BBSF6:wpl/GAZEBO.LHA"
magic.16    = "PORTICUS > BBSF6:wpl/PORTICUS.LHA"
magic.17    = "RFS      > BBSF6:ROOF/RFS.LHA"
magic.18    = "WPLRX    > BBSF6:ROOF/WPLRX.LHA"
magic.19    = "WFREQIT  > BBSF6:ROOF/WFREQIT.LHA"

/* FileNames that require updating to the latest version should */
/* use '^' instead of '>'                                       */
magic.20    = "FILEMGR      ^ BBSF6:ROOF/FILEMGR_V??.??.LHA"
magic.21    = "FANSI        ^ BBSF4:G&S/FANSI_V?.?.LHA"
magic.22    = "DEKSID       ^ BBSF6:DUTIL/DEK???.LHA"
magic.23    = "BBSLIST      ^ BBSF5:MTL-BBS/BBS?????.LST"
magics = 23
magic.0 = 23
/* NUMBER of MAGIC NAMES */

/* used internally */
freqtemp = "T:FLST-"Pragma('ID')            /* temporary freq list */

script  = "RFSfreqList"
ver     = "v"||right(v,5)
lf      = '0a'x
CSI='9b'x;OFF=CSI||'0m';BOLD=CSI||'1m';ULINE=CSI||'4m';ITALICS=CSI||'3;40m'
quote   = '"'

fmvers  = BOLD||'[36;40m'script ver||OFF
options results
options failat 20
signal on halt
signal on ioerr
signal on break_c
signal on break_d

    call close('STDOUT')
    call open('STDOUT',"RAW:0/10/640/100/"script ver"/CLOSE",'w')
    call close('STDIN')
    call open('STDIN','*','R')

if ~show("L", "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then
        do
                call writeln(STDOUT, "Couldn't access support.library !")
                exit 20
        end


    if ~open('dlst',bbslist, 'R') then
    do
        call writeln(STDOUT, "Couldn't open fileareas list !")
        exit 20
    end
    if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Updating Freq Listing'
    call writeln(STDOUT, lf||ITALICS||" "fmvers||lf||" by Robert Williamson 1:167/104.0@fidonet"||OFF)
    /* Start Area Processing */
    call writeln(STDOUT, 'Reading file area configuration')
    area = 0
    do while ~eof('dlst')
        call writech(STDOUT,'.')
        blstln=readln('dlst')
        if blstln="" then iterate
        parse var blstln Number.area '"' Path.area '"' '"' Name.area '"'
        area=area+1
    end /*eof*/

    areas=area-1
    call writeln(STDOUT,lf||'Found 'areas' file areas')

    call writeln(STDOUT, BOLD||"Generating File Request Listing"||OFF||lf)
    if exists(mtext) then address COMMAND 'Copy' mtext freqtemp
    else do
        call open('lstf',freqtemp,'W')      /* create the file */
        call close('lstf')                 /* delete old one  */
    end
    if (magics ~= 0) then
    do
        CR='0a'x
        if ~open('tfl',freqtemp,'A') then
        do
            call writeln(STDOUT, 'Unable to open 'freqtemp)
            exit 10
        end
        call writeln(STDOUT, 'Updating 'magics' Magic names')
        do i=1 to magics
            call writech(STDOUT,'.')
            /*                                                  file/magicname           !password                fullpath */
            if left(word(magic.i,2),1) = '!' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,2))' 'strip(word(magic.i,3))||CR)
                else if word(magic.i,2) = '>' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,3))||CR)
            if word(magic.i,2) = '^' then
            do
                close('tfl')
                cmd='List >>'freqtemp word(magic.i,3) LFORMAT '"'word(magic.i,1)' %P%N"'
                address COMMAND cmd
                open('tfl',freqtemp,'A')
            end
        end
        call close('tfl')
    end

    call writeln(STDOUT, lf||'Processing')
    do area=0 to areas
        if ~debug then call writeln(STDOUT,Path.area)
        else do
            /* Display info on a area */
            call writeln(STDOUT, BOLD||'Area       '||OFF Number.area)
            call writeln(STDOUT, BOLD||'Name       '||OFF Name.area)
            call writeln(STDOUT, BOLD||'Path       '||OFF Path.area)
        end
        if Password.area = "PASSWORD."area | Password.area = "" then 
        do
            if debug then call writeln(STDOUT, BOLD||'Password   '||OFF 'none')
            address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT='LFFREQ
        end
        else do
            if debug then call writeln(STDOUT, BOLD||'Password   '||OFF Password.area)
            address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT="%N !'Password.area' %F%N"'
        end
    end
    
    if sort then
    do
        call writeln(STDOUT, BOLD||'Sorting 'freqtemp' to 'freqlist||OFF)
        address COMMAND 'SORT' freqtemp freqlist
    end
    else do
        call writeln(STDOUT, BOLD||'Copying 'freqtemp' to 'freqlist||OFF)
        address COMMAND 'COPY' freqtemp freqlist
    end
    call delete(freqtemp)      
    if exists("RAM:FREQ.LST") then 
    do
        call writeln(STDOUT, BOLD||'Copying 'freqlist' to RAM:'||OFF)
        address COMMAND 'Copy' freqlist "RAM:FREQ.LST"
    end
    call writeln(STDOUT, 'Freq Listing completed')
    if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Freq Listing completed'
exit

dequote:
parse arg thing
parse var thing '"' unq_thing '"'
if unq_thing ~= "" then return unq_thing
return thing

addslash:
curr = arg(1)
select
    when right(curr, 1) = ":" then nop
        when right(curr, 1) = "/" then nop
            otherwise curr = curr"/"
end
return curr
   
halt:
ioerr:
break_c:
break_d:
    call writech(STDOUT,lf)
    exit 10

