{**************************************}
{       TRFM 2.5 for Delphi 16/32      }
{ Copyright 1997  RealSoft Development }
{                - - -                 }
{     RealForm Record Definitions      }
{**************************************}

unit Rfmrec;

interface

uses Graphics;

type
        TDrawType    =  (rfNone, rfUnused, rfText, rfFrame, rfLine, rfCkBox, rfField);
        TLineType    =  (ltHorz, ltVert, ltDiagL, ltDiagR);
        TFillStyle   =  (fsClear, fsSolid, fsDiagonal, fsHash);
        TPageSize    =  (psLegal, psLetter, psA3, psA4, psA5);
        TOrientation =  (orPortrait, orLandScape);

        {----------Header Data----------}
        RFormHdr = packed record
          NumRecs               : smallint;
          PageSize              : TPageSize;
          Thick                 : byte;
          PStyle                : TPenStyle;
          Width                 : Word;
          Height                : Word;
          VersionMajor          : byte;
          VersionMinor          : byte;
          Orientation           : TOrientation;
          Unused                : array[0..86] of byte;
          end;

        {----------Object Data----------}
        RFormRec = packed record
          DrawType               : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx1               : word;
          StrIdx2               : word;
          unused                : array[0..11] of byte;
        end;

        RFormText = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx                : word;
          FontIdx               : word;
          FontStyle             : TFontStyles;
          FontSize              : byte;
          Color                 : byte;
          Vert                  : boolean;
          unused                : array[0..7] of byte;
          end;

        RFormFrame = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          FStyle                : TFillStyle;
          Color                 : byte;
          LColor                : byte;
          Thick                 : byte;
          unused                : array[0..10] of byte;
          end;

        RFormLine = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          LType                 : TLineType;
          Color                 : byte;
          Thick                 : byte;
          unused                : array[0..11] of byte;
          end;

        RFormCkBox = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          Color                 : byte;
          Thick                 : byte;
          unused                : array[0..13] of byte;
          end;

        {-----------Field Data----------}
        RFormField = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx                : word;
          FontIdx               : word;
          FontStyle             : TFontStyles;
          FontSize              : byte;
          Color                 : byte;
          Vert                  : boolean;
          Format                : byte;
          unused                : array[0..6] of byte;
          end;

        RRFLField = packed record
          Left                  : smallint;
          Top                   : smallint;
          Vert                  : boolean;
          Format                : byte;
          Name                  : String[20];
          FontName              : String[32];
          FontStyle             : TFontStyles;
          FontSize              : byte;
          FontColor             : byte;
          end;

        RCopyRec = array[0..24] of byte;

implementation


end.
