/* rexx */
'@cls'
say
say 'G2Funcs --- Testing program for REXXGDB2.DLL functions'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., December 1995'
say

line = copies('-', 79)

errmsg = ''
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
/*
------------------------------------------------------------------------
                   Creating two packages for REXXGDB2
------------------------------------------------------------------------
*/
say line
say 'If this is your first (ever) G2FUNCS.CMD execution, or if you'
say 'want to rebuild the G2GOISO, G2GOUSA and G2GOEUR packages,'
say 'type yes and press Enter now!'
say 'Otherwise, just press Enter to continue...'
pull answer
if left(answer, 1) = 'Y' then do
   say 'Connecting to SAMPLE database...'
   'DB2 CONNECT TO SAMPLE'
   say 'Creating package G2GOISO (to use ISO Date/Time format)...'
   "DB2 BIND REXXGDB2.BND DATETIME ISO COLLECTION 'G2GOISO'"
   say
   say 'Creating package G2GOUSA (to use USA Date/Time format)...'
   "DB2 BIND REXXGDB2.BND DATETIME USA COLLECTION 'G2GOUSA'"
   say
   say 'Creating package G2GOEUR (to use Europe Date/Time format)...'
   "DB2 BIND REXXGDB2.BND DATETIME EUR COLLECTION 'G2GOEUR'"
   end

/*
------------------------------------------------------------------------
                              G2LoadFuncs
------------------------------------------------------------------------
*/
say line
if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

database = 'Sample'
call G2ConnectReset                    /* disconnect prev. session */
say
say 'Using the default package (ISO Date/Time format)...'
call G2SetCurPkgSet 'G2GOISO'

/*
------------------------------------------------------------------------
                             G2ConnectShare
------------------------------------------------------------------------
*/
say line
say 'Connecting to database' database'...'
call time 'R'
sqlcode = G2ConnectShare(database)
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode

/*
------------------------------------------------------------------------
                               G2CurDate
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurDate()
elapse = time('E')
say 'Current Date               =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2CurExplSnap
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurExplSnap()
elapse = time('E')
say 'Current Explain Snapshot   =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2SetExplSnap
------------------------------------------------------------------------
*/
say line
say 'Setting Current Explain Snapshot to YES...'
say 'Current Explain... (before)=' G2CurExplSnap()
call time 'R'
value  = G2SetCurExplSnap('Yes')
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Explain... (after) =' G2CurExplSnap()

say 'Setting Current Explain Snapshot to EXPLAIN...'
call time 'R'
value  = G2SetCurExplSnap('ExPlaiN')
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Explain... (now)   =' G2CurExplSnap()
call wait

/*
------------------------------------------------------------------------
                             G2CurFuncPath
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurFuncPath()
elapse = time('E')
say 'Current Function Path      =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2CurQueryOpt
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurQueryOpt()
elapse = time('E')
say 'Current Query Optimization =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2SetQueryOpt
------------------------------------------------------------------------
*/
say line
say 'Setting Current Query Optimization to 0...'
say 'Current Query Opt. (before)=' G2CurQueryOpt()
call time 'R'
value  = G2SetCurQueryOpt(0)
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Query Opt. (after) =' G2CurQueryOpt()
call wait

/*
------------------------------------------------------------------------
                              G2CurServer
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurServer()
elapse = time('E')
say 'Current Server             =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                               G2CurTime
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurTime()
elapse = time('E')
say 'Current Time               =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2CurTimeStamp
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurTimeStamp()
elapse = time('E')
say 'Current Time Stamp         =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2CurTimeZone
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2CurTimeZone()
elapse = time('E')
say 'Current Time Zone          =' value
say '        length             =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                               G2CurUser
------------------------------------------------------------------------
*/
say line
call time 'R'
value  = G2User()
elapse = time('E')
say 'User                       =' value
say 'length                     =' length(value)
say 'Execution time             =' elapse
say 'G2SQLCODE                  =' G2sqlcode
call wait

/*
------------------------------------------------------------------------
                            G2SetConnection
------------------------------------------------------------------------
*/
say line
say 'Setting Connect to' database'...'
call time 'R'
sqlcode = G2SetConnection(database)
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
call wait

/*
------------------------------------------------------------------------
                             G2SetCurPkgSet
------------------------------------------------------------------------
*/
say line
say 'Setting Current Packageset to G2GOUSA (U.S.A. DateTime format)...'
say 'Current Date/Time (default)=' G2CurDate() G2CurTime()
call time 'R'
sqlcode = G2SetCurPkgSet('G2GOUSA')
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Date/Time (U.S.A.) =' G2CurDate() G2CurTime()
say 'Setting Current Packageset to G2GOEUR (Europe DateTime format)...'
call time 'R'
sqlcode = G2SetCurPkgSet('G2GOEUR')
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Date/Time (Europe) =' G2CurDate() G2CurTime()
say 'Setting Current Packageset to G2GOISO (ISO, default DateTime format)...'
call time 'R'
sqlcode = G2SetCurPkgSet('G2GOISO')
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode
say 'Current Date/Time (default)=' G2CurDate() G2CurTime()
call wait

/*
------------------------------------------------------------------------
                             G2ConnectReset
------------------------------------------------------------------------
*/
say line
say 'Disconnecting...'
call time 'R'
sqlcode = G2ConnectReset()
elapse = time('E')
say 'Execution time             =' elapse
say 'Return code (SQLCODE)      =' sqlcode

/*
------------------------------------------------------------------------
                      G2Immed (using G2Immediate)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ G2Immed.CMD and other test programs?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'G2Immed.CMD'

/*
------------------------------------------------------------------------
                      G2SelectCols (using G2Cols)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ G2Cols.CMD and other test programs?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'G2Cols.CMD'

/*
------------------------------------------------------------------------
                      G2SelectData (using G2Data)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ G2Data.CMD and other test programs?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'G2Data.CMD'

/*
------------------------------------------------------------------------
                      G2SelectForm (using G2Form)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ G2Form.CMD and other test programs?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'G2Form.CMD'

/*
------------------------------------------------------------------------
                       G2SelectOne (using G2One)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ G2One.CMD and other test programs?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'G2One.CMD'

/*
------------------------------------------------------------------------
                      G2DropFuncs (using DropGDB2)
------------------------------------------------------------------------
*/
say line
say 'Do you want to continue w/ DropGDB2.CMD program?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0

say line
call 'DropGDB2.CMD'

/*
------------------------------------------------------------------------
                               Conclusion
------------------------------------------------------------------------
*/
say
say 'Press Enter now to conclude this program...'
pull answer
'cls'
say
say "You've just completed all programs to test all functions"
say 'included in REXXGDB2.DLL.'
say
say 'Thank you so much for using the products included in this'
say 'package.'
say
say 'Please read the online document REXXGDB2.INF for a complete'
say 'package information.  That file can be viewed and printed'
say 'through OS/2 VIEW command which you can run from the command'
say 'prompt.'
say
say 'Regards,'
say 'Simon Husin in Kent, Washington, U.S.A., December 1995'
say 'E-mail: husin@ibm.net'
say line
say 'Do you want to view REXXGDB2.INF now?'
say 'Type No and press Enter to Quit now!'
say 'Just Press Enter otherwise to continue...'
pull answer
if left(answer, 1) = 'N' then return 0
'start /N view REXXGDB2'
return 0

error:
if errmsg = '' then
   errmsg = 'Unknown error(s) detected...'
syntax:
if errmsg = '' then
   errmsg = 'Syntax error detected...'
say errmsg
return 10

wait:
say 'Press Enter to continue...'
pull xxx
return 0
