/* REXX **********************************************/
/*                                                   */
/* Name.......: ToLower.CMD                          */
/* Function...: Test Rexx algorithms for Translate   */
/*              To Lower Case for Umlauts            */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _string

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( TRANSLATE UMLAUTS TO LOWER CASE )", 80, '*')

/*------------(Test To Lower Case)---------------*/
string = 'TEST TRANSLATION TO LOWER CASE OF ,  AND '
Say 'This upper case string ....:' string
Say 'is translated to lower case:' ToLower(string)

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)===============*/
/*=============(Translate To Lower Case)===============*/
/* :-)                                               8 */
/* Name.......: ToLower                                */
/*                                                     */
/* Function...: Translate entired string to lower      */
/*              case                                   */
/* Call parms.: String to translate                    */
/* Returns....: Translated string                      */
/*                                                     */
/* Syntax.....: lowString = ToLower(upperString)       */
/*                                                     */
/* Changes....: 27.12.1996 - XRange used               */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
ToLower: Procedure

/*------------(Lower Case entired string)--------------*/
Parse Arg Upper_String

Lowers = XRange('a', 'z') || ''
Uppers = XRange('A', 'Z') || ''

Return Translate(Upper_String, Lowers, Uppers)
