/* REXX **********************************************/
/*                                                   */
/* Name.......: QSort.CMD                            */
/* Function...: Test Rexx algorithms for the Quick   */
/*              sort                                 */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _items

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( QUICK SORT )", 80, '*')

/*--------------(Set random numbers)-------------*/
Call RandomStem _items

/*------------------(Quick Sort)-----------------*/
Say
Say "Following values will be sorted:"
Say
Say SayStem()
Say
Say "Test Quick Sort."
start = Time(r)

Call QSort

endTime = Time(r)
Say "Quick Sort duration for" stem.0 "digits:" endTime "sec."
Say 
Call LineOut , "Press any key to continue "
Call LineIn

/* Following 3 statements can be comment out */
Say "Following values have been sorted:"
Say SayStem()
Say

Say "Quick Sort duration for" stem.0 "digits:" endTime "sec."
Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)===============*/

/*====================(Quick sort)====================*/
/* :-D                                              4 */
/* Name.......: QSort                                 */
/*                                                    */
/* Function...: Quick Sort for a stem variable        */
/* Call parm..: No                                    */
/* Returns....: Left-Right span                       */
/*                                                    */
/* Sample call: Call QSort                            */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
QSort: Procedure Expose stem.

Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left


/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 50)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If DataType(number) \= 'NUM' Then number = 50
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
End

Return ''


/*===============( Say stem as one line )============*/
/*                                                   */
/* Name.......: SayStem                              */
/*                                                   */
/* Function...: Says stem as one line with delimiter */
/*                                                   */
/* Call parm..: Delimiter character(s) (default: ',')*/
/*              Prefix for return value (dflt. : '') */
/*                                                   */
/* Returns....: Line with all stems                  */
/*                                                   */
/* Syntax.....: stemLine = SayStem [delim][, prefix] */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
SayStem: Procedure Expose stem.

Parse Arg _delim, _stemLine

If _delim = '' Then _delim = ','

If stem.0 > 0 Then _stemLine = stem.1

Do i = 2 To stem.0
  _stemLine = _stemLine || _delim || stem.i
End /* End Do ... */

Return _stemLine