/* REXX **********************************************/
/*                                                   */
/* Name.......: NoMult.CMD                           */
/* Function...: Test Rexx algorithms for Exclude     */
/*              multiple items from a stem.          */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _items

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( EXCLUDE MULTIPLE ITEMS )", 80, '*')

/*--------( Test Exclude duplicate items )-------*/
Drop stem.

stem.1 = 2
stem.2 = 3
stem.3 = 3
stem.4 = 3
stem.5 = 6
stem.6 = 6
stem.7 = 6
stem.8 = 6
stem.9 = 7
stem.10= 8
stem.11= 8
stem.12= 8
stem.13= 8
stem.14= 9
stem.15= 9
stem.0 = 15

Say 
Say 'Test Exclude multiple items'
Say
Say 'Before:'
Say SayStem()
Say 

Call NoMult

stem.0 = Queued()
Do i = 1 To stem.0
  Pull stem.i
End
Say 'After:'
Say SayStem()

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit



/*===============(Internal subroutines)===============*/

/*=============( Exclude multiple items )=============*/
/*                                                 11 */
/* Name.......: NoMult                                */
/*                                                    */
/* Function...: Excludes multiple lines from a sorted */
/*              file                                  */
/* Call parm..: Nothing                               */
/* Returns....: Nothing (0). The result will be placed*/
/*              on the stack!                         */
/*                                                    */
/* Syntax.....: Call NoMult / y = NoMult()            */
/*                                                    */
/* Notes......: The elements to exclude must be       */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem variable must be previously  */
/*              sorted                                */
/*              The result will be placed on the      */
/*              stack!                                */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* (C) Copyright Janosch R. Kowalczyk, 1996.          */
/* All rights reserved.                               */
/*====================================================*/
NoMult: Procedure Expose stem.

Do i = 1 To stem.0
  Queue stem.i
  Do j = i + 1 while stem.i = stem.j
  End
  i = j - 1
End

Return 0


/*===============( Say stem as one line )============*/
/*                                                   */
/* Name.......: SayStem                              */
/*                                                   */
/* Function...: Says stem as one line with delimiter */
/*                                                   */
/* Call parm..: Delimiter character(s) (default: ',')*/
/*              Prefix for return value (dflt. : '') */
/*                                                   */
/* Returns....: Line with all stems                  */
/*                                                   */
/* Syntax.....: stemLine = SayStem [delim][, prefix] */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
SayStem: Procedure Expose stem.

Parse Arg _delim, _stemLine

If _delim = '' Then _delim = ','

If stem.0 > 0 Then _stemLine = stem.1

Do i = 2 To stem.0
  _stemLine = _stemLine || _delim || stem.i
End /* End Do ... */

Return _stemLine