/* REXX **********************************************/
/*                                                   */
/* Program name: J2G                                 */
/* Function    : translates julian date to gregorian */
/*               date                                */
/* Syntax      : gDat = J2G(yyyy.ddd)                */
/* Changes     :                                     */
/* Author      : Janosch R. Kowalczyk                */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/* Made use of GREED.  09 Jul 1996 / 18:08:30   JRK  */
/*****************************************************/
Parse Arg julDate

If julDate = '' Then julDate = 1983.267

/*-------------(Exceptions handling)--------------*/
Signal On Failure Name BEENDEN
Signal On Halt    Name BEENDEN
Signal On Syntax  Name BEENDEN

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

If julDate > '' Then Do
  Say
  text = 'Test J2G (translate Julian date to Gregorian date):'
  Say Center( "(" text ")", 80, '*')
  julDate = TestDate(julDate)
  Say julDate '--->' J2G(julDate)
  Say '1900.001 --->' J2G('1900.001')
  Say '1900.059 --->' J2G('1900.059')
  Say '1900.060 --->' J2G('1900.060')
  Say '1900.061 --->' J2G('1900.061')
  Say '1900.365 --->' J2G('1900.365')
  Say '1996.001 --->' J2G('1996.001')
  Say '1996.059 --->' J2G('1996.059')
  Say '1996.060 --->' J2G('1996.060')
  Say '1996.061 --->' J2G('1996.061')
  Say '1996.365 --->' J2G('1996.365')
  Say '2000.001 --->' J2G('2000.001')
  Say '2000.059 --->' J2G('2000.059')
  Say '2000.060 --->' J2G('2000.060')
  Say '2000.061 --->' J2G('2000.061')
  Say '2000.365 --->' J2G('2000.365')
  Say
End
Else
  Call HelpText

/*-------------------(End program)------------------*/
Call CharOut , "Press any key to exit "
Call LineIn

Exit

BEENDEN:
Say 'GREED001E - Break, Failure or Syntax Error'
Exit


HelpText: Procedure

Say 'Syntax:'
Say
Say 'J2G julian_date'
Say
Say 'julian_date has format: yyyy.ddd (0 < ddd < 367)'

Return


/*===============(Test plausibilty)================*/
TestDate: Procedure
Arg julDate

Parse Var julDate year '.' jday
If jday = '' Then Do
  jday = year
  Parse Value Date() With . . year .
End
If jday < 0 ! jday > 366 Then Do
  Call HelpText
  Exit
End
If Length(year) = 2 Then year = '19' || year

Return year || '.' || jday


/*==========(Julian Date to Gregorian Date)==========*/
J2G: Procedure
/*---------------------------------------------------*/
/*                                                   */
/* Program name: J2G                                 */
/* Function    : translates julian to gregorian      */
/*               date                                */
/* Syntax      : J2G yyyy.ddd                        */
/* Author      : Janosch R. Kowalczyk                */
/* Changes     :                                     */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/* Made use of GREED.  09 Jul 1996 / 18:08:30   JRK  */
/*---------------------------------------------------*/
Arg julDate

Parse Var julDate year'.'jday

mon.0  = 12
mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If year // 400 = 0 | (year // 100 > 0 & year // 4 = 0) Then
  leap = 1
Else
  leap = 0

Do i = 1 To mon.0 
  If i > 2 Then mon.i = mon.i + leap
  If jday > mon.i Then mon = i
End

day = jday - mon.mon
gregDate = year'.'Right(mon,2,'0')'.'Right(day,2,'0')

return gregDate
