// DEFAULT mvar TO value, mvar2 to value2, ...
// -------------------------------------------

   #command DEFAULT <p> TO <v> [,<pn> TO <vn>]  ;
            =>                                  ;
           <p> := iif(<p> == NIL, <v>, <p>)       ;
           [;<pn> := iif(<pn> == NIL, <vn>, <pn>)]

// Absolute screen coordinate system (ABS = row + (col * maxcol()))
// ----------------------------------------------------------------
   #xtranslate absolute(<r>, <c>) => (((<r>) * maxcol()) + (<c>))
   #xtranslate abs2r(<p>)         => int((<p>) / maxcol())
   #xtranslate abs2c(<p>)         => int((<p>) % maxcol())

// ===========================================================================
// DIALOGS
// ===========================================================================

// Each dialog definition has at least a colour definition (xxxxC)
// and a window border (xxxxB):

// Group box definitions:
// ----------------------
   #define B_BLOCK     " "
   #define B_SINGLE    "Ŀ "
   #define GROUPC   "w+/b,n/rg*,w+/b,b/b,w+/b"
   #define GROUPB   B_BLOCK

// Input box definitions:
// ----------------------
   #define INPUTC   "rg+/n*,rg+/b,bg+/n*,n/n*,n+/b"
   #define INPUTB   B_SINGLE
   #define INPUTS   "rg+/n*"
   #define INPUTG   "rg+/b"

// TBrowse box definitions:
// ------------------------
                 // Say---SaySel-Del-Delsel-Unsel-Frozen-DelFrozen
   #define BROWC      "rg+/b,n/rg*,n/b,n+/w,b+/w,w+/b,n+/b"
   #define BROWB      B_SINGLE
   #define BROWTXTC   "n/bg,b/w"    // Text browser
   #define BROWTXTB   B_DS
   #define NORMHS    ""          // Header
   #define NORMCS    "  "          // Column
   #define NORMFS    ""          // Footer
   #define BROWSW    3              // Width of column separators

// Picklist definitions
// --------------------
   #define PICKC   "rg+/b"
   #define PICKB   B_DS
   #define LFTCHR  ""              // Split box left side
   #define RGTCHR  ""              // Split box right side
   #define SEPCHR  ""              // Split box row
   #define TOPCHR  ""              // Split box top side
   #define BOTCHR  ""              // Split box bottom side
   #define COLCHR  ""              // Split box column
   #define MIDCHR  "Ĵ"            // Split box cross
   #define SCRBAR  ""              // Generic scroll bar
   #define VSCRB   ""              // Vertical scroll bar
   #define HSCRB   ""              // Horizontal scroll bar
   #define BARC   "w+/b"            // Scroll bar colour
   #define ARRC   "b+/w*"           // Scroll bar icon colour
   #define TAGCHR  chr(7)           // Tag character
   #define SUP  chr(24)             // Up arrow icon
   #define SDN  chr(25)             // Down arrow icon
   #define SLT  chr(26)             // Left arrow icon
   #define SRT  chr(27)             // Right arrow icon
   #define ARROWS SLT+SRT+SUP+SDN   // Icon set

   #define MNU_IDX    1
   #define MNU_ARR    2
   #define MNU_LEN    3
   #define MNU_TAG    4

// ALERT dialogs
// -------------
   #define ERRC         "w+/r,r+/w,w+/r,r/r,w+/r"
   #define ERRB         B_BLOCK
   #define TELC         "w+/g,g+/w,w+/g,g/g,w+/g"
   #define TELB         B_BLOCK
   #define ASKC         "w+/b,b+/w,w+/b,b/b,w+/b"
   #define ASKB         B_BLOCK
   #define BUT_OK       "OK"
   #define BUT_CANCEL   "CANCEL"
   #define BUT_YES      "YES"
   #define BUT_NO       "NO"
   #define BUT_RETRY    "RETRY"
   #define BUT_DEFAULT  "DEFAULT"
   #define BUT_SAVE     "SAVE"
   #define BUT_EDIT     "EDIT"
   #define BUT_DELETE   "DELETE"
   #define BUT_HORIZONTAL   .t.      // Button orientation
   #define BUT_VERTICAL     .f.
   #define BUT_SAY          .f.      // Display buttons
   #define BUT_GET          .t.      // Activate previously displayed

   #define OKCANCEL     {BUT_OK, BUT_CANCEL}
   #define YESNO        {BUT_YES, BUT_NO}
   #define RETRYCANCEL  {BUT_RETRY, BUT_CANCEL}
   #define SAVEEDITCAN  {BUT_SAVE,BUT_EDIT,BUT_CANCEL}

   #xtranslate aptErr(<msg>  [,<act>]) => aptalert(<msg>, <act>, ERRC, ERRB)
   #xtranslate aptTell(<msg> [,<act>]) => aptalert(<msg>, <act>, TELC, TELB)
   #xtranslate aptAsk(<msg>  [,<act>]) => aptalert(<msg>, <act>, ASKC, ASKB)

// ===========================================================================
// TBROWSE extensions
// ===========================================================================

#define TB_CARGO_DIM 31
   #define TB_METHODS   01  // Array of method code blocks
      #define MT_KEY     1  // Methods array inkey number
      #define MT_BLOCK   2  // Methods array code block
   #define TB_DBF       02  // DBF file name or data source
   #define TB_NTX       03  // Index order number
   #define TB_LEDIT     04  // ALLOW/disallow Lotus-like editing
   #define TB_DICT      05  // Clone of data-dictionary for this DBF
   #define TB_STARTAT   06  // Record to start at (0 == bof())
   #define TB_MAXROW    07  // Video mode (25 = CGA, 50 = VGA)
   #define TB_BOTTOM    08  // Block to work out bottom row of browse
   #define TB_SGWIDTH   09  // Width of the scrolling get list box
   #define TB_SGSAYLEN  10  // Width of the SAY part of the scrolling get list
   #define TB_WIDTH     11  // Width of the visible tbrowse
   #define TB_REDRAW    12  // Browse is redrawn if .t.
   #define TB_REOPEN    13  // File/index is reopened if .t.
   #define TB_GETLIST   14  // Getlist array
   #define TB_MSG1      15  // Message line 1
   #define TB_MSG2      16  // Message line 2
   #define TB_QUIT      17  // .t. causes keyhandler to quit
   #define TB_PICK      18  // .t. indicates a pick-list browse
   #define TB_GRAY      19  // .t. causes background to be grayed out
   #define TB_SHADOW    20  // .t. causes a shadow to be drawn around box
   #define TB_BCKGND    21  // Code block to draw background (aptBackPlane())
   #define TB_BOX       22  // Box characters
   #define TB_INIT      23  // Init code block
   #define TB_EXIT      24  // Exit code block
   #define TB_STABIL    25  // Stabilization code block
   #define TB_MSG1A     26  // Arrays of coordinates and inkey codes for
   #define TB_MSG2A     27  //  function keys on message lines.
   #define TB_PREVAL    28  // Full screen edit prevalidate block
   #define TB_POSVAL    29  // Full screen edit postvalidate block
   #define TB_DEFREP    30  // List option report name (if NIL, generic used)
   #define TB_POS       31  // Data row index

#define TBC_CARGO_SIZE 3
   #define NUMBER       1   // Column number
   #define READER       2   // Get reader for this column
   #define FROZEN       3   // .t. if column is currently frozen
