#define MAIN
#define CFILES 
#include "recomsrv.h"
#include <dos.h>

#define WM_NB_RESPONSE WM_USER +2000 

#define WM_DEBUG WM_USER + 101
BOOL IN_DEBUG = FALSE;

BOOL FAR __cdecl  SRV_DEBUG( UINT DebugNr, char huge *szFormat, ...)
{
	static char szBuffer[200];
	HWND hDebug;
	LPSTR pArgs;

	hDebug = FindWindow("HKR_DEBUG_WND", NULL);
	if(hDebug == (HWND)NULL)
	{
		return FALSE;
	}
	if(IN_DEBUG == TRUE) return FALSE;
	IN_DEBUG = TRUE;

	pArgs = (LPSTR)&szFormat + sizeof(szFormat);
	wvsprintf( szBuffer, szFormat, pArgs );
	SendMessage(hDebug, WM_DEBUG, DebugNr, (LPARAM)(LPSTR)szBuffer);

	IN_DEBUG = FALSE;
	return TRUE;
}

unsigned long tick, tack;  

char cmd[][10] = {  "CONNECT",
					"INICOM",
					"SETCOM",
					"SETQUE",
					"RECCOM",
					"SNDCOM",
					"CTX",
					"TRMCOM",
					"STACOM",
					"CEXTFCN", 
					"CFLUSH",
					"CEVT",
					"CEVTGET",
					"CSETBRK",
					"CCLRBRK",
					"GETDCB",
					"CWSTRING",
					"CRSTRING",
					"ENABLENOT", 
					"GETMASK", 
					"UNKWON" };
					
#define SC (sizeof(comData) - sizeof(comData.a) +1)			
					
int cmdsize[] = {   SC,    // CONNECT
					SC,    // INICOM
					SC,    // SETCOM
					SC,    // SETQUE
					SC + sizeof(comData.a.x), // RECCOM
					SC,   // SNDCOM
					SC,   // CTX
					SC,   // TRMCOM
					SC + sizeof(comData.a.cs), // STACOM
					SC,   // CEXTFCN
					SC,   // CFLUSH
					SC,	  // CEVT
					SC,   // CEVTGET
					SC,   // CSETBRK
					SC,   // CCLRBRK
					SC + sizeof(comData.a.dcb), // GETDCB
					SC,	  // CWSTRING
					SC,   // CRSTRING ndert sich
					SC,   // ENABLENOTI
					SC,   // GETMASK
					SC };
					
typedef struct {
	BYTE cLSN;
	BYTE cNum;
	BYTE cGroupNum;
	char szName[17];
	char szCaller[17];
	char hostname[30];
	char hostini[144];
	BYTE Adapter;    
	
} DATA, FAR * LPDATA;

DATA srvData;
					

BOOL FAR PASCAL AboutDlgProc(HWND hDlg, WORD message,
WORD wParam, LONG lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:  
		return TRUE; 
		
	case WM_COMMAND:
		switch(wParam)
		{	
			
		case IDCANCEL:  	
		case IDOK:     
			EndDialog(hDlg, wParam);
			return TRUE;
		}
		break;
	}
	return FALSE;
}       
#pragma optimize( "", off)

void getNetBiosName(LPSTR name)
{                 
	register x, y;
	            
	extern void FAR PASCAL DOS3Call();

	x = _FP_SEG(name);
	__asm mov ds, x;
	y = _FP_OFF(name);
	__asm mov dx, y;
	__asm mov ah, 0x5e ;
	__asm mov al, 0x00 ;
	
	DOS3Call();
}

#pragma optimize( "", on)	

TelHangUp()
{   
	long tick;
	
	if(CONECTED == TRUE) 
	{	
		tick = GetTickCount();
		FlushComm(com, 0);
		FlushComm(com, 1);
		
		WriteComm(com, "+++\x0d\x0aATH\x0d\0aATZ\x0d\x0a       ", 15);
		FlushComm(com, 0);
		FlushComm(com, 1);
		EscapeCommFunction(com, CLRDTR);
		
		while((tick - GetTickCount()) < 500) // 50 msec -> Modem legt auf
		{
			handleMessage();
		}
	}
}
handleMessage()
{
	MSG msg;
	
	while(PeekMessage(&msg, HwnD, 0, 0, PM_REMOVE))
	{
		if(msg.message == WM_QUIT) return FALSE;
		
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}   
	return TRUE;
}	
	
long FAR PASCAL WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{	
	FARPROC lpfnDlgProc;
	
	int rc; 
	char tmp[30];
	char * c1;
	
	switch(msg)
	{
	case WM_NB_RESPONSE:
		lpNCB = (LPNCB) lParam;
		
		if(lpNCB->cCmdCplt)
		{
			// SRV_DEBUG(DB_ACTION, "SERVER: NB_RESPONSE (0x%x)", lpNCB->cCmdCplt);
			DestroyNCB(lpNCB);
			KillTimer(hwnd, 1);
			new_init();
			return 0;
		}
		switch(lpNCB->cCommand & ~NO_WAIT)
		{
			case NETBIOS_LISTEN:
				srvData.cLSN = lpNCB->cLSN;
				_fmemcpy(srvData.szCaller, lpNCB->cCallName, MAX_NAME_SIZE);
				srvData.szCaller[MAX_NAME_SIZE] = '\0';
				
				if(sendAnswer() == FALSE)
				{
					new_init();
				}
				CONECTED = TRUE;				
					
				SetWindowText(hwnd, srvData.szCaller);
				
				KillTimer(hwnd, 1);
				SetTimer(hwnd, 1, 300, NULL);
									
				tick = GetTickCount();
				ShowWindow(hwnd, SW_SHOWMINIMIZED);
				                             
				// SRV_DEBUG(DB_ACTION, "SERVER: WAIT FOR CMD'S");				                             
				                             
				// rc =  PostReceiveDatagram(srvData.Adapter, srvData.cNum, 
				// 	(LPSTR)&comData, sizeof(comData), hwnd, WM_NB_RESPONSE, 0, &lpNCB);
				 	
				rc = PostReceive(srvData.Adapter, srvData.cLSN, 
				 	(LPSTR)&comData, sizeof(comData), hwnd, WM_NB_RESPONSE, 0, &lpNCB);
				 	
				if(rc != 0)
				{
					// SRV_DEBUG(DB_ACTION, "SERVER: LISTEN (0x%x)", rc);
				}	
				break;                     
				
			case NETBIOS_RECEIVE_BROADCAST:
			
				// SRV_DEBUG(DB_ACTION, "SERVER: I'M HERE");
				
				fndSrv.stat = CONECTED;
				wsprintf(fndSrv.name, "%s\t%s", 
					(LPSTR)srvData.szName, (LPSTR)srvData.hostname);
				
					
				rc = SendDatagram(WAIT_WND_MODAL, srvData.Adapter, srvData.cGroupNum, 
					lpNCB->cCallName,(LPSTR)&fndSrv, sizeof(fndSrv), HwnD);
				
				DestroyNCB(lpNCB);
				
				if(rc != 0)
				{
					// SRV_DEBUG(DB_ACTION, "SERVER: BROADCAST (0x%x)", rc);
				}				
					
				rc = PostReceiveBroadcast(srvData.Adapter, srvData.cGroupNum, 
				  	(LPSTR)&fndSrv, sizeof(fndSrv), HwnD, WM_NB_RESPONSE, 1, &brdNCB);

				if(rc != 0)
				{
					// SRV_DEBUG(DB_ACTION, "SERVER: ANSWER BROADCAST (0x%x)", rc);
				}				
				// SRV_DEBUG(DB_ACTION, "SERVER: WAIT");
				return 0;						
		
			
			// case NETBIOS_RECEIVE_DATAGRAM:
			case NETBIOS_RECEIVE:
				tick = GetTickCount();
				
				// SRV_DEBUG(DB_ACTION, "SERVER: CMD %d=%s ev=%d",comData.fnc, (LPSTR)cmd[comData.fnc], *lpevent);
		
			    DestroyNCB(lpNCB);
		
			    analizeMessage();
			    
			    // and wait again
			    
				// rc = PostReceiveDatagram(srvData.Adapter, srvData.cNum, 
				//  	(LPSTR)&comData, sizeof(comData), hwnd, WM_NB_RESPONSE, 0, &lpNCB);
				
				rc = PostReceive(srvData.Adapter, srvData.cLSN, 
				 	(LPSTR)&comData, sizeof(comData), hwnd, WM_NB_RESPONSE, 0, &lpNCB);
					
				// SRV_DEBUG(DB_ACTION, "SERVER: CMD DONE ev=%d", *lpevent);
				if(rc != 0)
				{
					// SRV_DEBUG(DB_ACTION, "SERVER: RECEIVE (0x%x)", rc);
				}				
				return 0;
		}
		DestroyNCB(lpNCB);
		return 0;
		
	case WM_QUERYENDSESSION:
		return 1;
		
	case WM_ENDSESSION:
		CancelAllPending(hwnd);
		DeleteName(WAIT_WND_MODAL, APPNAME, srvData.Adapter, hwnd);
		DeleteName(WAIT_WND_MODAL, srvData.szName, srvData.Adapter, hwnd);
		return 1;
			
	case WM_CREATE:
		hInstance = ((LPCREATESTRUCT) lParam)->hInstance;  

		HwnD = hwnd;          
		REMOTE_COM = 2;
		lpevent = &event[0];
		event[0] = evcnt = 0;
		
		CONECTED = FALSE;
		srvData.Adapter = 0;
		getNetBiosName(tmp);
		wsprintf(srvData.szName, "RS_%12s", (LPSTR)tmp);
		c1 = (srvData.szName + sizeof(srvData.szName) -1);
		while(*c1 == ' ') *c1-- = '\0';
		srvData.szName[sizeof(srvData.szName)] = '\0';
		
		rc = AddGroupName(WAIT_WND_MODAL, APPNAME, srvData.Adapter, hwnd, &srvData.cGroupNum);
		
		rc = AddName(WAIT_WND_MODAL, srvData.szName, srvData.Adapter, hwnd, &srvData.cNum);
		
		if(rc != 0)
		{
			DeleteName(WAIT_WND_MODAL, srvData.szName, srvData.Adapter, hwnd);
			rc = AddName(WAIT_WND_MODAL, srvData.szName, srvData.Adapter, hwnd, &srvData.cNum);
		}
		if(rc != 0)
		{
			MessageBox(NULL, 
				"ACHTUNG: Der Server konnte nicht initialisiert werden \n"
				"Remotezugriffe sind nicht mglich"
				, APPTITLE, 	MB_OK|MB_ICONHAND);
				
			return -1;
		}			
		new_init();
		return TRUE;
		
	case WM_SYSCOMMAND:
		if( (wParam == SC_MAXIMIZE)
		||  (wParam == SC_RESTORE))
		{
			return 0;      
		}
		break;
		        
	case WM_TIMER:
		tack = GetTickCount();
		if((tack - tick) > 360000)
		{                     
			tick = GetTickCount();
			// SRV_DEBUG(DB_ACTION, "SERVER: CLIENT TIME OUT!");	
			
			TelHangUp();
			new_init();
		}
		return 0;	
				
	case WM_COMMNOTIFY:
		event[evcnt] = LOWORD(lParam);
		// SRV_DEBUG(DB_ACTION, "SERVER: WM_COMMNOTIFY %d", event[evcnt]);	
		if(++evcnt > 20) evcnt = 20;
		return TRUE;
				
		
	case WM_CLOSE: 
		TelHangUp();           
		
		DestroyWindow(hwnd);
		return 0;
		
	case WM_DESTROY:           
		CancelAllPending(hwnd);
		DeleteName(WAIT_WND_MODAL, APPNAME, srvData.Adapter, hwnd);
		DeleteName(WAIT_WND_MODAL, srvData.szName, srvData.Adapter, hwnd);
		CancelAllPending(hwnd);
		
		// SRV_DEBUG(DB_ACTION, "SERVER: EXIT");
        PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}   
analizeMessage()
{	
	int x;
	
	switch(comData.fnc)
	{
		case SETQUE:
			setque();
			if(sendAnswer() == FALSE)
			{
				new_init();
			}	
			return TRUE;
			
		case INICOM:
			inicom();
			break;
			
		case SETCOM:    
			setcom();
			break;
			
		case RECCOM:
			reccom();
			break;
			
		case SNDCOM:
			sndcom();
			break;
			
		case CTX:
			ctx();
			break;
			
		case TRMCOM:
			trmcom();
			CancelAllPending(HwnD);    
			new_init();
			return TRUE;
			
		case STACOM:
			stacom();
			break;   
			
		case CEXTFCN:
			cextfcn();
			break;
			
		case CFLUSH:
			cflush();
			break;
			
		case CEVT:
			cevt();
			break;
			
		case CEVTGET:
			cevtget();
			break;
			
		case CSETBRK:
			csetbrk();
			break;
			
		case CCLRBRK:
			cclrbrk();
			break;
			
		case GETDCB:
			getdcb();
			break;
			
		case CWSTRING:
			cwstring();
			break;
			
		case CRSTRING:
			crstring();
			cmdsize[comData.fnc] = SC + comData.len;
			break;
			
		case ENABLENOTI:
			enablenoti();
			break;     
		case GETMASK:
			break;
	}
	if(lpevent != NULL)                  
	{
		comData.evmask = *lpevent;  
		if(evcnt != 0)
		{
			for(x = 1; x < 20; x++)
			{
				event[x-1] = event[x];
			}
			evcnt--;
		}
	}else
	{
		comData.evmask = EV_ERR;
	}
	if(sendAnswer() == FALSE)
	{
		new_init();
	}
}	
sendAnswer()
{
	int rc;
	
	tick = GetTickCount();
	
	// rc = SendDatagram(WAIT_WND_MODAL, srvData.Adapter, srvData.cNum, srvData.szCaller, 
	//  		(LPSTR)&comData, cmdsize[comData.fnc], HwnD);
			
	rc = Send(WAIT_WND_MODAL, srvData.Adapter, srvData.cLSN, 
	  		(LPSTR)&comData, cmdsize[comData.fnc], HwnD);
	
	if(rc != 0)
	{
		// SRV_DEBUG(DB_ACTION, "SERVER: NET_ERROR (0x%x)", rc);		
		return FALSE;
	}
	return TRUE;
}


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
LPSTR lpszCmdLine, int nCmdShow)
{
	
	HWND	hwnd;
	MSG	msg;
	WNDCLASS wndclass;
	WNDCLASS gwndclass;
	
	lstrcpy(szAppName, APPNAME);
	
	if(!hPrevInstance)
	{
		wndclass.style = CS_HREDRAW |CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon(hInstance, "recomsrvico");
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName = "recomsrv_SYSMENU";
		wndclass.lpszClassName = szAppName;
		
		RegisterClass(&wndclass);
	}
	hwnd = CreateWindow(szAppName, APPTITLE,
		WS_OVERLAPPEDWINDOW, 0, 0, 30, 100, NULL, NULL, hInstance, NULL);
	
	ShowWindow(hwnd, SW_SHOWMINIMIZED);
	UpdateWindow(hwnd);
	
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

	
	

static int initReceive()
{
	// SRV_DEBUG(DB_ACTION, "SERVER: PUBLISH HOST NAME");
	
	getNetBiosName(srvData.hostname);
						     
	if(lstrlen(srvData.hostname) == 0)
	{   
		// SRV_DEBUG(DB_ACTION, "SERVER: PUBLISH HOST NAME (NO NBNAME)");
		return FALSE;
	}           
	return TRUE;
}
new_init()
{                    
	int rc;
	
	// SRV_DEBUG(DB_ACTION, "SERVER: INIT");
	
	lpevent = &event[0];
	evcnt = event[0] = 0;
	
	SetWindowText(HwnD, APPTITLE);
		        
	if(CONECTED == TRUE) 
	{	
		CONECTED = FALSE;
			
		tick = GetTickCount();
		FlushComm(com, 0);
		FlushComm(com, 1);
		
		WriteComm(com, "+++\x0d\x0aATH\x0d\0aATZ\x0d\x0a       ", 15);
		FlushComm(com, 0);
		EscapeCommFunction(com, CLRDTR);
		
		while((tick - GetTickCount()) < 500); // 50 msec -> Modem legt auf
		
		CloseComm(com);            
		
		CancelAllPending(HwnD);
		HangUp(WAIT_WND_MODAL, srvData.Adapter, srvData.cLSN, HwnD);
		
		// SRV_DEBUG(DB_ACTION, "SERVER: DISCONECTED");
	}                       
	
	if(initReceive() == FALSE) return FALSE;
	
	CONECTED = FALSE;                     
	
	rc = PostReceiveBroadcast(srvData.Adapter, srvData.cGroupNum, 
		  	(LPSTR)&fndSrv, sizeof(fndSrv), HwnD, WM_NB_RESPONSE, 1, &brdNCB);
	
	rc = PostListen(srvData.szName, "*", srvData.Adapter, 0, 60, 
		HwnD,  WM_NB_RESPONSE, 0, &lpNCB);
	
	if(rc != 0)
	{
		// SRV_DEBUG(DB_ACTION, "SERVER: ERROR LISTEN (0x%x)", rc);		
		return FALSE;
	}
	
	ShowWindow(HwnD, SW_HIDE);
	
	// SRV_DEBUG(DB_ACTION, "SERVER: NET_LISTEN");
	
	return TRUE;
}
