/*****************************************************************************
   MODULE: rcputs.c
  PURPOSE: recio column delimited string and char output functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.15
  RELEASE: October 26, 1996
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

#define rcol(rp)         ((rp)->r_colno)
#define rfp(rp)          ((rp)->r_fp)
#define rflags(rp)       ((rp)->r_flags)
#define rfldch(rp)       ((rp)->r_fldch)
#define rtxtch(rp)       ((rp)->r_txtch)
#define rflags(rp)       ((rp)->r_flags)

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

/****************************************************************************/
void                         /* returns nothing                             */
    rcputc(                  /* put character to record stream              */
        REC   *rp,           /* record pointer                              */
        size_t col,          /* column position                             */
        int    ch)           /* character to put to record stream           */
/****************************************************************************/
{
    if (_risready(rp, R_WRITE)) {
        if (col >= rcolno(rp)) {
            rfldno(rp)++;
            rflags(rp) &= ~_R_TXT;
            
            /* if colno < col, pad with spaces */
            while (rcolno(rp) < col) {
                if (_rputc(rp, ' ')) goto done;
            }
            
            /* put character */
            _rputc(rp, ch);
        } else {
            rseterr(rp, R_EINVAL); \
        }
    }
done:
    return;
}

/****************************************************************************/
void                         /* returns nothing                             */
    rcputs(                  /* put string to record stream                 */
        REC  *rp,            /* record pointer                              */
        size_t begcol,       /* beginning column                            */
        size_t endcol,       /* ending column                               */
  const char *str)           /* pointer to string                           */
/****************************************************************************/
/* note: assumes str does not contain a newline character */
{
    size_t len;               /* string length */

    if (_risready(rp, R_WRITE)) {
        if (endcol >= begcol && begcol >= rcolno(rp)) {
            rfldno(rp)++;
            rflags(rp) &= ~_R_TXT;

            /* if colno < begcol, pad with spaces */
            while (rcolno(rp) < begcol) {
                if (_rputc(rp, ' ')) goto done;
            }

            len = strlen(str);

            /* if str fits within the space, output it */
            if (len <= (endcol-begcol+1)) {
                if (fputs(str, rfp(rp)) != EOF) { 
                    rcol(rp) += len;
                    /* pad remainder of space */
                    while (rcolno(rp) <= endcol) {
                        if (_rputc(rp, ' ')) goto done;
                    }
                } else {
                    rseterr(rp, R_ENOPUT);
                }
            /* else put as much of the string as possible */
            } else {
                rsetwarn(rp, R_WWIDTH);
                while (rcolno(rp) <= endcol) {
                    if (_rputc(rp, *str++)) goto done;
                }
            }
        } else {
            rseterr(rp, R_EINVAL); \
        }
    }
done:
}
