/*****************************************************************************
   MODULE: rwarn.c
  PURPOSE: recio warning functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.14
  RELEASE: June 14, 1996
*****************************************************************************/

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern void _rsetexitfn(REC *rp);

#define rflags(rp)       ((rp)->r_flags)

static void (*_r_warnfn)(REC *) = NULL; /* ptr to warning function */

/****************************************************************************/
void                         /* returns nothing                             */
    rclearwarn(              /* clears warning indicator                    */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    if (risvalid(rp)) {
        rflags(rp) &= ~(_R_WRN * _R_WRNMAX);
    } else {
        rseterr(NULL, EINVAL);
    }
}

/****************************************************************************/
void                             /* returns nothing                         */
    rsetwarnfn(                  /* registers a callback warning function   */
        void(*rwarnfn)(REC *rp)) /* pointer to warning function             */
/****************************************************************************/
{
    _r_warnfn = rwarnfn;         /* point to callback warning function */
    _rsetexitfn(recin);          /* register exit function */
}

/****************************************************************************/
int                          /* returns warning number (0=no warning)       */
    rwarning(                /* gets warning number for record stream       */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    int warnum=0;            /* return warning number */

    if (risvalid(rp)) {
         warnum = rflags(rp) / _R_WRN;
         warnum &= _R_WRNMAX;
    }
    return warnum;
}

/****************************************************************************/
int                          /* returns possibly modified warning number    */
    rsetwarn(                /* sets warning number and calls warning fn    */
        REC *rp,             /* record pointer                              */
        int warnum)          /* warning number                              */
/****************************************************************************/
{
    /* if valid record pointer */
    if (risvalid(rp) && warnum <= _R_WRNMAX) {

        /* set warning number on stream */
        rflags(rp) &= ~(_R_WRN * _R_WRNMAX);
        rflags(rp) |= _R_WRN * warnum;

        /* invoke callback warning function */
        if (_r_warnfn) _r_warnfn(rp);

        /* find out if warnfn() changed warning */
        warnum = rwarning(rp);

    } else {
        rseterr(rp, R_EINVAL);
    }
    return warnum;
}

/****************************************************************************/
char *                       /* returns warning message                     */
    rstrwarning(             /* gets warning message for rwarning number    */
        int warnum)          /* warning number                              */
/****************************************************************************/
{
    switch (warnum) {
    case 0:          return ("no warning");
    case R_WEMPSTR:  return ("empty data string");
    case R_WNOREG:   return ("unable to register function with atexit()");
    case R_WWIDTH:   return ("data too wide for columnar output");
    case R_WTMFMT:   return ("time data incomplete");
    }
    return ("unknown warning");
}

/****************************************************************************/
char *                       /* returns warning message                     */
    rwarnstr(                /* gets warning message for record stream      */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    return (risvalid(rp) ? rstrwarning(rwarning(rp)) : rstrerror(R_EINVAL));
}
