/*****************************************************************************
   MODULE: remsg.c
  PURPOSE: recio simple error message functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.13
  RELEASE: September 4, 1995
*****************************************************************************/

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

/****************************************************************************/
static void                  /* returns nothing                             */
     errmsg(                 /* errno callback error message function       */
        void)                /* no arguments                                */
/****************************************************************************/
{
  switch (errno) {

  /* non-fatal errors */
  case EACCES:   /* file access permission denied */
  case EDOM:     /* out of domain */
  case EMFILE:   /* too many files open */
  case ERANGE:   /* out of range */
    fputs("\nERROR -- ", stderr);
    fputs(strerror(errno), stderr);
    fputc('\n', stderr);
    break;

  /* fatal errors */
  case EINVAL:   /* invalid argument */
  case ENOMEM:   /* out of memory    */
  default:       /* unknown error    */
    fputs("\nFATAL ERROR -- ", stderr);
    fputs(strerror(errno), stderr);
    fputc('\n', stderr);
    exit(EXIT_FAILURE);
    break;
  }
}

/****************************************************************************/
void                         /* returns nothing                             */
    rerrmsg(                 /* recio callback error message function       */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
  if (risvalid(rp)) {
  
    rsetfldch(recerr, ' ');
    rsettxtch(recerr, ' ');
  
    /* if reof indicator set */
    if (reof(rp)) {
      rputs(recerr, "\nERROR in");
      rputs(recerr, rnames(rp));
      rputs(recerr, "-- tried to read past end of file\n");
    
    /* else rerror indicator set */
    } else {
 
      /* determine cause of error */
      switch (rerror(rp)) {
 
      /* data errors */
      case R_EDOM:     /* out of domain */
      case R_ERANGE:   /* out of range */
      case R_EINVDAT:  /* invalid data */
      case R_EMISDAT:  /* missing data */
      case R_ENOPUT:   /* unable to write data */
        rputs(recerr, "\nDATA ERROR in");
        rputs(recerr, rnames(rp));
        rputs(recerr, "at record");
        rputul(recerr, rrecno(rp));
        rputs(recerr, "and field");
        rputui(recerr, rfldno(rp));
        rputs(recerr, "--");
        rputs(recerr, rerrstr(rp));
        rputrec(recerr);
        break;
        
      /* fatal errors */
      case R_EINVAL:   /* invalid argument */
      case R_EINVMOD:  /* invalid mode  */
      case R_ENOMEM:   /* out of memory */
      default:         /* unknown error */
        rputs(recerr, "\nFATAL ERROR in");
        rputs(recerr, rnames(rp));
        rputs(recerr, "--");
        rputs(recerr, rerrstr(rp));
        rputrec(recerr);
        exit(EXIT_FAILURE);
        break;
      }
    }
  
  /* invalid record pointer */
  } else {
    errmsg();
  }
}
