/*****************************************************************************
   MODULE: rcputf.c
  PURPOSE: recio column delimited floating point output functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.13
  RELEASE: September 4, 1995
*****************************************************************************/

#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);
extern char *dtoa(double d, char *str, int dig);

#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rflags(rp)       ((rp)->r_flags)

/****************************************************************************/
static void                  /* returns nothing                             */
    _rcputd(                 /* output flt pt number to col delim stream    */
        REC   *rp,           /* pointer to record stream                    */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        int    sigdig,       /* number of significant digits                */
        double num)          /* floating point number to put to stream      */
/****************************************************************************/
{
    size_t sl;               /* length of string _r_nsbuf */
    int dig;                 /* significant digits available */

    if (_risready(rp, R_WRITE)) { 
      if (endcol >= begcol && begcol >= rcolno(rp)) { 
        rfldno(rp)++; 
        rflags(rp) &= ~_R_TXT;

        /* if colno < begcol, pad with spaces */
        while (rcolno(rp) < begcol) { 
          if (_rputc(rp, ' ')) goto done; 
        } 

        /* fit number into space defined by begcol and endcol */
        dig = min(sigdig, (endcol-begcol+1)); 
        while (dig > 0) {
          /* convert number to string */
          dtoa(num, _r_nsbuf, dig); 
          sl = strlen(_r_nsbuf); 
          if (sl <= (endcol-begcol+1)) {
          
            /* right justify string */
            while (rcolno(rp) <= endcol-sl) { 
              if (_rputc(rp, ' ')) goto done; 
            } 
            
            /* output converted string */
            if (fputs(_r_nsbuf, rfp(rp)) != EOF) { 
              rcol(rp) += sl; 
            } else { 
              rseterr(rp, R_ENOPUT); 
            } 
            goto done; 
          } 
          dig -= sl-(endcol-begcol+1); 
        } 

        /* converted string too long for space */
        rsetwarn(rp, R_WWIDTH); 
        while (rcolno(rp) <= endcol) { 
          if (_rputc(rp, '*')) goto done; 
        } 

      } else { 
        rseterr(rp, R_EINVAL); 
      } 
    } 
done:
    return;
}

/****************************************************************************/
/* column delimited floating point output functions                         */
/****************************************************************************/
void rcputf(REC *rp, size_t begcol, size_t endcol, float num)
{
    _rcputd(rp, begcol, endcol, FLT_DIG, (double) num);
}

void rcputd(REC *rp, size_t begcol, size_t endcol, double num)
{
    _rcputd(rp, begcol, endcol, DBL_DIG, num);
}
