/*****************************************************************************
   MODULE: rcgett.c
  PURPOSE: recio column delimited time input functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.12
  RELEASE: January 29, 1995
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

#define rtmfmt(rp) ((rp)->r_tmfmt)
#define rcol(rp) (rp->r_colno)

extern int _rgett_c_warno;
extern void _tminit(struct tm *);

/****************************************************************************/
struct tm                    /* return broken-down time                     */
    rcgettm(                 /* get time from col delim record stream       */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol)       /* field inclusive ending column               */
/****************************************************************************/
{
    struct tm t;             /* return broken-down time */
    struct tm val;           /* conversion value */
    char *fldptr;            /* pointer to field buffer */
    char *fldp;              /* another pointer to field buffer */

    _tminit(&t);
    if (_risready(rp, R_READ)) {
      if (endcol >= begcol && begcol >= rbegcolno(rp)) {
        rcol(rp) = begcol - rbegcolno(rp);
        fldptr = _rfldstr(rp, endcol-begcol+1);
        if (fldptr) {
          for (;;) {
            for (fldp=fldptr; *fldp; fldp++) {if (!isspace(*fldp)) break;}
            if (*fldp) {
              val = sftotm(fldp, rtmfmt(rp));
              if (errno) {
                switch (errno) {
                case ERANGE:
                  fldptr = _rerrs(rp, R_ERANGE);
                  break;
                case EINVAL:
                  fldptr = _rerrs(rp, R_EINVAL);
                  break;
                case EINVDAT:
                  fldptr = _rerrs(rp, R_EINVDAT);
                  break;
                }
                if (fldptr) { continue; } else { goto done; } 
              } else {
                t = val;
                if (_rgett_c_warno) rsetwarn(rp, _rgett_c_warno);
                goto done;
              }
            } /* missing data */ 
            fldptr = _rerrs(rp, R_EMISDAT); 
            if (fldptr) { continue; } else { goto done; } 
          }
        }
      } /* column args reversed or tried to start before first column */
      rseterr(rp, R_EINVAL);
    }
done:
    return t;
}

/****************************************************************************/
time_t                       /* return time (-1=error)                      */
    rcgett(                  /* get time from col delim record stream       */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol)       /* field inclusive ending column               */
/****************************************************************************/
{
    time_t time=(time_t) -1; /* return time (-1 = error) */
    struct tm t;             /* broken-down time */

    t = rcgettm(rp, begcol, endcol);
    if (_risready(rp, R_READ)) {
        time = tmtotime(t);
        if (time == (time_t) -1) rseterr(rp, R_ERANGE);
    }
    return time;
}
