/*****************************************************************************
   MODULE: rcbget.c
  PURPOSE: recio column delimited integral number input functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.12
  RELEASE: January 29, 1995
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);
extern unsigned long str2ul(const char *nptr, char **endptr, int base);

#define rcol(rp) (rp->r_colno)

#define uint      unsigned int
#define ulong     unsigned long
#define UNSIGNED  0
#define SIGNED    1

/****************************************************************************/
static long                  /* return integral number                      */
    _rcbgetl(                /* get integral number from col delim stream   */
        REC *rp,             /* pointer to record stream                    */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        int base,            /* radix of number                             */
        int sign,            /* signed number? (0=unsigned; !0=signed)      */
        long min,            /* inclusive valid min value (0 if unsigned)   */
        long max)            /* inclusive valid max value                   */
/****************************************************************************/
{ 
    long result=0L;          /* result to return */
    long val;                /* conversion value */
    char *fldptr;            /* pointer to field string */
    char *endptr;            /* pointer to first invalid field char */
    char *fldp;              /* another pointer to field string */

    if (_risready(rp, R_READ)) { 
      if (endcol >= begcol && begcol >= rbegcolno(rp)) { 
        rcol(rp) = begcol - rbegcolno(rp); 
        fldptr = _rfldstr(rp, endcol-begcol+1); 
        if (fldptr) { 
          for (;;) { 
            for (fldp=fldptr; *fldp; fldp++) {if (!isspace(*fldp)) break;} 
            if (*fldp) { 
              endptr = fldptr; 
              errno = 0; 
              if (sign) {
                val = strtol(fldptr, &endptr, base); 
              } else {
                val = str2ul(fldptr, &endptr, base); 
              }
              while (isspace(*endptr)) endptr++; 
              if (errno==ERANGE || !*endptr) { 
                if (!errno) { 
                  if (sign) {
                    if (val >= min && val <= max) { 
                      result = val; 
                      goto done; 
                    }
                  } else {
                    /* note: unsigned min always assumed to be zero */
                    if ((ulong) val <= (ulong) max) {
                      result = val; 
                      goto done;
                    }
                  }
                } /* out of range */ 
                fldptr = _rerrs(rp, R_ERANGE); 
                if (fldptr) { continue; } else { goto done; } 
              } /* invalid data */ 
              fldptr = _rerrs(rp, R_EINVDAT); 
              if (fldptr) { continue; } else { goto done; } 
            } /* missing data */ 
            fldptr = _rerrs(rp, R_EMISDAT); 
            if (fldptr) { continue; } else { goto done; } 
          } 
        }
      } /* arguments reversed or tried to start before first column*/ 
      rseterr(rp, R_EINVAL); 
    } 
done: 
    return result; 
}

/****************************************************************************/
/* column delimited integral number input functions                         */
/****************************************************************************/
int rcbgeti(REC *rp, size_t begcol, size_t endcol, int base)
{
    return (int) _rcbgetl(rp, begcol, endcol, base, SIGNED, INT_MIN, INT_MAX);
}

unsigned int rcbgetui(REC *rp, size_t begcol, size_t endcol, int base)
{
    return (uint) _rcbgetl(rp, begcol, endcol, base, UNSIGNED, 0, UINT_MAX);
}

long rcbgetl(REC *rp, size_t begcol, size_t endcol, int base)
{
    return _rcbgetl(rp, begcol, endcol, base, SIGNED, LONG_MIN, LONG_MAX);
}

unsigned long rcbgetul(REC *rp, size_t begcol, size_t endcol, int base)
{
    return (ulong) _rcbgetl(rp, begcol, endcol, base, UNSIGNED, 0L, ULONG_MAX);
}
