/*****************************************************************************
   MODULE: _rcget.h
  PURPOSE: header used to compile library functions
COPYRIGHT: (C) 1994 William Pierpoint
  VERSION: 1.10
  RELEASE: Mar 28, 1994
*****************************************************************************/

#ifndef _RCGET_H
#define _RCGET_H

#include "recio.h"

extern int _rstatus(REC *rp);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

#define rcol(rp) (rp->r_colno)

/* macro for number conversion between two inclusive columns */
#define rcget_fn( /* define function to get number from record */\
    fn_type,      /* defined function return type */\
    fn_name,      /* defined function name */\
    fn_err,       /* defined function error return value */\
    cv_type,      /* conversion function return type */\
    cv_name,      /* conversion function name */\
    fn_min,       /* inclusive valid minimum value */\
    fn_max)       /* inclusive valid maximum value */\
\
fn_type fn_name(        /* return fn_type, return fn_err on error */\
        REC *rp,        /* record pointer */\
        size_t begcol,  /* field inclusive beginning column */\
        size_t endcol)  /* field inclusive ending column */\
{ \
    fn_type result=(fn_err); /* result to return */\
    cv_type val;             /* conversion value */\
    char *fldptr;            /* pointer to field string */\
    char *endptr;            /* pointer to first invalid field char */\
    char *fldp;              /* another pointer to field string */\
\
    if (!_rstatus(rp)) { \
      if (endcol >= begcol && begcol >= rbegcolno(rp)) { \
        rcol(rp) = begcol - rbegcolno(rp); \
        fldptr = _rfldstr(rp, endcol-begcol+1); \
        if (fldptr) { \
          for (;;) { \
            for (fldp=fldptr; *fldp; fldp++) {if (!isspace(*fldp)) break;} \
            if (*fldp) { \
              endptr = fldptr; \
              val = cv_name(fldptr, &endptr); \
              while(isspace(*endptr)) endptr++; \
              if (errno==ERANGE||!*endptr) { \
                if (!errno&&((fn_min)==(fn_max)||(val>=(fn_min)&&val<=(fn_max)))) { \
                  result = (fn_type) val; \
                  goto done; \
                } /* out of range */ \
                fldptr = _rerrs(rp, R_ERANGE); \
                if (fldptr) { continue; } else { goto done; } \
              } /* invalid data */ \
              fldptr = _rerrs(rp, R_EINVDAT); \
              if (fldptr) { continue; } else { goto done; } \
            } /* missing data (empty fldstr) */ \
            fldptr = _rerrs(rp, R_EMISDAT); \
            if (fldptr) { continue; } else { goto done; } \
          } \
        } /* null pointer */ \
      } /* column args reversed or tried to start before first column */ \
      rseterr(rp, R_EINVAL); \
    } \
done: \
    return result; \
}

/* useful macro support */
#define BUILTIN 0  /* indicates that range testing and/or radix
                      is built into the conversion function */
#define uint   unsigned int
#define ulong  unsigned long

#endif
