/*
 *	File:					RecallPrefs.c
 *	Description:	Sets the preferences for the ultimate reminder-utility
 *	Version:			2.0
 *	Author:				Ketil Hunn
 *	Mail:					hunn@dhmolde.no
 *								ketil@lyr.dhmolde.no
 *
 *	Copyright  1993 Ketil Hunn.  Please read the document for further
 *	information and copyrights.
 *
 *	In order to list the source-files included in this package properly,
 *	the TAB size should be set at 2.
 *
 */

#define	every_node	node=list->lh_Head;node->ln_Succ;node=node->ln_Succ
#include <MUI.h>
#include "GetFile().h"

struct EventNode *eventnode=NULL, *oldnode=NULL;
BOOL addtextflag=FALSE;

#include "Prototypes.h"
#include "Version.h"
#include "Escapes.h"
#include "Id.h"
#include "IFFconfig.h"
#include "GUI_Preferences.h"
#include "MUI_lists.h"
#include "AdjustYear().h"

#define LOAD_ASCII							0
#define LOAD_V1X								1
#define LOAD_V20								2

#define SAVE_ASCII							0
#define	SAVE_V20								1

main()
{
	ULONG	id, signals, number;
	BOOL	running	=TRUE, saved=TRUE;
	char	*string;
	char	filename[FNSIZE]=PREFSFILE;

	app=SetupGUI();
	if(aslreq=MUI_AllocAslRequestTags(ASL_FileRequest,TAG_DONE))
	{
		if(Count(eventlist)==0)
			ShowGadgets();
		else
			eventnode=ActivateFirst(eventlist);

		while(running)
		{
			id=DoMethod(app,MUIM_Application_Input,&signals);
			switch(id)
			{
				case ID_SAVE_QUIT:
					WriteIFF(eventlist, PREFSFILE);
					saved=TRUE;
				case MUIV_Application_ReturnID_Quit:
				case ID_CANCEL:
					if(CheckConfirm(saved,"Quit anyway?"))
						running = FALSE;
					break;

				case ID_TEST:
					if(Exists(PROGDIR PROGNAME))
					{
						WriteIFF(eventlist, TESTFILE  );
						Execute(PROGDIR PROGNAME " " TESTFILE ,NULL,NULL);
					}
					else
						MUI_Request(app, window, 0, NULL,
												"*OK", "'" PROGDIR PROGNAME "' not found.");
					break;

				case ID_ABOUT:
					{
						char count[10]="";
						sprintf(count, "%d", Count(eventlist));
						MUI_Request(app, window, 0, NULL, "*OK",
												aCENTRE aLIGHT
												PROGNAME " " VERSION " " COPYRIGHT ".\n"
												"The BEST reminder-utility available.\n\n" aNORMAL aDARK
												"Project contains %s events.\n\n"
												"Placing the pointer over a gadget and pressing\n"
												"HELP will pop up help on that function.\n\n"
												"This program is Public Domain.\n"
												"Compiled on " CURRENT_DAY ", " CURRENT_DATE, count);
					}
					break;

				case ID_ICONIFY:
					set(app,MUIA_Application_Iconified, TRUE);
					break;

				case ID_ACTIVATE_EVENTSTRING:
					addtextflag=FALSE;
					set(eventlist,   MUIA_List_Active, MUIV_List_Active_Off);
					ShowGadgets();
					set(eventstring, MUIA_String_Contents, NULL);
					set(eventstring, MUIA_Disabled, FALSE);
					set(window,      MUIA_Window_ActiveObject, eventstring);
					DoMethod(whenstring, MUIM_SetAsString, MUIA_Text_Contents, "Whenever - Anytime");
					eventnode=NULL;
					break;

				case ID_ADDEVENT:
					saved=FALSE;
					get(eventstring,MUIA_String_Contents, &string);
					if(eventnode==NULL)
					{
						eventnode=AddEvent(eventlist,string,MUIV_List_Insert_Bottom);
						eventnode->hour=-1;
						eventnode->minutes=-1;
						UpdateData(eventnode);
						set(eventlist,	MUIA_List_Active, MUIV_List_Active_Bottom);
					}
					else
					{
						strcpy(eventnode->name,string);
						DoMethod(eventlist, MUIM_List_Redraw, MUIV_List_Redraw_All);
					}
					ShowGadgets();
					break;

				case ID_ACTIVATE_TEXTSTRING:
					set(textlist,		MUIA_List_Active, MUIV_List_Active_Off);
					set(textstring, MUIA_String_Contents, "");
					set(textstring, MUIA_Disabled, FALSE);
					set(window,			MUIA_Window_ActiveObject, textstring);
					if(eventnode->type==EXECUTE)
						set(getfile, MUIA_Disabled, FALSE);
					addtextflag=TRUE;
					break;

				case ID_ADDTEXT:
					get(textstring,MUIA_String_Contents, &string);
					if(Active(textlist)==-1)
					{
						DoMethod(textlist, MUIM_List_Insert, &string, 1, MUIV_List_Insert_Bottom);
						AddText(eventnode->textlist, string, MUIV_List_Insert_Bottom);
						set(textlist,	MUIA_List_Active, MUIV_List_Active_Bottom);
					}
					else
					{
						struct Node *node=eventnode->textlist->lh_Head;
						LONG count=0;

						set(textlist, MUIA_List_Quiet, TRUE);
						count=number=Active(textlist);
						DoMethod(textlist, MUIM_List_Remove, count);
						DoMethod(textlist, MUIM_List_Insert, &string, 1, count);
						while(count--)
							node=node->ln_Succ;
						node->ln_Name=strdup(string);
						set(textlist,	MUIA_List_Active, number);
						set(textlist, MUIA_List_Quiet, FALSE);
					}
					ShowGadgets();
					saved=FALSE;
					break;

				case ID_PURGEEVENT:
					if(CheckConfirm(saved, "Purge anyway?"))
					{
						saved=FALSE;
						PurgeEvents(eventlist);
					}
					break;

				case ID_DELETEEVENT:
					DeleteEvent(eventlist,Active(eventlist));
					saved=FALSE;
					break;

				case ID_MONTH:
					get(month, MUIA_Cycle_Active, &number);
					if(eventnode!=NULL)
					{
						short max=ShowDays(eventnode->month=number);
						eventnode->day=(eventnode->day<max ? eventnode->day : max);
						saved=FALSE;
					}
					SetWhenString(eventnode);
					set(editwin, MUIA_Window_ActiveObject, day[eventnode->day]);
					break;

				case ID_YEAR:
					get(year, MUIA_String_Contents, &string);
					if(eventnode!=NULL)
						eventnode->year=GetNum(year);
					SetWhenString(eventnode);
					set(window, MUIA_Window_ActiveObject, days);
					saved=FALSE;
					break;

				case ID_DAYS:
					if(eventnode!=NULL)
						eventnode->days=GetNum(days);
					SetWhenString(eventnode);
					set(window, MUIA_Window_ActiveObject, repeat);
					saved=FALSE;
					break;

				case ID_REPEAT:
					if(eventnode!=NULL)
					{
						eventnode->repeat=GetNum(repeat);
						set(editwin, MUIA_Window_ActiveObject, day[eventnode->day]);
					}
					SetWhenString(eventnode);
					saved=FALSE;
					break;

				case ID_DELETETEXT:
					DeleteText(eventnode->textlist, Active(textlist));
					DoMethod(textlist, MUIM_List_Remove, MUIV_List_Remove_Active);
					saved=FALSE;
					break;

				case ID_EVENTUP:
					Up(eventlist);
					saved=FALSE;
					break;

				case ID_TEXTUP:
					Up(textlist);
					UpdateTextList(textlist, eventnode->textlist);
					saved=FALSE;
					break;

				case ID_EVENTDOWN:
					Down(eventlist);
					saved=FALSE;
					break;

				case ID_TEXTDOWN:
					Down(textlist);
					UpdateTextList(textlist, eventnode->textlist);
					saved=FALSE;
					break;

				case ID_EVENTTOP:
					Top(eventlist);
					saved=FALSE;
					break;

				case ID_EVENTBOTTOM:
					Bottom(eventlist);
					saved=FALSE;
					break;

				case ID_SORTEVENT:
					if(DoMethod(window,MUIM_Window_GetMenuCheck,ID_SORTBY_NAME))
						DoMethod(eventlist, MUIM_List_Sort);
					else
						SortByDate(eventlist);
					DoMethod(eventlist, MUIM_List_GetEntry,
															MUIV_List_GetEntry_Active, &eventnode);
					UpdateData(eventnode);
					saved=FALSE;
					break;

				case ID_SORTTEXT:
					set(textlist, MUIA_List_Quiet, TRUE);
					DoMethod(textlist, MUIM_List_Sort);
					UpdateTextList(textlist, eventnode->textlist);
					set(textlist, MUIA_List_Quiet, FALSE);
					set(sorttext, MUIA_Disabled, TRUE);
					saved=FALSE;
					break;

				case ID_COPYEVENT:
					saved=FALSE;
					eventnode=CopyEvent(eventlist,
															Active(eventlist),
															sizeof(struct EventNode));
					set(window, MUIA_Window_ActiveObject, eventstring);
					ShowGadgets();
					break;

				case ID_COPYTEXT:
					DoMethod(textlist, MUIM_List_GetEntry, Active(textlist), &string);
					DoMethod(textlist, MUIM_List_Insert, &string, 1, Active(textlist)+1);
					AddText(eventnode->textlist, string, Active(textlist));
					set(textlist,	MUIA_List_Active, Active(textlist)+1);
					saved=FALSE;
					break;

				case ID_WHENDATE:
					saved=FALSE;
					get(whendate, MUIA_Cycle_Active, &number);
					if(eventnode!=NULL)
						eventnode->whendate=number;
					SetWhenString(eventnode);
					break;

				case ID_WHENTIME:
					saved=FALSE;
					get(whentime, MUIA_Cycle_Active, &number);
					if(eventnode!=NULL)
						eventnode->whentime=number;
					SetWhenString(eventnode);
					break;

				case ID_TYPE:
					saved=FALSE;
					get(type, MUIA_Cycle_Active, &number);
					if(eventnode!=NULL)
						eventnode->type=number;
					ShowGadgets();
					break;

				case ID_SHOW:
					saved=FALSE;
					get(show, MUIA_Cycle_Active, &number);
					eventnode->show=number;
					eventnode->datestamp=0;
					break;

				case ID_CALC:
					saved=FALSE;
					get(calc, MUIA_Cycle_Active, &number);
					if(eventnode!=NULL)
						eventnode->calc=number;
					break;

				case ID_EVENTLIST:
					addtextflag=FALSE;
					oldnode=eventnode;
					DoMethod(eventlist, MUIM_List_GetEntry, Active(eventlist), &eventnode);
					if(eventnode!=NULL)
						UpdateData(eventnode);
					ShowGadgets();
					set(window, MUIA_Window_ActiveObject, eventstring);
					set(textstring, MUIA_String_Contents, "");
					break;

				case ID_TEXTLIST:
					DoMethod(textlist, MUIM_List_GetEntry, Active(textlist), &string);
					set(textstring, MUIA_String_Contents, string);
					ShowGadgets();
					set(window, MUIA_Window_ActiveObject, textstring);
					break;

				case ID_EDITCLEAR:
					saved=FALSE;
					ZeroDateTime(eventnode);
					eventnode->whendate=0;
					eventnode->whentime=0;
					UpdateData(eventnode);
					break;

				case ID_EDITNOW:
					saved=FALSE;
					CurrentDateTime(eventnode);
					UpdateData(eventnode);
					break;

				case ID_EDIT:
					set(editwin,MUIA_Window_Open,TRUE);
					break;

				case ID_EDITCLOSE:
					set(editwin, MUIA_Window_Open, FALSE);
					break;

				case ID_HOUR:
					saved=FALSE;
					get(hour, MUIA_Prop_First, &number);
					if(eventnode!=NULL)
						eventnode->hour=23-number;
					SetWhenString(eventnode);
					break;

				case ID_MINUTES:
					saved=FALSE;
					get(minutes, MUIA_Prop_First, &number);
					if(eventnode!=NULL)
						eventnode->minutes=59-number;
					SetWhenString(eventnode);
					break;

				case ID_DAY1:		case ID_DAY2:		case ID_DAY3:		case ID_DAY4:
				case ID_DAY5:		case ID_DAY6:		case ID_DAY7:		case ID_DAY8:
				case ID_DAY9:		case ID_DAY10:	case ID_DAY11:	case ID_DAY12:
				case ID_DAY13:	case ID_DAY14:	case ID_DAY15:	case ID_DAY16:
				case ID_DAY17:	case ID_DAY18:	case ID_DAY19:	case ID_DAY20:
				case ID_DAY21:	case ID_DAY22:	case ID_DAY23:	case ID_DAY24:
				case ID_DAY25:	case ID_DAY26:	case ID_DAY27:	case ID_DAY28:
				case ID_DAY29:	case ID_DAY30:	case ID_DAY31:	case ID_DAY0:
					saved=FALSE;
					eventnode->day=id-100;
					SetWhenString(eventnode);
					set(editwin, MUIA_Window_ActiveObject, day[eventnode->day]);
					break;

				case ID_GETFILE:
					get(textstring, MUIA_String_Contents, &string);
					set(textstring, MUIA_String_Contents, GetFile(GetWinPtr(window),
																												aslreq,
																												"Select Command",
																												string,""));
					set(window, MUIA_Window_ActiveObject, textstring);
					break;


				/* parsing the menus */
				case ID_NEW:
					if(CheckConfirm(saved,"Clear anyway?"))
					{
						set(window, MUIA_Window_Sleep, TRUE);
						FreeEventList();
						ShowGadgets();
						set(window, MUIA_Window_Sleep, FALSE);
					}
					break;

				case ID_OPEN:
					if(CheckConfirm(saved,"Open anyway?"))
						if(OpenProject(eventlist, filename))
							saved=TRUE;
					break;

				case ID_MERGE:
					MergeProject(eventlist, filename);
					break;

				case ID_SAVE:
					if(WriteIFF(eventlist, PREFSFILE))
						saved=TRUE;
					break;

				case ID_SAVE_AS:
					SaveAsProject(eventlist, filename);
					saved=TRUE;
					break;

				case ID_CONVERTER:
					set(window, MUIA_Window_Sleep, TRUE);
					if(Exists(CONVDIR CONVERTERNAME))
						Execute("RUN >NIL: " CONVDIR CONVERTERNAME,NULL,NULL);
					else
						MUI_Request(app, window, 0, NULL,
												"*OK","'" CONVDIR CONVERTERNAME "'not found.");
					set(window, MUIA_Window_Sleep, FALSE);
					break;

				case ID_IMPORT_ASCII:
					if(GetFile(	GetWinPtr(window),
											aslreq,
											"Import as ASCII",
											strcat(filename, ".ASCII"),
											""))
					{
						ConverterArgs(LOAD_ASCII, filename, SAVE_V20, "RAM:T/Recall.tmp");
						FreeEventList();
						ReadIFF(eventlist, "RAM:T/Recall.tmp");
					}
					break;

				case ID_IMPORT_V14:
					if(GetFile(	GetWinPtr(window),
											aslreq,
											"Import as Recall V1.x",
											strcat(filename, ".V1.x"),
											""))
					{
						if(ConverterArgs(LOAD_V1X, filename, SAVE_V20, "RAM:T/Recall.tmp"))
						{
							FreeEventList();
							ReadIFF(eventlist, "RAM:T/Recall.tmp");
						}
					}
					break;

				case ID_EXPORT_ASCII:
					WriteIFF(eventlist, "RAM:T/Recall.tmp");
					if(GetFile(	GetWinPtr(window),
											aslreq,
											"Export as ASCII",
											strcat(filename, ".ASCII"),
											""))
						ConverterArgs(LOAD_V20, "RAM:T/Recall.tmp", SAVE_ASCII, filename);
					break;

				case ID_LAST_SAVED:
					if(CheckConfirm(saved,"Reset file anyway?"))
					{
						FreeEventList();
						ReadIFF(eventlist, PREFSFILE);
						saved=TRUE;
					}
					break;

				case ID_REQTOOLS:
				if(DoMethod(window, MUIM_Window_GetMenuCheck, ID_REQTOOLS))
					DoMethod(app, MUIM_Application_SetMenuState, ID_CENTRE_REQUESTERS, TRUE);
				else
					DoMethod(app, MUIM_Application_SetMenuState, ID_CENTRE_REQUESTERS, FALSE);
			}
			if(running && signals)
				Wait(signals);
		}
		set(window,MUIA_Window_Open,FALSE);
		MUI_FreeAslRequest(aslreq);
		FreeEventList();
		DeleteFile(TESTFILE);
		fail(app,NULL);
	}
}

int GetNum(APTR obj)
{
	char *string,*dummy;

	get(obj, MUIA_String_Contents, &string);
	return strtol(string,&dummy,10);
}

BOOL Exists(char name[FNSIZE])
{
	FILE	*fp=NULL;
	BOOL	exists=FALSE;

	if(fp=fopen(name, "r"))
		exists=TRUE;
	fclose(fp);
	return exists;
}

BOOL CheckConfirm(BOOL saved, char text[80])
{
	char tmp[80]="Project not saved... ";

	strcat(tmp,text);
	if(DoMethod(window,MUIM_Window_GetMenuCheck,ID_CONFIRM) & !saved)
		return (BOOL)(MUI_Request(app, window, 0, NULL, "*OK|Cancel",tmp));
	else
		return TRUE;
}

void PurgeEvents(Object *list)
{
	struct EventNode	*eventnode;
	char							buf[8];
	BOOL							remove=FALSE;
	LONG pos=0;
	short now_day,   now_month,		now_year,		now_hour,		now_min;
	short event_day, event_month, event_year, event_hour, event_min;

	set(window, MUIA_Window_Sleep, TRUE);
	set(list, MUIA_List_Quiet, TRUE);

	getclk(buf);
	now_day			=buf[3];
	now_month		=buf[2];
	now_year		=buf[1]+1980;
	now_hour		=buf[4];
	now_min			=buf[5];

	while(TRUE)
	{
		remove=FALSE;
		DoMethod(list, MUIM_List_GetEntry, pos, &eventnode);
		if(eventnode==NULL)
			break;

		event_day=eventnode->day;
		event_month=eventnode->month;
		event_year=eventnode->year;
		event_hour=eventnode->hour;
		event_min=eventnode->minutes;

		if(event_day==0)
			event_day=now_day;
		if(event_month==0)
			event_month=now_month;
		if(event_year==0)
			event_year=now_year;

		event_year=AdjustYear(eventnode->year);

		if(eventnode->year && eventnode->year<now_year & eventnode->year>0 & eventnode->whendate!=AFTER)
			remove=TRUE;
		else if(eventnode->year==now_year)
			if(eventnode->month<now_month & eventnode->whendate!=AFTER)
				remove=TRUE;
			else if(eventnode->month==now_month)
				if(eventnode->day<now_day & eventnode->month>0 & eventnode->whendate!=AFTER)
					remove=TRUE;
				else if(eventnode->day==now_day)
					if(eventnode->hour<now_hour & eventnode->whentime!=AFTER)
						remove=TRUE;
					else if(eventnode->hour==now_hour)
						if(eventnode->whendate==BEFORE)
								remove=TRUE;
		if(remove)
			DeleteEvent(list, pos);
		else
			pos++;
	}
	set(eventlist, MUIA_List_Quiet, FALSE);
	set(window, MUIA_Window_Sleep, FALSE);
}

BOOL ConverterArgs(	short intype,  char source[FNSIZE],
										short outtype, char dest[FNSIZE])
{
	char args[FNSIZE];
	sprintf(args, "%s %d \"%s\" %d \"%s\"", CONVDIR CONVERTERNAME, intype, source, outtype, dest);

	if(Exists(CONVDIR CONVERTERNAME))
		Execute(args,NULL,NULL);
	else
	{
		MUI_Request(app, window, 0, NULL, "*OK",
								"Could not find '" CONVDIR CONVERTERNAME "'...");
		return FALSE;
	}
	return TRUE;
}
