/*
 *	File:					Recall.c
 *	Description:	Runs through a project of events set by it's preferences
 *								and displays them.
 *	Version:			2.0
 *	Author:				Ketil Hunn
 *	Mail:					hunn@dhmolde.no
 *								ketil@lyr.dhmolde.no
 *
 *	Copyright  1993 Ketil Hunn.  Please read the document for further
 *	information and copyrights.
 *
 *	In order to list the source-files included in this package properly,
 *	the TAB size should be set at 2.
 *
 */

#define REQUESTER_TYPE	0
#define	MYALERT_TYPE		1
#define	EXECUTE_TYPE		2

#define	ALWAYS					0
#define	ONCE_A_DAY			1
#define	NEVER						2

#define CALC_YEARS			0
#define CALC_DAYS				1

#define GROUP_STAMP			-100

char *CatSingleEventTexts(struct EventNode *eventnode, char *text);
char *CatGroupEventsTexts(struct List *list, short type, char *text);
void SetDisplayBits(struct EventNode *eventnode);

#include <stdio.h>
#include <libraries/reqtools.h>
#include <intuition/intuition.h>
#include	<exec/alerts.h>

#include <exec/types.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/reqtools.h>

struct Library				*IntuitionBase;
struct ReqToolsBase 	*ReqToolsBase=NULL;
struct List						*list=NULL;

#include "Version.h"
#include "MyRequest().h"
#include "Config20b.h"
#include "MyAlert().h"
#include "CheckDateTime.h"

short reqType=REQTOOLS_TYPE;
char const *version = VERSTR;
ULONG normaltag[]={	RTEZ_ReqTitle, (ULONG)(PROGNAME " " VERSION),
										TAG_END};
ULONG centretag[]={	RTEZ_ReqTitle,(ULONG)(PROGNAME " " VERSION),
										RT_ReqPos, REQPOS_CENTERSCR,
										TAG_END};

int main(int argc,char *argv[])
{
	char *text, button[10]="OK";
	short type, retvalue_event, retvalue_alert;
	BOOL	group_event_cancel=FALSE;
	BOOL	group_alert_cancel=FALSE;
	struct Node *node;
	struct EventNode *eventnode;
	char filename[FNSIZE];
	char alertcancel[80]="\n\nLeft mousebutton=OK                         Right mousebutton=Cancel";

	if(argc>1)
		strcpy(filename, argv[1]);
	else
		strcpy(filename, PREFSFILE);

	if(IntuitionBase=OpenLibrary("intuition.library",37))
	{
		if(list=AllocMem(sizeof(struct List),MEMF_CLEAR))
		{
			NewList(list);
			if(ReadIFF(list, filename))
			{
				// do not open reqtools.library if not needed
				if(config.usereqtools)
					ReqToolsBase=	(struct ReqToolsBase *)OpenLibrary
												(REQTOOLSNAME, REQTOOLSVERSION);

				// Run through the list and mark all events that will be displayed
				for(every_node)
				{
					eventnode=(struct EventNode *)node;
					if(!(eventnode->show==NEVER | eventnode->datestamp==MakeTime(NULL)))
						if(CheckDateTime(eventnode))
							eventnode->display=TRUE;
				}

				// add a cancel-button to the requester
				if(config.ack_events)
					strcpy(button, "  OK  |Cancel");
				
				if(text=malloc(2500))
				{
					for(every_node)
					{
						strcpy(text, "");
						eventnode=(struct EventNode *)node;
						type=eventnode->type;
						if(eventnode->display==TRUE)
						{
							if(config.groupevents)
								CatGroupEventsTexts(list, eventnode->type, text);
							else
								CatSingleEventTexts(eventnode, text);
						
							if(strlen(text))
							{
								if(config.flashscreen)
									DisplayBeep(NULL);

								switch(eventnode->type)
								{
									case REQUESTER_TYPE:
										if(config.usereqtools)
										{
											if(config.centrerequesters)
												retvalue_event=rtEZRequest(text, button, NULL,
																									(struct TagItem *)centretag);
											else
												retvalue_event=rtEZRequest(text, button, NULL,
																									(struct TagItem *)normaltag);
										}
										else
											retvalue_alert=MyEZRequest(text, button, "");
										break;

									case MYALERT_TYPE:
										if(config.ack_alerts)
											strcat(text, alertcancel);
										retvalue_alert=MyAlert(RECOVERY_ALERT, text);
										break;

									case EXECUTE_TYPE:
										System(text, NULL);
										break;
								}
							}
							if(config.ack_events && !retvalue_event &&
									eventnode->type==REQUESTER_TYPE)
								if(config.groupevents)
									group_event_cancel=TRUE;
								else
									eventnode->datestamp=MakeTime(NULL);
							if(config.ack_alerts && !retvalue_alert &&
									eventnode->type==MYALERT_TYPE)
								if(config.groupevents)
									group_alert_cancel=TRUE;
								else
									eventnode->datestamp=MakeTime(NULL);
 						}
						if(	group_event_cancel && eventnode->datestamp==GROUP_STAMP &&
								eventnode->type==REQUESTER_TYPE)
							eventnode->datestamp=MakeTime(NULL);
						if(	group_alert_cancel && eventnode->datestamp==GROUP_STAMP &&
								eventnode->type==MYALERT_TYPE)
							eventnode->datestamp=MakeTime(NULL);
					}
					free(text);
					WriteIFF(list, filename);
				}
			}
			FreeEventList(list);
			FreeMem(list,sizeof(struct List));
		}
		if(ReqToolsBase)
			CloseLibrary((struct Library *)ReqToolsBase);
		CloseLibrary(IntuitionBase);
	}
	exit(0);
}

char *CatSingleEventTexts(struct EventNode *eventnode, char *text)
{
	struct List *list=eventnode->textlist;
	struct Node *node;

	SetDisplayBits(eventnode);
	for(every_node)
	{
		strcat(text, node->ln_Name);
		if(node!=list->lh_TailPred)
			strcat(text, "\n");
	}
	return CalcField(eventnode, text);
}

char *CatGroupEventsTexts(struct List *list, short type, char *text)
{
	struct Node *node;
	struct EventNode *eventnode;
	char   *tmp;
	BOOL   newline=FALSE;

	if(tmp=malloc(2500))
	{
		for(every_node)
		{
			eventnode=(struct EventNode *)node;
			if(eventnode->type==type & eventnode->display==TRUE)
			{
				if(!newline)
					newline=TRUE;
				else
					strcat(text, "\n");
				strcpy(tmp, "");
				strcat(text, CatSingleEventTexts(eventnode, tmp));
			}
		}
		free(tmp);
	}
	return text;
}

void SetDisplayBits(struct EventNode *eventnode)
{
	eventnode->display=FALSE;
	if(eventnode->show==ONCE_A_DAY)
		eventnode->datestamp=MakeTime(NULL);
	else if(config.groupevents)
		eventnode->datestamp=-100;
}
