/*
 *	File:					Prototypes.h
 *	Description:	Defines the prototypes for all the functions used in
 *								this packages.
 *
 *	(C) 1993 Ketil Hunn
 *
 */

void PrintList(Object *list);


/* MAIN PROGRAM */
void About(void);
int GetNum(APTR obj);
char ToStr(int value);
void SetWhenString(struct EventNode *node);
BOOL Exists(char name[256]);
BOOL CheckConfirm(BOOL saved, char text[80]);
BOOL ConverterArgs(	short intype,  char source[FNSIZE],
										short outtype, char dest[FNSIZE]);


/* GUI.h */
APTR SetupGUI(void);
void ShowMenu(BOOL on);
void ShowEventGadgets(BOOL);
void ShowTextGadgets(BOOL);
void FreshStart(void);
void UpdateData(struct EventNode *);
void CheckActive(Object *, APTR, APTR, APTR, APTR);
void ZeroDateTime(struct EventNode *node);
void CurrentDateTime(struct EventNode *node);
int ShowDays(int month);
struct EventNode *ActivateFirst(Object *list);
void ShowGadgets(void);
struct Window *GetWinPtr(APTR WI_Any);


/* MUI_lists.h */
struct EventNode *AddEvent(Object *list, char *name, LONG pos);
struct Node *AddText(struct List *list, char *name, LONG pos);
void DeleteEvent(Object *list, LONG pos);
void DeleteText(struct List *list, LONG pos);
__inline ULONG Count(Object *list);
__inline LONG Active(Object *list);
void Up(Object *);
void Down(Object *);
void Top(Object *);
void Bottom(Object *);
void FreeEventList(void);
void FreeTextList(struct List *list);
void PurgeEvents(Object *list);
void UpdateTextList(Object *source, struct List *dest);
void SortByDate(Object *list);


/* IFFconfig.h */
BOOL OpenProject(Object *list, char file[35]);
BOOL MergeProject(Object *list, char file[35]);
BOOL SaveAsProject(Object *list, char file[35]);
BOOL ReadIFF(Object *list, char *file);
BOOL WriteIFF(Object *list, char *file);
