/*
 *	File:					MyRequest().h
 *	Description:	Displays a text in different requesters
 *
 *	(C) 1993, Ketil Hunn
 *
 */

#ifndef MYREQUEST_H
#define MYREQUEST_H

extern short reqType;

#define INTUITION_TYPE	0
#define REQTOOLS_TYPE		1
#define MUI_TYPE				3

long MyEZRequest(char *format, char *buttons, char *param)
{
	long retval=0;

	struct EasyStruct myES =
		{
		sizeof(struct EasyStruct),
		0,
		PROGNAME " " VERSION,
		0,
		0,
		};

	myES.es_TextFormat=format;
	myES.es_GadgetFormat=buttons;
	retval=EasyRequest(NULL, &myES, NULL);

	return retval;
}

long MyRequest(char *format, char *buttons, char *param)
{
	extern APTR app, window;
	LONG retvalue;

	switch(reqType)
	{

#ifdef LIBRARIES_REQTOOLS_H
		case REQTOOLS_TYPE:
			if(ReqToolsBase)
				retvalue=rtEZRequest(format, buttons, NULL, NULL, param);
			else
				retvalue=MyEZRequest(format, buttons, param);
			break;
#endif

#ifdef LIBRARIES_MUI_H
		case MUI_TYPE:
			if(MUIMasterBase)
				retvalue=MUI_Request(app, window, 0, NULL, buttons, format, param);
			else
				retvalue=MyEZRequest(format, buttons, param);
			break;
#endif

		default:
			retvalue=MyEZRequest(format, buttons, param);
			break;
	}
	return retvalue;
}
#endif
