/*
 *	File:					GUI.h
 *	Description:	Sets up the GUI.  Contains also a set of functions to
 *								manipulate the user-interface.
 *
 *	(C) 1993, Ketil Hunn
 *
 */

ULONG olddate=-1;

/* VARIABLES set up exactly like the GUI is shown */

APTR	whendate,					whentime,
			day[32],					hour, minutes,
			month,	year,
			days,		repeat,

			editnow, editclear;


APTR																				whenstring,		edit,
			eventlistview,												textlistview,
			eventstring,													getfile, textstring,

			addevent, 	eventup, 		eventtop,			addtext,		textup,		type,
			copyevent,	eventdown,	eventbottom,	copytext,		textdown,	show,
			deleteevent,purgeevent,	sortevent,		deletetext,	sorttext,	calc,

		save,															test,											cancel;


APTR app,window,editwin;

Object *eventlist, *textlist;

static char *cltype[]		={"Requester",	"Alert",			"Execute", NULL };
static char *clshow[]		={"Always",			"Once a day",	"Never",		NULL };
static char *clcount[]	={"Years",			"Days",				 NULL };
static char *clwhen[]		={"Exact",			"Before",			"After",		NULL };

#define REQUESTER	0
#define ALERT			1
#define EXECUTE		2

#define EXACT			0
#define BEFORE		1
#define AFTER			2

char *clmonths[] 	=	{ "Any month",
											"January",	"February",	"March",		 "April",
											"May",			"June",			"July", 		"August",
											"September","October",	"November", "December",
											 NULL };

/* Menu-structure */
struct NewMenu recmenu[] = {
	NM_TITLE,	"Project",				NULL,	0,	0L,	NULL,
		NM_ITEM,	"New...",					"N",	0,	0L,	(APTR)ID_NEW,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Open...",				"O",	0,	0L,	(APTR)ID_OPEN,
		NM_ITEM,	"Merge...",				"M",	0,	0L,	(APTR)ID_MERGE,
		NM_ITEM,	"Import",					NULL,	0,	0L,	(APTR)ID_MERGE,
			NM_SUB, 	"ASCII...",			NULL,	0, 	0L,	(APTR)ID_IMPORT_ASCII,
			NM_SUB, 	"Recall V1.x...",NULL, 0,	0L,	(APTR)ID_IMPORT_V14,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Save...",				"S",	0,	0L,	(APTR)ID_SAVE,
		NM_ITEM,	"Save As...",			"A",	0,	0L,	(APTR)ID_SAVE_AS,
		NM_ITEM,	"Export",					NULL,	0,	0L,	(APTR)ID_MERGE,
			NM_SUB, 	"ASCII...",			NULL,	0,	0L,	(APTR)ID_EXPORT_ASCII,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Converter",			NULL,	0,	0L,	(APTR)ID_CONVERTER,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Test",						"T",	0,	0L,	(APTR)ID_TEST,
		NM_ITEM,	"Iconify",				"I",	0,	0L,	(APTR)ID_ICONIFY,
		NM_ITEM,	"About...",				"?",	0,	0L,	(APTR)ID_ABOUT,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Quit",						"Q",	0,	0L,	(APTR)MUIV_Application_ReturnID_Quit,

	NM_TITLE,	"Edit",							NULL,	0,	0L,	NULL,
		NM_ITEM,"Last Saved",				"L",	0,	0L,	(APTR)ID_LAST_SAVED,

	NM_TITLE,	"Settings",								NULL,	0,	0L,	NULL,
		NM_ITEM,"Group events?",					NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_GROUP_EVENTS,
		NM_ITEM,"Flash screen?",					NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_FLASH_SCREEN,
		NM_ITEM,"Acknowledge events?",		NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_ACK_EVENTS,
		NM_ITEM,"Acknowledge alerts?",		NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_ACK_ALERTS,
		NM_ITEM,"Use ReqTools",						NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_REQTOOLS,
		NM_ITEM,"Centre Requesters?",			NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_CENTRE_REQUESTERS,
		NM_ITEM,	NM_BARLABEL,						NULL,	0,	0L,	NULL,
		NM_ITEM,"Confirm?",								NULL,CHECKIT|MENUTOGGLE,0L,(APTR)ID_CONFIRM,
		NM_ITEM,"AutoOpen calendar?",			NULL,CHECKIT|MENUTOGGLE,0L,(APTR)ID_AUTOOPEN_CALENDAR,
		NM_ITEM,"AutoDelete events?",			NULL,CHECKIT|CHECKED|MENUTOGGLE,0L,(APTR)ID_AUTODELETE,
		NM_ITEM, 	"Sort by", 							NULL,0, NULL, NULL,
			NM_SUB, 	"Name", 							NULL,CHECKIT|CHECKED, 2L,(APTR)ID_SORTBY_NAME,
			NM_SUB, 	"Date", 							NULL,CHECKIT, 1L,(APTR)ID_SORTBY_DATE,
	{NM_END,	NULL,											0,		0,	0,	(APTR)0},
 };


/* Setting up the GUI */
APTR SetupGUI(void)
{
	init();

	app = ApplicationObject,
		MUIA_Application_Title      , PREFSNAME,
		MUIA_Application_Version    , VERSTR,
		MUIA_Application_Copyright  , COPYRIGHT " "AUTHOR,
		MUIA_Application_Author     , AUTHOR,
		MUIA_Application_Description, DESCRIPTION,
		MUIA_Application_Base       , "RECBASE",

		SubWindow,editwin = WindowObject,
				MUIA_Window_Title, "Setting the date and time",
				MUIA_Window_ID,    'EDIT',
//				MUIA_Window_Menu,	recmenu,
				MUIA_HelpFile,			RECALLGUIDE,
				WindowContents, VGroup,

					MUIA_HelpNode, "SetDate",
					Child, HGroup,
						MUIA_HelpNode, "Calendar",
						Child, VGroup, GroupFrameT("Date"),
							Child, whendate = KeyCycle(clwhen, NULL),
							Child, HGroup,
								Child, ColGroup(7), MUIA_Group_SameSize, TRUE,
									GroupSpacing(0),
//									Child, KeyLabel1(aCENTRE "Mon",	NULL),
//									Child, KeyLabel1(aCENTRE "Tue",	NULL),
//									Child, KeyLabel1(aCENTRE "Wed",	NULL),
//									Child, KeyLabel1(aCENTRE "Thu",	NULL),
//									Child, KeyLabel1(aCENTRE "Fri",	NULL),
//									Child, KeyLabel1(aCENTRE "Sat",	NULL),
//									Child, KeyLabel1(aCENTRE "Sun",	NULL),

									Child, day[0]		=	KeyButton("0",		NULL),
									Child, day[1]		=	KeyButton("1"			, NULL),
									Child, day[2]		=	KeyButton("2"			, NULL),
									Child, day[3]		=	KeyButton("3"			, NULL),
									Child, day[4]		=	KeyButton("4"			, NULL),
									Child, day[5]		=	KeyButton("5"			, NULL),
									Child, day[6]		=	KeyButton("6"			, NULL),

									Child, day[7]		=	KeyButton("7"			, NULL),
									Child, day[8]		=	KeyButton("8"			, NULL),
									Child, day[9]		=	KeyButton("9"			, NULL),
									Child, day[10]	=	KeyButton("10"		, NULL),
									Child, day[11]	=	KeyButton("11"		, NULL),
									Child, day[12]	=	KeyButton("12"		, NULL),
									Child, day[13]	=	KeyButton("13"		, NULL),

									Child, day[14]	=	KeyButton("14"		, NULL),
									Child, day[15]	=	KeyButton("15"		, NULL),
									Child, day[16]	=	KeyButton("16"		, NULL),
									Child, day[17]	=	KeyButton("17"		, NULL),
									Child, day[18]	=	KeyButton("18"		, NULL),
									Child, day[19]	=	KeyButton("19"		, NULL),
									Child, day[20]	=	KeyButton("20"		, NULL),

									Child, day[21]	=	KeyButton("21"		, NULL),
									Child, day[22]	=	KeyButton("22"		, NULL),
									Child, day[23]	=	KeyButton("23"		, NULL),
									Child, day[24]	=	KeyButton("24"		, NULL),
									Child, day[25]	=	KeyButton("25"		, NULL),
									Child, day[26]	=	KeyButton("26"		, NULL),
									Child, day[27]	=	KeyButton("27"		, NULL),

									Child, day[28]	=	KeyButton("28"		, NULL),
									Child, day[29]	=	KeyButton("29"		, NULL),
									Child, day[30]	=	KeyButton("30"		, NULL),
									Child, day[31]	=	KeyButton("31"		, NULL),
									Child, KeyLabel1("",	NULL),
									Child, KeyLabel1("",	NULL),
									Child, KeyLabel1("",	NULL),
								End,
							End,

						Child, HGroup,
							Child, month = KeyCycle(clmonths, NULL),
							Child, year = StringObject,
														MUIA_String_Accept , "0123456879",
														MUIA_String_MaxLen, 	5,
														StringFrame,
							End,
						End,
					End,

					Child, VGroup, GroupFrameT("Time"),
						Child, whentime = KeyCycle(clwhen, NULL),
						Child, VGroup,
							Child, ColGroup(2),
								Child, KeyLabel1("Hour",	NULL),
								Child, KeyLabel1("Min",	NULL),
								Child, hour=PropObject, PropFrame,
									MUIA_Prop_Horiz, FALSE,
									MUIA_FixWidth , 10,
									MUIA_Prop_Entries, 25,
									MUIA_Prop_Visible, 1,
								End,
								Child, minutes=PropObject, PropFrame,
									MUIA_Prop_Horiz, FALSE,
									MUIA_FixWidth , 10,
									MUIA_Prop_Entries, 61,
									MUIA_Prop_Visible, 1,
								End,
							End,
						End,
					End,
				End,

				Child, HGroup, GroupFrameT("Special"),
					Child, HGroup,
						MUIA_HelpNode, "SetDays",
						Child, KeyLabel1("Days:",	'd'),
						Child, days = StringObject,
													MUIA_String_Accept , "0123456879",
													MUIA_String_MaxLen, 	3,
													StringFrame,
						End,
					End,
					Child, HSpace(0),
					Child, HGroup,
						Child, KeyLabel1("Repeat every:",	'r'),
						Child, repeat = StringObject,
													MUIA_String_Accept , "0123456879",
													MUIA_String_MaxLen, 	4,
													StringFrame,
						End,
					End,
				End,

//				Child, whenstring2 = TextObject,
//					TextFrame,
//					MUIA_Background, MUII_TextBack,
//				End,

				Child, VSpace(3),
				Child, HGroup, MUIA_Group_SameSize, TRUE,
					Child, HGroup,
						MUIA_HelpNode, "Now",
						Child, editnow		=	KeyButton("Now",	'n'),
					End,
					Child, HGroup,
						MUIA_HelpNode, "Clear",
						Child, editclear	=	KeyButton("Clear",'c'),
					End,
				End,
			End,
		End,

		SubWindow, window =   WindowObject,
			MUIA_Window_Title, PREFSNAME,
			MUIA_Window_ID,    'REC',
			MUIA_Window_Menu,   recmenu,
			MUIA_HelpFile,			RECALLGUIDE,
			WindowContents, VGroup,
				MUIA_HelpNode, "UsingRecallPrefs",
				Child, HGroup, MUIA_Group_SameHeight, TRUE,
					Child, VGroup, GroupFrameT("Events"),
							MUIA_HorizWeight, 30,

						Child,
							eventlist = ListviewObject,
								MUIA_Listview_Input, TRUE,
								MUIA_Listview_List, ListObject,InputListFrame,
							End,
						End,
						GroupSpacing(0),
						Child, eventstring = StringObject,
							MUIA_String_MaxLen, 29,
							StringFrame,
							MUIA_HelpNode, "AddEvent",
						End,

						Child, VSpace(3),
						Child, ColGroup(3),	MUIA_Group_SameSize, TRUE,
							MUIA_HelpNode, "MoveEvent",
							Child, HGroup,
								MUIA_HelpNode, "AddEvent",
								Child, addevent			=	KeyButton("Add"    ,'a'),
							End,
							Child, eventup			=	KeyButton("Up"     ,'u'),
							Child, eventtop			=	KeyButton("Top"    ,'o'),
							Child, HGroup,
								MUIA_HelpNode, "CopyEvent",
								Child, copyevent		=	KeyButton("Copy"   ,'c'),
							End,
							Child, eventdown		=	KeyButton("Down"   ,'w'),
							Child, eventbottom	=	KeyButton("Bottom" ,'b'),
							Child, HGroup,
								MUIA_HelpNode, "DeleteEvent",
								Child, deleteevent	=	KeyButton("Delete" ,NULL),
							End,
							Child, HGroup,
								MUIA_HelpNode, "PurgeEvents",
								Child, purgeevent		=	KeyButton("Purge"  ,'p'),
							End,
							Child, HGroup,
								MUIA_HelpNode, "SortEvents",
								Child, sortevent		=	KeyButton("Sort"   ,'s'),
							End,
						End,
					End,

					Child, VGroup, GroupFrameT("Text"),
						MUIA_HelpNode, "SetDate",
						Child, HGroup,
							Child, whenstring = TextObject,
								TextFrame,
								MUIA_Background, MUII_TextBack,
							End,
							Child, VGroup,
								MUIA_HorizWeight, 5,
								Child, edit	=	KeyButton("Edit...",	'e'),
							End,
						End,

						Child, VSpace(3),

						Child, textlist = ListviewObject,
							MUIA_Listview_List, ListObject,
								InputListFrame,
								MUIA_List_ConstructHook,	MUIV_List_ConstructHook_String,
								MUIA_List_DestructHook,		MUIV_List_DestructHook_String,
							End,
						End,

						GroupSpacing(0),
						Child, HGroup,
							GroupSpacing(0),
							Child, getfile = ImageObject,
									MUIA_Image_Spec,			MUII_PopFile,
									MUIA_Image_FreeVert,	TRUE,
									MUIA_ShowSelState,		TRUE,
									MUIA_Weight,					0,
									MUIA_Frame,						MUIV_Frame_Button,
									MUIA_Background,			MUII_BACKGROUND,
									MUIA_InputMode,				MUIV_InputMode_RelVerify,
								End,
							Child, textstring = StringObject,
								MUIA_String_MaxLen, 255,
								StringFrame,
							End,
						End,

						Child, VSpace(3),
						Child, HGroup,
							Child, ColGroup(5),
								MUIA_HelpNode, "MoveText",
								Child, HGroup,
									MUIA_HelpNode, "AddText",
									Child, addtext		=	KeyButton("Add",		'd'),
								End,
								Child, textup			=	KeyButton("Up",			NULL),
								Child, HSpace(0),
								Child, 							KeyLabel1("Type:",	'y'),
								Child, HGroup,
									Child, type				=	KeyCycle(  cltype,		'y'),
									MUIA_HelpNode, "SetType",
								End,
								Child, HGroup,
									MUIA_HelpNode, "CopyText",
									Child, copytext		=	KeyButton("Copy",		NULL),
								End,
								Child, textdown		=	KeyButton("Down",		NULL),
								Child, HSpace(0),
								Child, 							KeyLabel1("Show:",	'h'),
								Child, HGroup,
									Child, show				=	KeyCycle(  clshow,		'h'),
									MUIA_HelpNode, "SetShow",
								End,
								Child, HGroup,
									MUIA_HelpNode, "DeleteText",
									Child, deletetext	=	KeyButton("Delete",	NULL),
								End,
								Child, HGroup,
									MUIA_HelpNode, "SortText",
									Child, sorttext		=	KeyButton("Sort",		NULL),
								End,
								Child, HSpace(0),
								Child, 							KeyLabel1("Count:",	'n'),
								Child, HGroup,
									Child, calc				= KeyCycle(  clcount,		'n'),
									MUIA_HelpNode, "SetCalc",
								End,
							End,
						End,
					End,
				End,

				Child, VSpace(6),
				Child, HGroup, MUIA_Group_SameSize, TRUE,
					Child, HGroup,
						MUIA_HelpNode, "Save",
						Child, save	=	KeyButton("Save",		NULL),
					End,
					Child, HSpace(0),
					Child, HGroup,
						MUIA_HelpNode, "Test",
						Child, test	=	KeyButton("Test",		NULL),
					End,
					Child, HSpace(0),
					Child, HGroup,
						MUIA_HelpNode, "Cancel",
						Child, cancel =	KeyButton("Cancel", NULL),
					End,
					End,
				End,
			End,
		End;

	if(!app)
		fail(app,"Failed to create Application.");

	set(window,MUIA_Window_Open,TRUE);

	ReadIFF(eventlist, PREFSFILE);
	if(config.autodelete)
		PurgeEvents(eventlist);

	if(DoMethod(window,MUIM_Window_GetMenuCheck, ID_AUTOOPEN_CALENDAR))
		set(editwin, MUIA_Window_Open, TRUE);

	DoMethod(window,MUIM_Window_SetCycleChain,
						eventlist,
						addevent,		copyevent,	deleteevent,
						eventup,		eventdown,	eventtop,	eventbottom,
						purgeevent,	sortevent,	
						eventstring,
						edit,				year,
						hour,				minutes,
						days,				repeat,
						editnow,		editclear,
						textstring,
						addtext,		copytext,		deletetext,
						textup,			textdown,		sorttext,
						textlist,
						type,				show,				calc,
						save,				test,				cancel,
						NULL);

	DoMethod(window,			MUIM_Notify, MUIA_Window_CloseRequest,TRUE,app,2,MUIM_Application_ReturnID,ID_CANCEL);
	DoMethod(editwin,			MUIM_Notify, MUIA_Window_CloseRequest,TRUE,app,2,MUIM_Application_ReturnID,ID_EDITCLOSE);

	DoMethod(addevent,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_ACTIVATE_EVENTSTRING);
	DoMethod(copyevent,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_COPYEVENT);
	DoMethod(deleteevent,	MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DELETEEVENT);
	DoMethod(eventup,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EVENTUP);
	DoMethod(eventdown,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EVENTDOWN);
	DoMethod(eventtop,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EVENTTOP);
	DoMethod(eventbottom,	MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EVENTBOTTOM);
	DoMethod(purgeevent,	MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_PURGEEVENT);
	DoMethod(sortevent,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_SORTEVENT);

	DoMethod(edit,				MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EDIT);
	DoMethod(getfile,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_GETFILE);

	DoMethod(addtext,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_ACTIVATE_TEXTSTRING);
	DoMethod(copytext,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_COPYTEXT);
	DoMethod(deletetext,	MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DELETETEXT);
	DoMethod(textup,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_TEXTUP);
	DoMethod(textdown,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_TEXTDOWN);
	DoMethod(sorttext,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_SORTTEXT);

	DoMethod(type,				MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_TYPE);
	DoMethod(show,				MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_SHOW);
	DoMethod(calc,				MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_CALC);

	DoMethod(save,				MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_SAVE_QUIT);
	DoMethod(test,				MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_TEST);
	DoMethod(cancel,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_CANCEL);

	DoMethod(eventstring,	MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_ADDEVENT);
	DoMethod(textstring,	MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_ADDTEXT);

	DoMethod(day[0],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY0);
	DoMethod(day[1],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY1);
	DoMethod(day[2],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY2);
	DoMethod(day[3],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY3);
	DoMethod(day[4],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY4);
	DoMethod(day[5],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY5);
	DoMethod(day[6],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY6);
	DoMethod(day[7],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY7);
	DoMethod(day[8],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY8);
	DoMethod(day[9],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY9);
	DoMethod(day[10],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY10);
	DoMethod(day[11],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY11);
	DoMethod(day[12],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY12);
	DoMethod(day[13],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY13);
	DoMethod(day[14],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY14);
	DoMethod(day[15],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY15);
	DoMethod(day[16],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY16);
	DoMethod(day[17],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY17);
	DoMethod(day[18],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY18);
	DoMethod(day[19],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY19);
	DoMethod(day[20],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY20);
	DoMethod(day[21],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY21);
	DoMethod(day[22],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY22);
	DoMethod(day[23],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY23);
	DoMethod(day[24],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY24);
	DoMethod(day[25],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY25);
	DoMethod(day[26],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY26);
	DoMethod(day[27],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY27);
	DoMethod(day[28],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY28);
	DoMethod(day[29],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY29);
	DoMethod(day[30],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY30);
	DoMethod(day[31],			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_DAY31);

	DoMethod(month,				MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_MONTH);
	DoMethod(year,				MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_YEAR);
	DoMethod(days,				MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_DAYS);
	DoMethod(repeat,			MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_REPEAT);
	DoMethod(whendate,		MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_WHENDATE);
	DoMethod(whentime,		MUIM_Notify, MUIA_Cycle_Active, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID, ID_WHENTIME);

	DoMethod(editclear,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EDITCLEAR);
	DoMethod(editnow,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_EDITNOW);

	/* Disable Days & Repeat when Date is equal to 'Exact' */
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 0, days, 3, MUIM_Set, MUIA_Disabled, TRUE);
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 1, days, 3, MUIM_Set, MUIA_Disabled, FALSE);
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 2, days, 3, MUIM_Set, MUIA_Disabled, FALSE);
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 0, repeat, 3, MUIM_Set, MUIA_Disabled, TRUE);
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 1, repeat, 3, MUIM_Set, MUIA_Disabled, FALSE);
	DoMethod(whendate, MUIM_Notify, MUIA_Cycle_Active, 2, repeat, 3, MUIM_Set, MUIA_Disabled, FALSE);

	set(eventstring,		MUIA_String_AttachedList, eventlist);
	set(textstring,			MUIA_String_AttachedList, textlist);
	DoMethod(eventlist, MUIM_Notify, MUIA_List_Active, MUIV_EveryTime, app,2, MUIM_Application_ReturnID,ID_EVENTLIST);
	DoMethod(textlist,  MUIM_Notify, MUIA_List_Active, MUIV_EveryTime, app,2, MUIM_Application_ReturnID,ID_TEXTLIST);

	DoMethod(hour, 		MUIM_Notify, MUIA_Prop_First, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID,ID_HOUR);
	DoMethod(minutes, MUIM_Notify, MUIA_Prop_First, MUIV_EveryTime, app, 2, MUIM_Application_ReturnID,ID_MINUTES);

	return app;
}

/* Disables/Enables certain menuItems's when called */
void ShowMenu(BOOL on)
{
	DoMethod(app,MUIM_Application_SetMenuState, ID_NEW, 				on);
	DoMethod(app,MUIM_Application_SetMenuState, ID_MERGE,			 	on);
	DoMethod(app,MUIM_Application_SetMenuState, ID_SAVE,				on);
	DoMethod(app,MUIM_Application_SetMenuState, ID_SAVE_AS,			on);
	DoMethod(app,MUIM_Application_SetMenuState, ID_EXPORT_ASCII,on);
	DoMethod(app,MUIM_Application_SetMenuState, ID_TEST,				on);
}

void CheckActive(Object *list, APTR up, APTR down, APTR top, APTR bottom)
{
	BOOL bup,bdown,btop,bbottom;

	bup=bdown=btop=bbottom=FALSE;

	if(Active(list)==-1)
		bup=bdown=btop=bbottom=TRUE;
	else
	{
		if(Active(list)==0)
			bup=btop=TRUE;
		if(Active(list)==Count(list)-1)
			bdown=bbottom=TRUE;
	}

	set(up,			MUIA_Disabled, bup);
	set(down,		MUIA_Disabled, bdown);
	set(top,		MUIA_Disabled, btop);
	set(bottom,	MUIA_Disabled, bbottom);
}

int ShowDays(int month)
{
	BOOL bday30,bday31;
	int maxday=31;

	if(	month==1 || month==3	|| month==5		|| month==7 ||
			month==8 || month==10 || month==12	|| month==0)
		bday30=bday31=FALSE;
	else if(month==2)
	{
		bday30=bday31=TRUE;
		maxday=29;
	}
	else
	{
		bday30=FALSE;
		bday31=TRUE;
		maxday=30;
	}

	set(day[30], MUIA_Disabled, bday30);
	set(day[31], MUIA_Disabled, bday31);

	return maxday;
}


void SetWhenString(struct EventNode *node)
{
	char tmp1[40],tmp2[40],day[3],month[3],year[5],hh[3],mm[3];
	int tmpdate;

	if(node==NULL)
		return;

	// Checking if the the current string is equal to the last string.
	// If true, the string need not be updated and we just exit
	tmpdate=node->whendate +node->day  +node->month  +node->year+
					node->whentime +node->hour +node->minutes+
					node->days     +node->repeat + Active(eventlist)*22454;
	if(olddate==tmpdate)
		return;
	else
		olddate=tmpdate;

	if(node->day==0 & node->month==0 & node->year==0)
		strcpy(tmp1, "Whenever - ");
	else
	{
		if(node->day==0)
			strcpy(day,"**");
		else if(node->day<10)
			sprintf(day,"0%d",node->day);
		else
			sprintf(day,"%d",node->day);

		if(node->month==0)
			strcpy(month,"**");
		else if(node->month<10)
			sprintf(month,"0%d",node->month);
		else
			sprintf(month,"%d",node->month);

		if(node->year==0)
			strcpy(year,"****");
		else if(node->year<10)
			sprintf(year,"***%d",node->year);
		else if(node->year<100)
			sprintf(year,"**%d",node->year);
		else if(node->year<1000)
			sprintf(year,"*%d",node->year);
		else
			sprintf(year,"%d",node->year);

		sprintf(tmp1,"%s %s.%s.%s - ", clwhen[node->whendate],day,month,year);
	}

	if(node->hour==-1 & node->minutes==-1)
		strcpy(tmp2,"Anytime");
	else
	{
		if(node->hour==-1)
			strcpy(hh,"**");
		else if(node->hour<10)
			sprintf(hh,"0%d",node->hour);
		else
			sprintf(hh,"%d",node->hour);

		if(node->minutes==-1)
			strcpy(mm,"**");
		else if(node->minutes<10)
			sprintf(mm,"0%d",node->minutes);
		else
			sprintf(mm,"%d",node->minutes);

		sprintf(tmp2,"%s %s:%s", clwhen[node->whentime],hh,mm);
	}
	strcat(tmp1,tmp2);
	DoMethod(whenstring, MUIM_SetAsString, MUIA_Text_Contents, tmp1);
//	DoMethod(whenstring2, MUIM_SetAsString, MUIA_Text_Contents, tmp1);
}

void  ZeroDateTime(struct EventNode *node)
{
	node->hour=-1;
	node->minutes=-1;
	node->day=0;
	node->month=0;
	node->year=0;
	node->days=0;
	node->repeat=0;
}

void CurrentDateTime(struct EventNode *node)
{
	char buf[8];

	getclk(buf);
	node->day=buf[3];
	node->month=buf[2];
	node->year=buf[1]+1980;
	node->hour=buf[4];
	node->minutes=buf[5];
}

struct Window *GetWinPtr(APTR WI_Any)
{
	struct Window *Window=NULL;

	get(WI_Any, MUIA_Window_Window, &Window);
	return Window;
}

struct EventNode *ActivateFirst(Object *list)
{
	struct EventNode *node;

	set(list, MUIA_List_Active, MUIV_List_Active_Top);
	DoMethod(list, MUIM_List_GetEntry, Active(list), &node);
	if(node!=NULL)
		UpdateData(node);
	ShowGadgets();
	set(window, MUIA_Window_ActiveObject, eventstring);

	return node;
}

void ShowGadgets(void)
{
	BOOL	flag=FALSE;
	ULONG	eventtype=0;

	get(type, MUIA_Cycle_Active, &eventtype);

	CheckActive(eventlist,	eventup,	eventdown,	eventtop,	eventbottom);
	CheckActive(textlist,		textup,		textdown,		NULL,			NULL);

	if(Active(eventlist)==MUIV_List_Active_Off)
	{
		set(eventstring, MUIA_String_Contents, "");
		DoMethod(textlist,MUIM_List_Clear);
		DoMethod(	whenstring, MUIM_SetAsString,
							MUIA_Text_Contents, "Whenever - Anytime");
		flag=TRUE;
	}
	set(copyevent,		MUIA_Disabled, flag);
	set(deleteevent,	MUIA_Disabled, flag);
	set(addtext,			MUIA_Disabled, flag);
	set(edit,					MUIA_Disabled, flag);
	set(type,					MUIA_Disabled, flag);
	set(show,					MUIA_Disabled, flag);
	ShowMenu(!flag);

	if(Count(eventlist)!=0)
		set(eventstring,  MUIA_Disabled, FALSE);
	else
		set(eventstring,  MUIA_Disabled, TRUE);

	if(addtextflag | Active(textlist)!=MUIV_List_Active_Off)
		set(textstring,  MUIA_Disabled, FALSE);
	else
		set(textstring,  MUIA_Disabled, TRUE);

	flag=FALSE;
	if(Count(eventlist)==0)
		flag=TRUE;
	set(purgeevent,		MUIA_Disabled, flag);
	set(save,					MUIA_Disabled, flag);
	set(test,					MUIA_Disabled, flag);

	flag=FALSE;
	if(Active(textlist)==MUIV_List_Active_Off)
		flag=TRUE;
	set(copytext,			MUIA_Disabled, flag);
	set(deletetext,		MUIA_Disabled, flag);

	set(sortevent,MUIA_Disabled, (Count(eventlist)<2 ? TRUE:FALSE));
	set(sorttext,	MUIA_Disabled, (Count(textlist) <2 ? TRUE:FALSE));
	set(getfile,	MUIA_Disabled, (Active(textlist)>MUIV_List_Active_Off &&
			eventtype==2) ? FALSE :TRUE );
/*
	if(eventtype==2 | Active(eventlist)==MUIV_List_Active_Off)
		set(calc,					MUIA_Disabled, TRUE);
	else
		set(calc,					MUIA_Disabled, FALSE);
*/
	flag=FALSE;
	if(Active(eventlist)==MUIV_List_Active_Off)
		flag=TRUE;

	set(editwin, MUIA_Window_Sleep, flag);
/*
	set(whendate,			MUIA_Disabled, flag);
	set(whentime,			MUIA_Disabled, flag);
	set(hour,					MUIA_Disabled, flag);
	set(year,					MUIA_Disabled, flag);
	set(hour,					MUIA_Disabled, flag);
	set(minutes,			MUIA_Disabled, flag);

	set(editnow,			MUIA_Disabled, flag);
	set(editclear,		MUIA_Disabled, flag);

	for(i=0; i<=31; i++)
		set(day[i],	MUIA_Disabled, flag);
*/
}

void UpdateData(struct EventNode *eventnode)
{
	struct List *list=eventnode->textlist;
	struct Node *node;

	if(eventnode==oldnode)
		return;

	set(type,			MUIA_Cycle_Active,		eventnode->type);
	set(show,			MUIA_Cycle_Active,		eventnode->show);
	set(calc,			MUIA_Cycle_Active,		eventnode->calc);

	set(eventstring, MUIA_String_Contents, eventnode->name);
	set(editwin, MUIA_Window_ActiveObject, day[eventnode->day]);
	set(month,		MUIA_Cycle_Active,		eventnode->month);
 	set(year, 		MUIA_String_Integer,	eventnode->year);
	set(days,			MUIA_String_Integer,	eventnode->days);
	set(repeat,		MUIA_String_Integer,	eventnode->repeat);
	set(whendate, MUIA_Cycle_Active,		eventnode->whendate);
	set(whentime, MUIA_Cycle_Active,		eventnode->whentime);
	set(hour,			MUIA_Prop_First,			23-eventnode->hour);
	set(minutes,	MUIA_Prop_First,			59-eventnode->minutes);

	if(eventnode!=oldnode)
	{
		set(textlist, MUIA_List_Quiet, TRUE);
		DoMethod(textlist, MUIM_List_Clear);
		for(every_node)
			DoMethod(textlist, MUIM_List_Insert, &(node->ln_Name), 1, MUIV_List_Insert_Bottom);
		set(textlist, MUIA_List_Quiet, FALSE);

		SetWhenString(eventnode);
		ShowDays(eventnode->month);
	}
}
