/*
 *	File:					Config.h
 *	Description:	Defines the different structures of configurations
 *
 *	(C) 1993, Ketil Hunn
 *
 */

#define	every_node	node=list->lh_Head;node->ln_Succ;node=node->ln_Succ

extern APTR app,window;

struct GlobalConfig {
	BOOL	centrerequesters;
	BOOL	groupevents;
	BOOL	flashscreen;
	BOOL	ack_events;
	BOOL	ack_alerts;
	BOOL	autodelete;
	BOOL	confirm;
	BOOL	autoopencalendar;
	BOOL	usereqtools;
	int		sortby;
} globalConfig;


struct GlobalNode {
	struct Node nn_Node;
	char				eventname[30];
	short				whendate;
	char				date[7];		// V1.4
	char				sort[7];		// V1.4
	short				day;
	short				month;
	int					year;
	short				whentime;
	char				time[6];		// V1.4
	short				hour;
	short				minutes;
	int					days;
	int					repeat;
	short				type;
	short				show;
	short				calc;
	struct List	*textlist;
};


struct GlobalNode *AddEvent(struct List *list, char *name)
{
	struct GlobalNode	*eventnode;

	if(!(eventnode=AllocMem(sizeof(struct GlobalNode),MEMF_CLEAR)))
		printf("Out of memory\n");
	else {
		strcpy(eventnode->eventname,name);
		eventnode->nn_Node.ln_Name=eventnode->eventname;
		eventnode->nn_Node.ln_Type=100;
		eventnode->nn_Node.ln_Pri =0;

		if (!( eventnode->textlist = AllocMem(sizeof(struct List),MEMF_CLEAR)) )
			printf("Out of memory\n");
		else
			NewList(eventnode->textlist);

		AddTail(list,(struct Node *)eventnode);
	}
	return eventnode;
}

struct Node *AddText(struct List *list, char *name)
{
	struct Node *node;

	if(node = AllocMem(sizeof(struct Node),MEMF_CLEAR))
	{
		node->ln_Name = strdup(name);
		node->ln_Type = 100;
		node->ln_Pri  = 0;
		AddTail(list,node);
	}
	return node;
}

void FreeTextList(struct List *list)
{
	struct Node *node;

	while(!IsListEmpty(list))
	{
		node=list->lh_Head;
		RemHead(list);
		FreeMem(node, sizeof(struct Node));
	}
}

void FreeEventList(struct List *list)
{
	struct GlobalNode *current;

	while(!IsListEmpty(list))
	{
		current=(struct GlobalNode *)(list->lh_Head);
		FreeTextList(current->textlist);
		FreeMem(current->textlist, sizeof(struct List));
		RemHead(list);
		FreeMem(current, sizeof(struct GlobalNode));
	}
}
