/*
 *	File:					Converter.c
 *	Description:	Program to convert a Recall project to different formats.
 *	Version:			1.0
 *	Author:				Ketil Hunn
 *	Mail:					hunn@dhmolde.no
 *								ketil@lyr.dhmolde.no
 *
 *	Copyright  1993 Ketil Hunn.  Please read the document for further
 *	information and copyrights.
 *
 *	In order to list the source-files included in this package properly,
 *	the TAB size should be set at 2.
 *
 */

#include <MUI.h>
#include "Escapes.h"
#include "Version.h"

#include "GUI_Converter.h"
#include <exec/memory.h>
#include "GlobalConfig.h"
#include "MyRequest().h"

short reqType=MUI_TYPE;

#include "Config14.h"
#include "Config20.h"
#include "ASCII.h"
#include "GetFile().h"

/* PROTOTYPES */
BOOL Exists(char name[256]);
void CheckReady(char source[256], char destination[256]);
BOOL Convert(long intype, char *source, long outtype, char *destination);

struct FileRequester *aslreq=NULL;

#define TEMPLATE "INTYPE/A,FILE1/A,OUTTYPE/A,FILE2/A"
BOOL noargs=TRUE;

main()
{
	ULONG	signals;
	BOOL	running=TRUE, getfileflag=FALSE;
	char *source, *destination;
	struct RDArgs		*args=NULL;
	LONG						arg[5];

	// Using standar AmigaDOS parsing routines
	if(args=ReadArgs(TEMPLATE, arg, NULL))
	{
		char *dummy;
		long intype =strtol((UBYTE *)arg[0], &dummy, 10);
		long outtype=strtol((UBYTE *)arg[2], &dummy, 10);
		noargs=FALSE;

		Convert(intype, (UBYTE *)arg[1], outtype, (UBYTE *)arg[3]);
		FreeArgs(args);
		exit(0);
	}

	if(app=SetupGUI())
	{
		if(aslreq=MUI_AllocAslRequestTags(ASL_FileRequest,TAG_DONE))
		{
			if((source=malloc(FNSIZE)) && (destination=malloc(FNSIZE)))
			{
				strcpy(source, DEFSOURCE);
				strcpy(destination, DEFDESTINATION);
				set(sourceString, MUIA_String_Contents, source);
				set(destinationString, MUIA_String_Contents, destination);

				CheckReady(source,destination);
				set(window, MUIA_Window_Open, TRUE);
				set(window, MUIA_Window_ActiveObject, sourceString);

				while(running)
				{
					switch(DoMethod(app, MUIM_Application_Input, &signals))
					{
						case MUIV_Application_ReturnID_Quit:
							running=FALSE;
							break;

						case ID_ABOUT:
							MUI_Request(app, window, 0, NULL, "*OK",
													aCENTRE aLIGHT
													CONVERTERNAME " " VERSION2 " " COPYRIGHT ".\n\n"
													aNORMAL aDARK
													"Program for converting a " PROGNAME " project\n"
													"to different formats.\n\n"
													"Placing the pointer over a gadget and pressing\n"
													"HELP will pop up help on that function.\n\n"
													"This program is Public Domain.\n"
													"Compiled on " CURRENT_DAY ", " CURRENT_DATE);
							break;

						case ID_GETSOURCE:
							getfileflag=TRUE;

						case ID_SOURCESTRING:
							if(getfileflag)
							{
								if(GetFile(GetWinPtr(window),
												aslreq,
												"Select Source File...",
												source,
												""))
									set(window, MUIA_Window_ActiveObject, sourceString);
							}
							else
								get(sourceString, MUIA_String_Contents, &source);
							set(sourceString, MUIA_String_Contents, source);
							set(window, MUIA_Window_ActiveObject, destinationString);
							CheckReady(source,destination);
							getfileflag=FALSE;
							break;

						case ID_GETDESTINATION:
							getfileflag=TRUE;

						case ID_DESTINATIONSTRING:
							if(getfileflag)
							{
								if(GetFile(GetWinPtr(window),
												aslreq,
												"Select Destination File...",
												destination,
												""))
									set(window, MUIA_Window_ActiveObject, destinationString);
							}
							else
								get(destinationString, MUIA_String_Contents, &destination);
							set(destinationString, MUIA_String_Contents, destination);
							set(window, MUIA_Window_ActiveObject, sourceString);
							CheckReady(source,destination);
							getfileflag=FALSE;
							break;

						case ID_CONVERT:
							set(window, MUIA_Window_Sleep, TRUE);
							if(!Convert(Active(sourceListView), source,
													Active(destinationListView),destination))
								MUI_Request(app, window, 0, NULL, "*OK",
														"Not the correct loadmodule!");
							set(window, MUIA_Window_Sleep, FALSE);
							break;
					}

					if (running && signals)
						Wait(signals);
				}
				set(window,MUIA_Window_Open,FALSE);
				free(source);
				free(destination);
			}
			MUI_FreeAslRequest(aslreq);
		}
		fail(app,NULL);
	}
}

BOOL Exists(char name[256])
{
	FILE	*fp=NULL;
	BOOL	exists=FALSE;

	if(fp=fopen(name,"r"))
		exists=TRUE;
	fclose(fp);
	return exists;
}

void CheckReady(char source[256], char destination[256])
{
	if(Exists(source) && strlen(destination)>0 &&
												strcmp(destination, DEFDESTINATION))
		set(convert, MUIA_Disabled, FALSE);
	else
		set(convert, MUIA_Disabled, TRUE);
}

BOOL Convert(long intype, char *source,
																long outtype, char *destination)
{
	struct List		*list=NULL;
	BOOL success=FALSE;

	if(list=AllocMem(sizeof(struct List), MEMF_CLEAR))
	{
		NewList(list);

		switch(intype)
		{
			case LOAD_ASCII:
				success=ReadASCII(list, source);
				break;

			case LOAD_V1X:
				success=ReadPrefs14(list, source);
				break;

			case LOAD_V20:
				success=ReadIFF(list, source);
				break;
/*
			default:
				printf("Wrong source type: %d\n", intype);
				break;
*/
		}

		if(success)
		{
			switch(outtype)
			{
				case SAVE_ASCII:
					WriteASCII(list, destination);
					break;

				case SAVE_V20:
					WriteIFF(list, destination);
					break;
/*
				default:
					printf("Wrong destination type: %d\n", outtype);
					break;
*/
			}
		}
		FreeEventList(list);
		FreeMem(list, sizeof(struct List));
	}
	if(success && noargs)
		MyRequest("Conversion was successfull!", "OK", "");
	return success;
}
