/*
 *	File:					Config14.h
 *	Description:	Reads the project in V1.x format
 *
 *	(C) 1993, Ketil Hunn
 *
 */

#define CONFIGHEADER	"Recall V1.x  Ketil Hunn"

struct Config14 {
	char	header[25];
	BOOL	CreateIcons,CentreRequesters;
	int		Dateformat,Sortby;
};

struct EventNode14 {
	struct Node nn_Node;
	char				eventname[30];
	short				prefixdate;
	char				date[7];
	char				sort[7];
	short				prefixtime;
	int					days;
	int					repeat;
	char				time[6];
	short				type;
	short				show;
	short				calctype;
	short				DD;
	short				MM;
	short				YY;
	BOOL				ask;
	short				lines;
	struct List	*textlist;
};

struct TextNode14 {
	char text[69];
};

BOOL ReadPrefs14(struct List *list, char *source)
{
	struct EventNode14	event;
	struct GlobalNode		*current;
	struct Config14			header;
	FILE								*fp;
	BOOL								success=FALSE;
	struct TextNode14		textnode;
	char tmp[3],*dummy;

	if(fp=fopen(source,"r"))
	{
		if(fread(&header,1,sizeof(header),fp)==sizeof(header))
		{
			if(stricmp(CONFIGHEADER,header.header)==0)
			{
				globalConfig.centrerequesters=header.CentreRequesters;
				globalConfig.sortby=header.Sortby;

				while(!feof(fp))
				{
					if(fread(&event,1,sizeof(event),fp)==sizeof(event))
					{
						current=AddEvent(list, event.eventname);
						current->whendate		=event.prefixdate;

						if(strmid(event.date,tmp,1,2)==0)
						{
							current->day=strtol(tmp,&dummy,10);
							if(strmid(event.date,tmp,3,2)==0)
							{
								current->month=strtol(tmp,&dummy,10);
								if(strmid(event.date,tmp,5,2)==0)
									current->year=strtol(tmp,&dummy,10);
								if(current->year>0)
									current->year+=1900;
							}
						}
						current->whentime		=event.prefixtime;
						current->days				=event.days;
						current->repeat			=event.repeat;

						if(strmid(event.time,tmp,1,2)==0)
						{
							current->hour=strtol(tmp,&dummy,10);
							if(strmid(event.time,tmp,3,2)==0)
								current->minutes=strtol(tmp,&dummy,10);
						}
						current->type				=event.type;
						current->show				=event.show;
						current->calc				=event.calctype;

						while(event.lines--)
						{
							fread(&textnode,1,sizeof(textnode),fp);
							AddText(current->textlist,textnode.text);
						}
						success=TRUE;
					}
				}
			}
			else
			{
				MUI_Request(app, window, 0, NULL, "*I guess not...",
										"The loaded configuration is not\n"
										"a V1.x configuration!");
				success=FALSE;
			}
		}
	}
	fclose(fp);
	return success;
}
/*
void FreeTextList(struct List *list) {
	struct Node *node;

	while(!IsListEmpty(list)) {
		node=list->lh_Head;
		RemHead(list);
		FreeMem(node,sizeof(struct Node));
	}
}

void FreeEventList(struct List *list) {
	struct EventNode *current;

	while(!IsListEmpty(list)) {
		current=(struct EventNode *)(list->lh_Head);
		FreeTextList(current->textlist);
		FreeMem(current->textlist,sizeof(struct List));
		RemHead(list);
		FreeMem(current,sizeof(struct EventNode));
	}
}
*/