/*
 *	File:					ASCII.h
 *	Description:	Read and write a Recall project in ASCII format.
 *
 *	(C) 1993, Ketil Hunn
 *
 */

int GetText(FILE *fp, char s[])
{
	int c, i=0, lim=FNSIZE;

	while((c=fgetc(fp))!=EOF && c!='\n' && c!=',' && --lim>0)
		if(c!='"')
			s[i++]=c;

	s[i]='\0';
	return c;
}

LONG GetNumber(FILE *fp, short *num)
{
	int c, i=0, lim=FNSIZE;
	char s[10], *dummy;

	while((c=fgetc(fp))!=EOF && c!='\n' && c!=',' &&
				 c!='.' && c!=':' && --lim>0)
		if(c!='"')
			s[i++]=c;

	s[i]='\0';
	num=(short *)strtol(s, &dummy,10);
	return c;
}

BOOL ReadASCII(struct List *list, char *destination)
{
	FILE *fp;
	struct GlobalNode *globalnode;
	BOOL success=FALSE;
	char text[FNSIZE];
	short num=0;

	if(fp=fopen(destination, "r"))
	{
		while(GetText(fp, text)!=EOF)
		{
			globalnode=AddEvent(list, text);
			GetNumber(fp, &num); globalnode->day	=num;
			GetNumber(fp, &num); globalnode->month=num;
			GetNumber(fp, &num); globalnode->year	=num;
			GetNumber(fp, &num); globalnode->hour	=num;
			if(GetNumber(fp, &num)!='\n')
			{
				globalnode->minutes=num;
				while(GetText(fp, text)!='\n')
					AddText(globalnode->textlist, text);
				AddText(globalnode->textlist, text);
			}
			success=TRUE;
		}
		fclose(fp);
	}
	return success;
}



void WriteASCIITexts(FILE *fp, struct List *list)
{
	struct Node *node;

	for(every_node)
		fprintf(fp,",\"%s\"", node->ln_Name);
	fprintf(fp, "\n");
}


BOOL WriteASCII(struct List *list, char *destination)
{
	FILE *fp;
	struct Node *node;
	struct GlobalNode *globalnode;
	BOOL success=FALSE;

	if(fp=fopen(destination, "w"))
	{
		for(every_node)
		{
			globalnode=(struct GlobalNode *)node;
			fprintf(fp,"\"%s\",\"%d.%d.%d\",\"%d:%d\"",
							globalnode->eventname,
							globalnode->day, globalnode->month, globalnode->year,
							globalnode->hour,globalnode->minutes);
			WriteASCIITexts(fp, globalnode->textlist);
		}
		fclose(fp);
		success=TRUE;
	}
	return success;
}
