/* BBS Reply Message Reflow: Places text within 72-column margin;
        keeps "XX>" initials format if present, as appropriate */
Arg filename
if queued() <> 0 then do
    if stream(filename,'c','query exists') <> '' then do
       say 'Cannot dump to existing file!'
       exit 99
     end
 end
 else '@rxqueue /clear & rxqueue<'filename  /*Put source file in queue*/
If queued() <> 0 Then   Do
    /* Find initials if any */
    Parse Pull one
    If translate(left(one, 2))'>'=left(one, 3) Then initials=left(one,2)
    /*Took line one to get initials; push back for "normal" processing*/
    Push one
  End
Call Lineout  filename,, 1    /*Reset file*/



Do While queued() <> 0
  Parse Pull line
  If left(line, 3) <> initials'>' Then   Drop initials
  line = strip(line, 'Trailing')
  If length(line) > 72 Then  Do
      break = lastpos(' ', left(line, 72))
      If break = 0 Then  Do
          /*Extremely long word -- no break before 73, so we force one*/
          Call lineout  filename, left(line, 72)
          line = substr(line, 73)
       End
       Else   Do
          /*"Normal" long line, break after last word to fit in margin*/
          Call lineout  filename, left(line, break - 1)
          line = substr(line, break + 1)
       End
      /*We are left with "line" consisting of the too-long portion*/
      If symbol('initials') = 'VAR' Then   line = initials'>'line


      If length(line) <= 72 & queued() <> 0 Then  Do
          /*Normal case: line too long by small amount*/
          Parse Pull newline

          If symbol('initials') = 'VAR' Then  Do
              If left(newline, 3) <> initials'>',
                 /*We don't concatenate if stopped initials right here*/,
               | strip(newline) = initials'>' Then  Push newline
                 /*or if "blank" line (discounting the initials)*/
               Else  line = line substr(newline, 4)  /*Concatenate*/
           End    /*Concatenation in "initials" mode*/

           Else   /*Not in initials mode*/
             If strip(newline) = '' Then Push newline
                /*Don't concatenate blank line*/
              Else line = line newline /*Usually we do concatenate*/
        End   /*Normal long line (only a little extra, so concatenate)*/

      Push line  /*Concateanted or not, push our "remainder" line*/
   End


   Else  Call lineout  filename, line  /*When not a long line (simple)*/
 End   /*Do while there is still a line in the queue*/
Call LineOut filename
return 0
