/* REXX to program to READ messages from OS/2 EEP BBS

   READBBS 0.07  (c) 1991, University of Missouri

   Written by: Rick Wilkeson
               Computer Programmer Analyst II
               Administrative Data Processing
               University of Missouri-Rolla
                  Internet: RICKW@UMRVMB.UMR.EDU



   DISCLAIMER:  This program is distributed "ASIS" no support is given.
   If you locate a bug you can send be a note, but I don't know when I could
   work on fixing it...But you can modify the program yourself.  If you
   do modify this code please give credit where credit is due.  Also, all
   rights are retained by the University of Missouri, so you can't sell it.

   I wrote this in a week, so if there are no bugs it will be a miracle.
   Also very little error checking is done.  If you try I'm sure you can
   cause it to crash.

   Note:
   Ansi screen routines written by:  Michael J Antonio
                                     (MikeA) 713221.1742@CompuServe.com

Revisions:  (Note, Since Rick has been busy, other users have undertaken
            to incorporate the best (IOHO) changes suggested by users
            and/or those that are more difficult to add.)
            Simple color changes have not been added since these are a matter
            of taste and are easily accomplished by the end user.

Date/Version

11/06/91 1.30 Incorporated 71 character reply wrapping and automatic
            signature file addition per Dave Holmstrom in Msgs 311,545
            in Base 20.  Author:  Don Babcock

11/29/91 1.40   User-defined variables, includes drive&path, editor name
           Elapsed time counter
           Merge new messages directly into old (index update)
           DUP duplicates index entries eliminated (during merge)
           Unknown conferences are added as "extended conferences"
           Improved main (conferences) prompt contains more info
           Main prompt allows direct entry of conference number
           Main prompt by default skips "extended conferences"
           Reply file extension is "true" conference number
           Improved error handling in config file (alphabetic lastreads)
           Checks for existing sent AND unsent replies
           Added "original message" information in message quoting
           Prompts to delete "null" (unchanged) replies
           Improved "72-column" message flowing incorporated
           Indexing function displays a message count
           Log file lists reply actions (create/delete) and time counter
           (Limited) error handling routine
           Closes files; avoids processing errors when calling programs
           Author: Dovid Gross

*/

Signal On syntax
Call Time 'E'

'@echo off'
Parse Arg params
If params='' | translate(params)='/H' then
   Call Usage
Parse Var params infile '+' update .
Parse Var infile infile .
Parse Var update update .
Call Init
Call Openfile
Call Indexfile
/*  File is open ready to read file */
readpos=stream(infile,'c','seek +0')
say 'Starting to write' outfile '-- elapsed:' time('e')
/*  Main conference loop */
curconf=1
do while curconf<=numconf
    if confer.curconf.count>0 then
       do
          ch='Y'
          select
             when ch='Y'|(ch='' & confer.curconf.num<1000) then
                do
                   lastmess=false
                   Call ReadConference
                end
             when ch='-' then
                do
                   if curconf>1 then
                      curconf=curconf-1
                   iterate
                end
             when ch='Q' |(ch='' & confer.curconf.num>999) then do
                 If ch='' Then Say 'Skipping extended conferences'
                 leave
                end
             when ch='N' | ch='+' then
                nop
             when DataType(GetCharLine)='NUM' then do
                /* Use GetCharLine, not ch, to get full response;
                   numbers can be more than one character, e.g., 1000 */
                 do i=1 To numconf
                    If confer.i.num <> GetCharLine then iterate
                    curconf=i
                    leave
                  end
                 iterate
               end
             otherwise
                 iterate
          end  /* select */
       end
    curconf=curconf+1
end /* do */
Call WriteConfigfile
say
Call AnsiSay(color.attention)
say 'Reading Complete.'||ansi.bblack||ansi.fwhite
call stream infile,'c','close'
call stream indexfile,'c','close'
call stream outfile,'c','close'
seconds=time('r')
hours=seconds% (60 * 60)
seconds=seconds-hours*60*60
minutes=seconds%60
seconds=seconds-minutes*60
elapsed='Spent' hours':'minutes':'seconds 'with READBBS'
call lineout logfile,elapsed
if stream(logfile,'state')<>'UNKNOWN' then do
    call LineOut logfile /* Close it */
    'type' logfile
  end /* do */
say elapsed
Exit


/* Get a character from STDIN: */
GetChar: Procedure Expose GetCharLine
GetCharLine=strip(Translate(LINEIN()))
Return left(GetCharLine,1)

/* Get a line from STDIN: */
GetLine: Procedure
input=linein()
Return input

/*  Initialize READBBS */
Init:
if symbol('editor')='LIT' then editor = 'e'
revision='0.07'
true=1
false=0
'ANSI ON >nul'
Ansi.=''
Call SetAnsi
/*  Check for command line options */
updating=update <> ''   /* "READBBS oldfilename + update" option */
params=translate(params)
If pos('/I',params)>0 then
   indexflag=true
else
   indexflag=false
If pos('/C',params)>0 then
   Parse Var params '/C' cfgfile
else
   cfgfile=''
If pos('NOLASTREAD',params)>0 | pos('NLR',params)>0 then
   nlrflag=true
else
   nlrflag=false
nlrflag=true
Parse Source os . prgfullname
pdrive=filespec('drive',prgfullname)
ppath=filespec('path',prgfullname)
pfname=filespec('name',prgfullname)
Parse Var pfname pfilename '.' pext
if cfgfile='' then cfgfile = pdrive || ppath || pfilename || '.CFG'
outfile = pdrive || ppath || pfilename || '.NEW'
logfile = pdrive || ppath || pfilename || '.LOG'
signature=pdrive || ppath || pfilename || '.SIG'

/* Read Config file */
cfgfile=strip(cfgfile)
rc = stream(cfgfile,'c','query exists')
If rc='' then
   do
      say 'Config file ('cfgfile') not found.'
      exit
   end
rc=stream(cfgfile,'c','open read')
If substr(rc,1,5)<>'READY' then
   do
      say 'Error opening' cfgfile 'for READ.'
      exit
   end
indata = linein(cfgfile)
if substr(indata,1,7)<>'READBBS' then
   do
      say 'Config file ('cfgfile') not in correct format.'
      exit
   end
do while lines(cfgfile)
    select
       when translate(substr(indata,1,12))= 'CONFERENCES:' then do 1
          Parse Upper Var indata 'CONFERENCES:' numconf .
          if datatype(numconf) <> 'NUM' then leave
          do i = 1 to numconf
              indata = linein(cfgfile)
              Parse Var indata confer.i.num confer.i.name '[' confer.i.lastread ']'
              if datatype(confer.i.lastread)<>'NUM' then
                confer.i.lastread=0
              confer.i.name=strip(confer.i.name)
           end /* do */
        end
       when translate(substr(indata,1,6))='COLOR:' then do
          do i = 1 to 6
             indata=linein(cfgfile)
             Parse Upper Var indata colortype foreground background
             color.fore.colortype=foreground
             color.back.colortype=background
             foreground='f'||strip(foreground)
             background='b'||strip(background)
             interpret 'color.'colortype'=ansi.'foreground'||ansi.'background
           end /* do */
        end /* do */
       when translate(substr(indata,1,5))='VARS:' then do 1
          parse upper var indata 'VARS:' uvars.0 .
          if datatype(uvars.0) <> 'NUM' then leave
          do i = 1 to uvars.0
             uvars.i = linein(cfgfile)
           end
          drop varname varvalue
        end
       otherwise
   end /* select */
   indata=linein(cfgfile)
end
rc = stream(cfgfile,'c','close')
mconf = 'Conference Not Found'
do confcnt=1 to numconf while mconf <> confer.confcnt.name
    nop
  end /* do */
if confcnt > numconf then do
    numconf=numconf+1
    confer.numconf.name  = mconf
    confer.numconf.num = '99'
  end
drive=filespec('drive',infile)
path=filespec('path',infile)
fname=filespec('name',infile)
Parse Var fname filename '.' ext
beginthreadidx=0
cont=1
ch =' '
messidx=0
if symbol('verbiage')='LIT' then verbiage=false

/*
** This last part sets up the user-defined variables read in earlier.
** The loop must be the last section of INIT code in order for user
** variables to affect values defined earlier in this init procedure.
*/
if datatype(uvars.0)='NUM' then do i = 1 to uvars.0
   parse var uvars.i varname '=' varvalue
   if words(varname)=1 & varvalue <> '' then interpret uvars.i
 end
return


/* Conference has been selected and ready to read messages */
ReadConference:
messidx=0
if \nlrflag & (confer.curconf.lastread >=confer.curconf.minidx & confer.curconf.lastread <= confer.curconf.maxidx) then
   do
      ch=confer.curconf.maxidx  /*Insurance if we don't have the */
      Call FindMessageNumber    /* new message (lastread+1)      */
      ch=confer.curconf.lastread+1
      Call FindMessageNumber
   end /* do */
do while cont
   select
      when ch='?' then
         do
            say ' [Number].......Goto closest specified message number.'
            say ' [+], [Return]..Display next message.'
            say ' [-]............Display previous message.'
            say ' [R]............Reply to current message.'
            say ' [T]............Search subject to find next matching message.'
            say ' [S]............Search subject for specified string.'
            say ' [L]............List message number and subject for current conference.'
            say ' [Q]............Quit messages'
            say ' [?]............Display this screen.'
            say
            say '[Return] to return to message.'
            junk=GetChar()
            Call DisplayMessage
         end
      when ch='R' then
         do
            Call ReplyMessage
            call DisplayMessage
         end /* do */
      when ch='T' then
         do
            if beginthreadidx=0 then
               beginthreadidx=messidx
            call SearchThread
            call GetNextMessage
            call DisplayMessage
         end /* do */
      when ch='S' then
         do
            Call SearchSubject
            Call GetNextMessage
            Call DisplayMessage
         end /* do */
      when ch='L' then
         do
            Call ListSubjects
            Call DisplayMessage
         end /* do */
      when datatype(ch)='NUM' then
         do
            say 'Searching for message number' strip(ch)'...'
            beginthreadidx=0
            Call FindMessageNumber
            Call GetNextMessage
            Call DisplayMessage
         end
      when ch='Q' then
         cont=0
      when ch='+' then
         do
            beginthreadidx=0
            if messidx<confer.curconf.count then
               messidx=messidx+1
            Call GetNextMessage
            Call DisplayMessage
         end /* do */
      when ch='-' then
         do
            If messidx<>1 then
               messidx=messidx-1
            beginthreadidx=0
            Call GetNextMessage
            Call DisplayMessage
         end
   otherwise
      do
         if lastmess then
            cont=false
         else
            do
               beginthreadidx=0
               if messidx<confer.curconf.count then
                  messidx=messidx+1
               Call GetNextMessage
               Call DisplayMessage
            end
      end
   end  /* select */

   nextline='** Message('mess.curconf.messidx.num') **'
   If lastmess then
      nextline=nextline || color.attention||' Last message in' confer.curconf.name
   if lastmess then ch='Q'  /*back to conference loop*/
   else ch='+'  /*force read of next message*/
   If ch='Q' | (lastmess & ch='') then
      return
end
Return

/* Search subject lines for IDENTICAL subject */
SearchThread:
cursubject=mess.curconf.messidx.subject
conf=confer.curconf.name
say 'Searching' strip(conf)'...'
Do i = messidx+1 to confer.curconf.count
   If mess.curconf.i.subject=cursubject then
      do
         messidx=i
         return
      end /* do */
end /* do */
say 'No more message in thread.  Returning to start of thread.'
say '---More---'
ch=GetChar()
rc = stream(infile,'c','seek ='mess.curconf.beginthreadidx.pos)
messidx=beginthreadidx
beginthreadidx=0
return

/*  Search Subject lines for phrase */
SearchSubject:
saveidx=messidx
if symbol('srchsubject')='LIT' then
   srchsubject='**No Phrase**'
say 'Enter Phrase to search on: [Return] for "'srchsubject'"'
ssubject=GetLine()
if ssubject<>'' | srchsubject='**No Phrase**' then
   srchsubject=ssubject
srchsubject=translate(srchsubject)
conf=confer.curconf.name
say 'Searching' strip(conf) 'for "'srchsubject'"...'
Do i = messidx+1 to confer.curconf.count
   If pos(srchsubject,translate(mess.curconf.i.subject))<>0 then
      do
         messidx=i
         return
      end /* do */
end /* do */
say 'Subject Phrase Not Found.'
say '---More---'
/*Pull ch*/
ch=GetChar()
rc = stream(infile,'c','seek ='mess.curconf.saveidx.pos)
return

FindMessageNumber:
do i=1 to confer.curconf.count while mess.curconf.i.num<ch
end /* do */
If i<=confer.curconf.count then
   do
      messidx=i
      Call GetNextMessage
   end /* do */
else
   do
      say color.attention||'Message number' ch 'not found in' confer.curconf.name'.'
      say 'Press [Return] to continue.'
      /*pull junk*/
      junk=GetChar()
   end
return

GetNextMessage:
rc=stream(infile,'c','seek ='mess.curconf.messidx.pos)
if rc<>mess.curconf.messidx.pos then
   do
      say 'Error in index file.'
      say 'Tried to move to position' mess.messidx.pos'.'
      say 'rc=' rc
      exit
   end /* do */
indata=linein(infile)
do while lines(infile)
   Parse Var indata '****' conf '****'
   if conf<>'' then
      return
   if substr(indata,1,9)='Message :' then
      do
         header.1=indata
         do i=2 to 5
            header.i=linein(infile)
         end /* do */
         i=1
         indata=linein(infile)
         do while lines(infile) & substr(indata,1,9)<>'Message :'
            message.i = indata
            indata=linein(infile)
            i=i+1
         end /* do */
         messagelength=i-1

         return
      end /* do */
   indata=linein(infile)
end
return

DisplayMessage:
say 'Message' mess.curconf.messidx.num'.'curconf 'to' outfile'.'
lastmess=false
If mess.curconf.messidx.num=confer.curconf.maxidx then
   lastmess=true
do i=1 to 5
   call lineout outfile,header.i
end /* do */
j=5
do i=1 to messagelength
   if j>21 then
      do
         say '--More-- [Return] to continue, [Q]uit'
         /*PULL ch*/
         ch=GetChar()
         if ch='Q' then
            return
         j=1
      end
   Parse Var message.i '****' mconf '****'
   if mconf <>'' then
      do
         do k=1 to numconf
            if mconf=confer.k.name then
               return
         end /* do */
         call lineout outfile, message.i
      end /* do */
   else
      call lineout outfile,message.i
end /* do */
confer.curconf.lastread=mess.curconf.messidx.num
return

ListSubjects:
say
say 'Listing Subject for' confer.curconf.name
say
say 'Num  Subject                      From                To'
say copies('-',79)
do i =1 to confer.curconf.count
   if i//21=0 then
      do
         say '---More--- [Return] to continue, [Q]uit'
         /*pull junk*/
         junk=GetChar()
         If junk='Q' then
            return
         say 'Num  Subject                      From                To'
         say copies('-',79)
      end
   lineout=copies(' ',79)
   lineout=overlay(mess.curconf.i.num||'  '||mess.curconf.i.subject,lineout,1)
   lineout=overlay(mess.curconf.i.from,lineout,35)
   lineout=overlay(mess.curconf.i.to,lineout,55)
   say lineout
end /* do */
say 'Press [Return] to return to message.'
/*pull junk*/
junk=GetChar()
return

ReplyMessage:
Parse Var header.1 'Message :' replynum .
outfile=drive||path||'REP' || strip(replynum) ||'.'||confer.curconf.num
oldfile=drive||path||'SEP' || strip(replynum) ||'.'||confer.curconf.num
Say 'Setting up reply edit file' outfile'. . .'
rc=stream(outfile,'c','query exist')    /* check for existing reply */
if rc <>'' then do
    Call AnsiSay 'Reply file' outfile 'exists; replace? y/N: '
    if GetChar() = 'Y' Then Do
          'erase' outfile
          Call CreateQuote
          Call LineOut logfile, 'REPLACEMENT' Result
     end  /* do if reset (replace) */
  end /* do if reply exists */
  else do  /*No existing reply, create from scratch*/
    rc=stream(oldfile,'c','query exist')   /* check for an sent reply */
    if rc <>'' then do
        Call AnsiSay,
          'UPLOADED Reply file' outfile 'exists; continue? y/N: '
        if getChar() <> 'Y' then return
        else do
          'erase' oldfile
          if rc<>0 then do
             say 'Could not erase old file; aborting'
             call getChar
             call lineout logfile, 'Uneraseable' oldfile,
                'prevented reply' outfile
             return
           end
          call charout logfile, 'ADDITIONAL '
        end  /* sent (old) reply file does exist */
      end /* check if old sent reply exists */
     /*
     ** Now, there is no existing reply, and if an old reply existed,
     ** user has confirmed that we should still create a new reply
     */
     Call LineOut logfile, CreateQuote()
   end

/* At this point we have a reply file (either fresh, or "re-use")*/
hash=stream(outfile,'c','query datetime'),
    stream(outfile,'c','query size')
Call On Failure Name BadEdit  /* in case user editor is no good */
''editor outfile
Signal Off Failure
if hash=stream(outfile,'c','query datetime'),
    stream(outfile,'c','query size') then do
    Say ansi.attention'You have not changed the file! [D]elete/[k]eep?'
    if getChar() <> 'K' then do
       'erase' outfile
       call lineout logfile, 'Deleted null reply' outfile
     end
  end
  else call reflow outfile
return

Badedit:     /*If couldn't call user-defined editor, try E.EXE*/
if Translate(editor)<>'E' & Translate(editor)<>'E.EXE' then 'e' outfile

CreateQuote: Procedure Expose,
    outfile signature,
    header. message. replynum confer. curconf messagelength
/*rc = stream(outfile,'c','open write') -- using q */
'rxqueue /clear'
Parse Var header.2 'From... :' first last .
initials= substr(first,1,1)||substr(last,1,1)
parse var header.2 . 'Refer.. : ' orignum .
parse var header.3 . 'To..... : ' origfirst origlast .
original=origfirst origlast
if datatype(orignum)='NUM' then original=original '#'orignum

push initials'> Reply to',
    first last '#'replynum '(originally to' original')'
do i = 1 to messagelength
    outdata = initials||'>'||message.i
    queue outdata
    /*call lineout outfile,outdata -- using q */
  end /* do */
if symbol('signature')='VAR' then 'rxqueue <'signature
rc=reflow(outfile)
if rc <> 0 then 'rxqueue /clear'
return 'Reply file' outfile 'in' confer.curconf.name,
    'to' first last '(addressed' original')'


Openfile:
If infile='' then
   do
      say '*** No mail file specified.***'
      call usage
      exit
   end
rc = stream(infile,'c','query exists')
If rc='' then
   do
      say infile 'does not exist.'
      exit
   end /* do */
fullname = stream(infile,'c','open read')
If substr(fullname,1,5)<>'READY' then
   do
      say 'Error opening' infile
      exit
   end /* do */
'if exist' logfile 'erase' logfile
if lineout(logfile,,1) then do
    say 'Could not open session log file' logfile
    say 'Press [Return] to continue.'
    call getChar
  end /* do */
if ''=stream(signature,'c','query exists') then drop signature
'if exist' logfile 'erase' outfile
if lineout(outfile,,1) then do
    say 'Could not open output compaction file' outfile
    exit 99
  end /* do */
if ''=stream(signature,'c','query exists') then drop signature
return

Indexfile:
indexfile=drive||path||filename||'.idx'
indexexists=stream(indexfile,'c','query exists')
If indexexists=''| indexflag then
   do
      say 'Cannot compact message file witout index!'
      exit 99
      if updating then do
          Say 'Update operation is not possible without existing index.'
          exit
        end
      Say 'Creating index file...Please wait...'
      Call Reindex
   end /* do */
else
   say 'Reading index file...'
rc=stream(indexfile,'c','close')
rc=stream(indexfile,'c','open read')
Call ReadIndex
rc=stream(indexfile,'c','close')
if updating then do
   say 'Cannot update when compacting!'
   exit 99
   say 'Merging new file and updating index file...'
   call ReIndex
 end
return

ReadIndex:
indata=linein(indexfile)
Parse Var indata prgname prgver ofilesize '-' odatetime
If prgname <>'READBBS' then
   do
      say indexfile 'not in correct format.'
      exit 99
   end /* do */
filesize=stream(infile,'c','query size')
datetime=stream(infile,'c','query datetime')
if ofilesize <> filesize | datetime <> odatetime then
   do
      say 'Cannot compact message file with outdated index!'
      exit 99
      if updating then do
          say infile 'does not match' indexfile'.'
          Say 'Cannot perform update operation with outdated index.'
          exit
        end
      say infile 'does not match' indexfile'.  Re-Createing index...'
      Call Reindex
      rc=stream(indexfile,'c','close')
      rc=Stream(indexfile,'c','open read')
      indata=linein(indexfile)
   end
Do i=1 to numconf while lines(indexfile)
   indata=linein(indexfile)
   Parse Var indata '['confer.i.name']['confer.i.count']['confer.i.minidx']['confer.i.maxidx']'
   j=0
   Do k=1 to confer.i.count while lines(indexfile)
      indata=linein(indexfile)
      if substr(indata,1,3)<>'DUP' then
         do
            j=j+1
            Parse Var indata '   ['mess.i.j.pos']['mess.i.j.num']['mess.i.j.subject']['mess.i.j.date']['mess.i.j.to']['mess.i.j.from']'
         end
   end
   confer.i.count=j
end
return

reindex:
extend=false
if updating then do
       Call Stream infile, 'c', 'close'
       Call Stream infile, 'c', 'open'
       Call Stream infile, 'c', 'seek <0'
  end /* if do */
  else do
    update=infile
    do i=1 to numconf
       confer.i.maxidx=0
       confer.i.minidx=0
       confer.i.count=0
     end /* do: reset each conference */
  end /* else do */
messcnt=0
say '   Reading Message Headers...'
readpos=stream(infile,'c','seek +0')
datain=linein(update)
do while lines(update)
      if updating then Call lineout infile, datain
      if substr(datain,1,9)='Message :' then
         do
            header.1=datain
            do i=2 to 4
               header.i=linein(update)
               if updating then Call lineout infile, header.i
            end /* do */
            Parse Var header.1 'Message :' mnum  mconf 'Date... :' mdate '(' .
            Parse Var header.2 'From... :' mfrom 'Refer'
            Parse Var header.3 'To..... :' mto "Sec'ty"
            Parse Var header.4 'Subject :' msubject "Rec'vd" .
            mconf=strip(mconf)
            mconf=strip(substr(mconf,2,length(mconf)-2))
            do confcnt=1 to numconf while mconf <> confer.confcnt.name
               nop
            end /* do */
            if confcnt > numconf then do
                /* Conference not listed! */
                confnum = max(1000,confer.numconf.num+1)
                confer.confcnt.num = confnum
                confer.confcnt.name = mconf
                confer.confcnt.lastread = 0
                confer.confcnt.count = 0
                confer.confcnt.maxidx = 0
                confer.confcnt.minidx = 0
                if \extend then do
                   extend=true
                   say '[Started with' numconf 'conferences; note:]'
                 end
                numconf = confcnt
                Say '	Conference' mconf 'added as #'confnum
              end
            if updating & verbiage then say ,
                '	Merging #'mnum 'of' mconf 'at' readpos
            confer.confcnt.count=confer.confcnt.count+1
            messcnt=confer.confcnt.count
            mess.confcnt.messcnt.num=mnum
            mess.confcnt.messcnt.subject=msubject
            mess.confcnt.messcnt.date = strip(mdate)
            mess.confcnt.messcnt.to = strip(mto)
            mess.confcnt.messcnt.from= strip(mfrom)
            mess.confcnt.messcnt.pos=readpos
            If mess.confcnt.messcnt.num < confer.confcnt.minidx | confer.confcnt.minidx=0 then
               confer.confcnt.minidx=mess.confcnt.messcnt.num
            If mess.confcnt.messcnt.num > confer.confcnt.maxidx | confer.confcnt.maxidx=0 then
               confer.confcnt.maxidx=mess.confcnt.messcnt.num
            DROP header.
         end /* do */
   readpos=stream(infile,'c','seek +0')
   datain=linein(update)
end /* do */
if updating then do
       Call Stream infile, 'c', 'close'
       Call Stream infile, 'c', 'open read'
  end /* if do */
say '   Sorting Messages...'
Call SortConfers
say '   Writing Index File...'
filesize=stream(infile,'c','query size')
datetime=stream(infile,'c','query datetime')
if indexexists<>'' then
   do
      rc=stream(indexfile,'c','close')
      'del' indexfile
   end
rc=stream(indexfile,'c','open write')
Call lineout indexfile,'READBBS' revision filesize '-' datetime
indexcount=0
do i=1 to numconf
   Call lineout indexfile,'['confer.i.name']['confer.i.count']['confer.i.minidx']['confer.i.maxidx']'
   If verbiage then Call AnsiSay i confer.i.name
   savenum=0
   do j=1 to confer.i.count
      if mess.i.j.num<>savenum then
         do
            Call lineout indexfile,'   ['mess.i.j.pos']['mess.i.j.num']['strip(mess.i.j.subject)']['mess.i.j.date']['mess.i.j.to']['mess.i.j.from']'
            savenum=mess.i.j.num
            if verbiage then Call AnsiSay '.'
            indexcount=indexcount+1
         end
      else
         do
            Call lineout indexfile, 'DUP['mess.i.j.pos']['mess.i.j.num']['strip(mess.i.j.subject)']['mess.i.j.date']['mess.i.j.to']['mess.i.j.from']'
         end
   end /* do */
   if verbiage then say /*terminate line of dots*/
end /* do */
say indexcount 'indexed messages.'
DROP mess. indexcount
if extend then do
    Say '[There are now' numconf 'conferences.]'
    Say Ansi.blink
    Say 'You may wish to revise your config file.'
    Call AnsiSay Ansi.Plain
    Call WriteConfigFile
    'PAUSE'
  end
if updating then do
    /* we've screwed around with the variables, so reload them */
    call stream indexfile,'c','close'
    call readindex
  end
return

sortconfers:
do n=1 to numconf
   stackheight=1
   lstack.1=1
   rstack.1=confer.n.count
   do forever
      left=lstack.stackheight
      right=rstack.stackheight
      stackheight=stackheight-1
      do forever
         i=left
         j=right
         a=trunc((left+right)/2)
         median = mess.n.a.num
         do forever
            do while mess.n.i.num < median
               i=i+1
            end /* do */
            do while median < mess.n.j.num
               j=j-1
            end /* do */
            if i<=j then
               do
                  save.num=mess.n.i.num
                  save.pos=mess.n.i.pos
                  save.sub=mess.n.i.subject
                  save.to =mess.n.i.to
                  save.from=mess.n.i.from
                  save.date=mess.n.i.date
                  mess.n.i.num=mess.n.j.num
                  mess.n.i.pos=mess.n.j.pos
                  mess.n.i.subject=mess.n.j.subject
                  mess.n.i.to=mess.n.j.to
                  mess.n.i.from=mess.n.j.from
                  mess.n.i.date=mess.n.j.date
                  mess.n.j.num=save.num
                  mess.n.j.pos=save.pos
                  mess.n.j.subject=save.sub
                  mess.n.j.to=save.to
                  mess.n.j.from=save.from
                  mess.n.j.date=save.date
                  i=i+1
                  j=j-1
               end /* do */
            if i>j then
               leave
         end /* i <= j */
         if i<right then
            do
               stackheight=stackheight+1
               lstack.stackheight=i
               rstack.stackheight=right
            end
         right=j
         if left>=right then
            leave
      end /* left < right  */
      if stackheight=0  then
         leave
   end /* stackheight <> 0 */
end /* do */
drop save.
return

WriteConfigFile:
return
if symbol('confer.1.num')='VAR' then
   do
      'del' cfgfile
      if rc <> 0 then say 'Could not delete old config; check it!'
      mconf = 'Conference Not Found'
      temp=numconf
      do confcnt=1 to numconf
          if confer.confcnt.name = mconf then temp=temp-1
        end
      call stream  cfgfile, 'c', 'open write'
      call lineout cfgfile, 'READBBS' revision
      call lineout cfgfile, 'conferences:' temp
      drop temp confcnt
      do i=1 to numconf
          if confer.i.name = mconf then iterate
          dataout=confer.i.num confer.i.name '['confer.i.lastread']'
          call lineout cfgfile, dataout
       end /* do */
      drop i dataout
      call lineout cfgfile,'color:'
      call lineout cfgfile,'  message' color.fore.message color.back.message
      call lineout cfgfile,'  header' color.fore.header color.back.header
      call lineout cfgfile,'  help' color.fore.help color.back.help
      call lineout cfgfile,'  menumess' color.fore.menumess color.back.menumess
      call lineout cfgfile,'  menuconf' color.fore.menuconf color.back.menuconf
      call lineout cfgfile,'  attention' color.fore.attention color.back.attention
      if datatype(uvars.0)='NUM' then do
          call lineout cfgfile,'vars:' uvars.0
          do i=1 to uvars.0
             call lineout cfgfile,uvars.i
           end
        end
      Call Stream cfgfile, 'c', 'close'

   end
else
   say 'Could not update Config file ('cfgfile').'
return

Usage:

say 'Usage:'
say
say 'READBBS  {text file} [+ {update}] /I /C {config file} NOLASTREAD'
say
say '{text file} is the "captured" text file from the BBS.'
say '{update} is additional text to be appended to {text file}'
say '/I tells READBBS to recreate the index file.  Each message file will have an'
say '    index file created for it.'
say
say '/C {config file} tells READBBS to read specified configuration file.  The'
say '    default config filename will be READBBS.CFG (if you renamed READBBS.CMD to'
say '    'something else'.CMD the default will be the 'something else'.CFG)'
say
say 'NOLASTREAD tell READBBS to disregard the last message number read and display'
say '    first message of each conference.  READBBS keeps track of the LARGEST'
say '    message number read for each conference.  If that number is between the'
say '    message numbers for the current conference, READDBBS will automatically'
say '    display the message AFTER the LASTREAD message.'
Exit


/*************************************************************************
 *
 *  SetAnsi:  Puts the ANSI escape codes and a few usefull constants
 *            in the Ansi. stem variable
 *
 ************************************************************************/
SetAnsi: PROCEDURE EXPOSE Ansi.
   escCd = '1B'x || "["

   /** Constants **/
   Ansi.esc = escCd

   /* Row and column variables */
   Ansi.rows=25; Ansi.cols=80
   Ansi.row=1;  Ansi.col=1

   /* Move charactos - Up, Down, Left, Right */
   Ansi.moveTable = "ABDC"
   Ansi.userTable = '+-<>'

   /** Escape codes : NS = Not Supported under OS/2 **/

   Ansi.cls    = escCd || "2J"  /* Clears the screen */
   Ansi.erase  = escCd || "K"   /* Erase to End-Of-Line */

   /** Screen Attributes:  Used with ScrAttr */

   /* Styles */
   Ansi.plain  = escCd || "0m"  /* All attributes off */
   Ansi.bold   = escCd || "1m"  /* Bold type */
   Ansi.faint  = escCd || "2m"  /* Faint type -NS */
   Ansi.italic = escCd || "3m"  /* Italic type */
   Ansi.blink  = escCd || "5m"  /* Blink type */
   Ansi.rblink = escCd || "6m"  /* Rapid-Blink type - NS */
   Ansi.rev    = escCd || "7m"  /* Reverse video */
   Ansi.hidden = escCd || "8m"  /* Concealed type */
   Ansi.subscr = escCd || "48m" /* Subscript */
   Ansi.supscr = escCd || "49m" /* Superscript */

   /* Colors, (b)ackground and (f)oreground */
   Ansi.fblack   = escCd || "30m"; Ansi.bblack   = escCd || "40m"
   Ansi.fred     = escCd || "31m"; Ansi.bred     = escCd || "41m"
   Ansi.fgreen   = escCd || "32m"; Ansi.bgreen   = escCd || "42m"
   Ansi.fyellow  = escCd || "33m"; Ansi.byellow  = escCd || "43m"
   Ansi.fblue    = escCd || "34m"; Ansi.bblue    = escCd || "44m"
   Ansi.fmagenta = escCd || "35m"; Ansi.bmagenta = escCd || "45m"
   Ansi.fcyan    = escCd || "36m"; Ansi.bcyan    = escCd || "46m"
   Ansi.fwhite   = escCd || "37m"; Ansi.bwhite   = escCd || "47m"

   /* Screen modes 40x25 = 40 X 25, B = Black and White.  C = Color */
   Ansi.40x25B   = escCd || "=0h"; Ansi.40x25C   = escCd || "=1h"
   Ansi.80x25B   = escCd || "=2h"; Ansi.80x25C   = escCd || "=3h"
   Ansi.320x200B = escCd || "=4h"
   Ansi.640x200B = escCd || "=5h"; Ansi.640x200C = escCd || "=6h"
   Ansi.Wrap     = escCd || "=7h"; Ansi.UnWrap   = escCd || "=7I"
RETURN


AnsiSay: PROCEDURE EXPOSE Ansi.
PARSE ARG attribs
rc = charout(, attribs)
RETURN 0

Syntax:
lapst=Time('R')
emsgt='Err' RC 'after' lapst 'on line' SIGL':' errortext(rc)
srcl=sourceline(sigl)
trace ?A
say emsgt
say srcl
say 'TERMINATING!'
say
pull .
exit
