%
% This is an example with ALL control statements that can be used in the
% RDS.CTL (alike) file. This is a normal ASCII file. Rules for coding
% are:
% - Case is not important
% - A line without '%' or ';' in the first position is considered a
%   control statement;
% - Not the starting position of the control-statement is important
%   but the order of sub-parameters is, so you can start a statement
%   anywhere on the line (with starting 'white-spaces');
% - Lines with a '%' or ';' character in position 1 are comment
%   statements.
%
% New options contain '*NEW*' at the end of the line, changed options
% contain '*DIF*' at the end of the line !
%
%
%
% Define various run-time options
%
%
BBSType            RA11
BBSDirectory       D:\BBS\RAX
% BBSWorkDirectory D:\BBS\RAX
MacroExpandBuffer  200
HelpDirectory      D:\BBS\RAX\PRG\RDS.HLP
RaDownText         C:\TUP\RDS.CTL
BeepHours          1800-2300
DownloadHours      0300-2400
DownloadHours      0000-0159
UploadHours        0300-2400
UploadHours        0000-0159
Download           Z 255 ZModem C:\SYS\PRO\DSZ.COM port $1 sz    $3 $M
Upload             Z     ZModem C:\SYS\PRO\DSZ.COM port $1 rz    $4 $M
Download           Y 255 YModem C:\SYS\PRO\DSZ.COM port $1 sx -k $3 $M
Upload             Y     YModem C:\SYS\PRO\DSZ.COM port $1 rx -k $4 $M
LogPath            D:\LOG\RDS.LOG
%
%=======================================================================
ALIAS   CLEANUP  E:\PRG\RDS\CLEANUP.RDA
ALIAS   NORTON   E:\PRG\RDS\NORTON.RDA
%
% Define the users you allow and the functions they can NOT access
%
%
%=======================================================================
% First myself, the Sysop should have access to al don't you thing
%=======================================================================
User Rob van.hoeven
UserEnd
%
%=======================================================================
% A users who are allowed to enter RDS. They can do nothing, see nothing
% and most important, can destroy nothing. Only MEM and VER are allowed
%=======================================================================
User ALL
     UserDirectory E:\TRASH
     ExcludeFile  *.*
     ExcludeDrive A:
     ExcludeDrive B:
     ExcludeDrive C:
     ExcludeDrive D:
     ExcludeDrive E:
     ExcludeDirectory E:\ZIP\*
     NoDrive
     NoCls
     NoUserOn
     NoDate
     NoDir
     NoViewArc
     NoTime
     NoCD
     NoRD
     NoMD
     NoDel
     NoRen
     NoType
     NoCopy
     NoMove
     NoKillNice
     NoKillForce
     NoBoot
     NoDownload
     NoUpload
     NoChat
     NoBeep
     NoLog
     NoWhere
     NoMacro
     NoModemSend
     NoModemStat
     NoExpand
     Shell
     NoALias
     NoTree
     NoCOmpare
     NoLabel
     NoAddFiles
     NoTouch
UserEnd
%
%=======================================================================
% A special caller. She makes my CD (Carrier Detect?) always high !
% Go anywhere, do anything but keep away of the files PINK*.* and
% REAL*.*. Also restrictions in my E: drive. She must use a password !
%=======================================================================
User Kate Bush
     UserPassword Kite
     ExcludeFile  REAL*.*
     ExcludeFile  PINK*.*
     ExcludeDrive E:
UserEnd
%
%=======================================================================
% Yet again no stranger to me. Again I reject some access to files with
% the extension USA and also it should be impossible to COPY, MOVE and
% DEL something ! Also a password please !
%=======================================================================
User Alfred Schnittke
     ExcludeFile  *.USA
     UserPassword USSR
     NoCopy
     NoMove
     NoDel
UserEnd
%
%=======================================================================
% Ahh, the CoSysop on MY system (as where I am the CoSysop on his
% system). Anything but booting is possible. Sometimes I run benchmarks
% on my programs (for nights on <sigh>) to get them faster and better.
% These tasks can not be interrupted !
%=======================================================================
User Reinier De.groot
     NoBoot
UserEnd
%
%=======================================================================
% Also some special users
%=======================================================================
User Dirk Astrath
     NoBoot
     ExcludeDirectory C:\TUP
     ExcludeDirectory C:\TUP\DEVELOP
     ExcludeDirectory C:\TUP\UNITS
     ExcludeDirectory C:\MSC
     ExcludeDirectory C:\MSC\PROGRAMS
     ExcludeDirectory C:\M2
     ExcludeDirectory C:\M2\PROGRAMS
     ExcludeFile      *.TPU
UserEnd
User Rob Lirb
     NoBoot
     ExcludeDrive     D:
     ExcludeDrive     E:
     ExcludeDirectory C:\GAMES
UserEnd
%
%=======================================================================
% Someone who likes to enter doors. EVERYTHING (execpt EXIT and DIR)
% is rejected
%=======================================================================
User Foo Bar
     NoDrive
     NoCls
     NoMem
     NoUserOn
     NoVer
     NoDate
     NoTime
     NoCD
     NoRD
     NoMD
     NoDel
     NoRen
     NoType
     NoCopy
     NoMove
     NoKillNice
     NoKillForce
     NoBoot
UserEnd
%
%
% Define the LOG-style you want to use (several examples included)
%
%
% F R O N T D O O R  <tm>  style
%
% LogStartStyleFormat ^M----------__%D__,_RDS
% LogStyleFormat      >__%T__
% LogDateFormat       mm/dd/yy
% LogTimeFormat       hh:mm:ss
%
% D ' B R I D G E    <tm>  style
%
LogStyleFormat               %D_%T__RDS:_
LogDateFormat                mm/dd/yy
LogTimeFormat                hh:mm
%
% Q U I C K B B S    <tm> style
%
% LogStyleFormat             %D_%T__
% LogDateFormat              dd-nnn-yy
% LogTimeFormat              hh:mm
%
% O P U S  1 . X X   <tm> style
%
% LogStyleFormat             +_%D_%T_RDSZ_
% LogDateFormat              dd_nnn
% LogTimeFormat              hh:mm:ss
%
% B I N K L E Y      <tm> style
%
% LogStyleFormat             +_%D_%T_RDSZ_
% LogDateFormat              dd_nnn
% LogTimeFormat              hh:mm:ss
%
% F A N T A S Y           style
%
% LogStyleFormat             RDSLOG__%D__%T__Executed:_
% LogDateFormat              dd_nnn_yyyy
% LogTimeFormat              hh:mm:ss
