/*
RIPScrip Detect for TriDoor Version 1.00
Copyright 1993 by Eric Theriault

Example of RIPScrip detect using TriDoor 1.21
Originally compiled using Borland TurboC++

Source is not under any warenty to work. Please read full documentation
before compiling.

You are expected to have read and understood the TriDoor Documentation for
Version 1.21.
*/

//Included Libraries
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <time.h>
#include "tridoor.h"

int rip;                                        //RIPScrip toggle
int c;                                          //Input Variable
#define TRUE 1                                  //TRUE Definition
#define FALSE 0                                 //FALSE Definition

void ripdetect(void);                           //RIPScrip detection code
void displaywelcome(void);                      //Display "Welcome" code

void main(void)
{
	TDInitialize();                         //Initialize TriDoor
	strcpy(TDDoorName, "RIPScrip Detect for TriDoor");
						//Set door name parmeter
	randomize();                            //Initialize Randomize
	displaywelcome();                       //Display welcome
}

void displaywelcome(void)
{
	TDPrintf("RIPScrip Detect for TriDoor Version 1.00\nCopyright 1993 by Eric Theriault\n");       //Display Copyright Information
	ripdetect();                            //Get Detect RIPScrip
	if(rip){                                //Test to see if RIPScrip
						//is on.
		TDPrintf("RIPScrip Detected!\n\nPress any key to continue..."); //Tell user that they have RIPScrip
	}
	else{
		TDPrintf("RIPScrip Not Detected!\n\nPress any key to continue..."); //Tell user that they do not have RIPScrip.
	}
	TDGetch();                      //Get character
}

void ripdetect(void)
{
	TDPrintf("[!");                        //Send RIPScrip Detect Code
	delay(500);                             //Wait a few seconds for
						//Action to take place.
	if(TDKeyPressed()){                     //Check COMx for RIPScrip
						//Detect response.
		c=toupper(TDGetch());           //Get Character
		if(c=='R'){                     //See if the character matches response.
			c=toupper(TDGetch());   //If so, then get another character.
			if(c=='I'){             //See if the character matches response.
				c=toupper(TDGetch());   //If so, then get another character.
				if(c=='P'){             //See if the character matches response.
					c=toupper(TDGetch());   //If so, then get another character.
					if(c=='S'){             //See if the character matches response.
						c=toupper(TDGetch());   //If so, then get another character.
						if(c=='C'){             //See if the character matches response.
							c=toupper(TDGetch());   //If so, then get another character.
							if(c=='R'){             //See if the character matches response.
								c=toupper(TDGetch());   //If so, then get another character.
								if(c=='I'){             //See if the character matches response.
									c=toupper(TDGetch());   //If so, then get another character.
									if(c=='P'){             //See if the character matches response.
										rip=1;                  //Set RIPScrip variable to TRUE
										c=toupper(TDGetch());   //Get Product Idetification
										c=toupper(TDGetch());
										c=toupper(TDGetch());
										c=toupper(TDGetch());
										c=toupper(TDGetch());
										c=toupper(TDGetch());
									}
								}
							}
						}
					}
				}
			}
		}
	}
	else rip=0;                             //If no response, then set
						//RIPScrip to FALSE.
}
