{$A+,B-,D-,E-,F+,G-,I-,L-,N-,O-,R-,S+,V-,X+}
{$M 65520,0,262144}
Program rdoor;

Uses
    CrT, Dos, Turbo3;

{$I Records.pas}

{ Define this if this is a beta test }
{ Define Beta}

Const                         
    Title = 'KludgeWare! RDoor';
{$IFDEF Beta}    
    Version = ' V1.2 Beta';
{$ELSE}
    Version = ' V1.2';
{$ENDIF}

(*--------------------------------------------------------------------------
The I/O section is (c) copyright 1988-91 Santronics Software
Taken from the TPascal squish API
----------------------------------------------------------------------------*)

Const
    { Used for SHARE support }     
    _KEEP_MODE  = -1;             { DO NOT CHANGE FILE MODE IN FOPEN }
                                  { share mode DOs 3++ and above }

    _READONLY   = $00;         _DENYALL    = $10;
    _WRITEONLY  = $01;         _DENYWRITE  = $20;
    _READWRITE  = $02;         _DENYREAD   = $30;
                               _DENYNONE   = $40;

Const LockRegion   = 00;
      UnLockRegion = 01;

type
	dsysinfrec = record
		sl	 : byte;	 { Security Level, Read back (Line 15) }
        uPos : longint;  { Users file record number, Use to locate user (Line 26) }
		UL	 : word;	 { Total uploads, Read back (Line 28) }
		Dl	 : word;	 { Total downloads, Read back (Line 29) }
		daydK : word;	 { Daily download "K" total, Read back (Line 30) }
        tcred : longint; { Time Credits in minutes, CAN'T read back (Line 42) }
		fdltdy : word;	 { Files downloaded today, Read back (Line 47) }
		tkupl : longint; { Total K uploaded, Read back (Line 48) }
        tkdl : Longint;  { Total K Downloaded, Read back (Line 49) }
    end;  {  Rec  }
    
    STREAM = file;
    str80 = string [80];
Var
    Copyright : str80;
    dSyspath,
    uDatPath  : str80;
    ecode     : byte;
    urec      : userrec;
    dinf      : dsysinfrec;
    fluff     : boolean;

{    }

function fopen(var fv   : stream;
                   fn   : pathstr;
                   mode : integer
                      ) : integer;
{open untyped file return the dos error code}
var
    fm : byte;
    isgood : integer;
begin
    assign(fv,fn);
    fm := filemode;
    if mode <> _KEEP_MODE then filemode := mode;
    reset(fv,1);
    isgood := ioresult;
    fopen := isgood;
    filemode := fm;

{$IFDEF Beta}
    if isgood = 0 then
        Writeln('+ File: ', fn, ' is now opened.')
    else
        writeln('! File: ', fn, ' did not open correctly for some reason.');
{$ENDIF}

end;

function  fclose(var fv : stream) : integer;
begin
   close(fv);
   fclose := ioresult;
end;

Function ShareLoaded : Boolean;
var reg : registers;
begin
    reg.ax := $1000;
    Intr($2F,reg);
    ShareLoaded := ((reg.flags and $01) = 0) and (reg.al = $FF);
end;

(*

Lock or Unlock region of file.

Input         : Handle  - turbo untype file variable handle (filerec(fv).handle)
input         : action  - action to take. See constants above;
input         : start   - beginging file position to lock.
input         : bytes   - number of bytes to lock.
output        : ax      - ax register return value

returns TRUE if lock is successful, False otherwise (check AX)

*)

Function FileLock(handle : word; action : byte; start,bytes : longint; var ax : integer): Boolean;
var
    reg : registers;
    isgood : boolean;
begin

    reg.ax := $5C00 + action;
    reg.bx := handle;
    reg.cx := hi(start);
    reg.dx := lo(start);
    reg.si := hi(bytes);
    reg.di := lo(bytes);

    Intr($21,reg);
    isgood := (reg.flags and $01) = $00;
    filelock := isgood;
    ax := reg.ax;
    
{$IFDEF Beta}
    if isgood then
        writeln('+ File locked correctly.')
    else
        writeln('! Problem locking file.');
{$ENDIF}

end;



Procedure Show_Copyright;
Begin  {  Show_Copyright  }

{$IFDEF Beta}
    Writeln('- Displaying Copyright notice');
{$ELSE}
    Clrscr;
{$ENDIF}
    Writeln(Title+Version+' is');

    Writeln('is ', Copyright);
    Writeln('All Rights Reserved');
    writeln;

    Writeln('This program may be freely distributed and used as LONG as there are');
    Writeln('NO modifications to the executable or documentation files, and that');
    Writeln('there are NO files added to the distribution archive.');
	
    Writeln('No registration fee for this program is required.');
    writeln;
    
End;   {  Show_Copyright  }

{    }

Procedure Killit(Errnum : byte; errmess : str80);
Begin  {  Killit  }

{$IFDEF Beta}
    Writeln('= Shutting down the program.');
{$ENDIF}

    Writeln(errmess);
	halt(errnum);

End;   {  Killit  }

{    }

Procedure Show_help;
Begin  {  Show_help  }

{$IFDEF Beta}
    Writeln('! User did not enter in command line correct.');
{$ENDIF}
    Textcolor(14);

    Writeln('rDoor is run with two REQUIRED commandline parameters in the following');
    Writeln( 'manner:');
    Writeln;

    Writeln('rDoor c:\rg\doorpath\ c:\rg\data\');
    Writeln;

    Writeln('The first path is the path to the door.sys to read into the bbs, and');
    Writeln('the second path is the path to your USERS.DAT.  You MUST include the');
    Writeln('trailing backslash on the end of each path, and BOTH paths are needed');
    Writeln('for the program to run correctly.');

    Textcolor(15);

End;   {  Show_help  }

{    }

Function Start_Up(var dsyspath,
					  udatpath	: str80; 
				  var ecode 	: byte) : boolean;
{
    Parses commandline to find path to users.dat and path to door.sys, 
    also displays help text if not found.
}
var
    isgood : boolean;
	p1,
	p2	   : str80;
Begin  {  Start_Up  }

{$IFDEF Beta}
    writeln('- Starting program.');
{$ENDIF}
    Copyright := 'Copyright 1992 By Patrick Spence';
	isgood := false;
    textcolor(15);
	
	Show_Copyright;

	If (paramcount > 2) or (paramcount < 1) then
	begin
		Show_Help;
	end
	else
	begin
        p1 := paramstr(1);
        p2 := paramstr(2);
        dsyspath := p1+'door.sys';
        udatpath := p2+'users.dat';
		isgood := true;
{$IFDEF Beta}
        writeln('- Parameter 1 is    : ', p1);
        writeln('- Parameter 2 is    : ', p2);
        writeln('- Door.sys path is  : ', dsyspath);
        writeln('- Users.dat path is : ', udatpath);
{$ENDIF}
    end;

    start_up := isgood;
    
End;   {  Start_Up  }

{    }

Procedure Action(   dSyspath,
                    uDatpath  : Str80;
                 var ecode    : byte);
{
    Opens door.sys, reads the pertanant info, and updates the correct 
    user record.
}
var
    ud       : stream;
    ds       : text;
    sizerec  : longint;
    filepos  : longint;
    tStr     : str80;
    tfluff   : str80;
    error    : byte;
    ax       : integer;
    flf      : boolean;
    loop     : byte;

Begin  {  Action  }

    sizerec := sizeof(urec);
{$IFDEF Beta}
    writeln('- User record size is : ', sizerec);
{$ENDIF}

	assign(ds, dsyspath);
	reset(ds);
	error := ioresult;
{$IFDEF Beta}
    if error <> 0 then
        writeln('! Unable to open door.sys at ', dsyspath)
    else
        writeln('+ Door.sys opened at ', dsyspath);
{$ENDIF}
    if error > 0 then Killit(error, 'Error opening DOOR.SYS, Check Configuration');
	for loop := 1 to 14 do
    begin
        readln(ds, tfluff);
{$IFDEF Beta}    
        writeln('- Unused data on line: ', loop, ' is ', tfluff);
{$ENDIF}
    end;
	readln(ds, dinf.sl);
{$IFDEF Beta}    
        writeln('+ Users security level is: ', dinf.sl);
{$ENDIF}
    for loop := 16 to 25 do
    begin
        readln(ds, tfluff);
{$IFDEF Beta}    
        writeln('- Unused data on line: ', loop, ' is ', tfluff);
{$ENDIF}
    end;
    readln(ds, dinf.uPos);
{$IFDEF Beta}    
    writeln('+ Users Number is: ', dinf.uPos);
{$ENDIF}
    readln(ds, tfluff);
{$IFDEF Beta}    
    writeln('- Unused data on line: 27 is ', tfluff);
{$ENDIF}
    readln(ds, dinf.ul);
{$IFDEF Beta}    
    writeln('+ Users number of uploads is: ', dinf.ul);
{$ENDIF}
    readln(ds, dinf.dl);
{$IFDEF Beta}    
    writeln('+ Users number of downloads is: ', dinf.dl);
{$ENDIF}
    readln(ds, dinf.daydk);
{$IFDEF Beta}    
    writeln('+ Users number of K d/l today is: ', dinf.daydk);
{$ENDIF}
    for loop := 31 to 41 do
    begin
        readln(ds, tfluff);
{$IFDEF Beta}    
        writeln('- Unused data on line: ', loop, ' is ', tfluff);
{$ENDIF}
    end;
    readln(ds, dinf.tcred);
{$IFDEF Beta}    
    writeln('+ Users time credits (unused) is: ', dinf.tcred);
{$ENDIF}
    for loop := 43 to 46 do
    begin
        readln(ds, tfluff);
{$IFDEF Beta}    
        writeln('- Unused data on line: ', loop, ' is ', tfluff);
{$ENDIF}
    end;
    readln(ds, dinf.fdltdy);
{$IFDEF Beta}    
    writeln('+ Users number of files downloaded today is: ', dinf.fdltdy);
{$ENDIF}
    readln(ds, dinf.tkupl);
{$IFDEF Beta}    
    writeln('+ Users total K uploaded is: ', dinf.tkupl);
{$ENDIF}
    readln(ds, dinf.tkdl);
{$IFDEF Beta}    
    writeln('+ Users total K downloaded is: ', dinf.tkdl);
{$ENDIF}
    close(ds);
{$IFDEF Beta}    
    writeln('- Door.sys is now closed.');
{$ENDIF}


	error := fopen(ud, udatpath, _readwrite);
	if error > 0 then Killit(error, 'Error opening USERS.DAT, check configuration');
    filepos := sizerec*dinf.upos;
{$IFDEF Beta}
    writeln('- Seeking in USERS.DAT to byte position: ', filepos);
{$ENDIF}
    seek(ud, filepos);
{$IFDEF Beta}
    writeln('- Reading in Users record from user.dat');
{$ENDIF}
    blockread(ud, urec, sizerec);
    error := ioresult;
{$IFDEF Beta}
    if (error=0) then
        writeln('+ User read in is: ', urec.name);
{$ENDIF}
    if error > 0 then killit(error, 'Error accessing USERS.DAT');
    with urec do
    begin
        sl := dinf.sl;             { Security Level, Read back (Line 15) }
{$IFDEF Beta}
    writeln('+ SL written to record: ', sl);
{$ENDIF}
        uploads := dinf.UL;        { Total uploads, Read back (Line 28) }
{$IFDEF Beta}
    writeln('+ Total uploads written to record: ', uploads);
{$ENDIF}
        downloads := dinf.Dl;      { Total downloads, Read back (Line 29) }
{$IFDEF Beta}
    writeln('+ Total downloads written to record: ', downloads);
{$ENDIF}
        dlktoday := dinf.daydK;    { Daily download "K" total, Read back (Line 30) }
{$IFDEF Beta}
    writeln('+ Downloads today written to record: ', dlktoday);
{$ENDIF}
        dltoday := dinf.fdltdy;    { Files downloaded today, Read back (Line 47) }
{$IFDEF Beta}
    writeln('+ Number of files d/l today written to record: ', dltoday);
{$ENDIF}
        uk := dinf.tkupl;          { Total K uploaded, Read back (Line 48) }
{$IFDEF Beta}
    writeln('+ Total K uploaded written to record: ', uk);
{$ENDIF}
        dk := dinf.tkdl;           { Total K Downloaded, Read back (Line 49) }
    end;  {  With  }
    
{$IFDEF Beta}
    writeln('- Seeking in USERS.DAT to byte position: ', filepos);
{$ENDIF}
    seek(ud, filepos);
{$IFDEF Beta}
    writeln('- Writing to Users.dat from record in memory.');
{$ENDIF}
    blockwrite(ud, urec, sizerec);
    error := ioresult;
{$IFDEF Beta}
    if (error=0) then
        writeln('+ Record written to users.dat');
{$ENDIF}
    if error > 0 then killit(error, 'Error accessing USERS.DAT');

    error := fclose(ud);
    if error > 0 then Killit(error, 'Error Closing USERS.DAT');

End;   {  Action  }

{    }

Procedure Shut_Down(ecode : byte);
{
    performs cleanup activity.
}
Begin  {  Shut_Down  }

{$IFDEF Beta}
    writeln('- Shutting down program.');
{$ENDIF}
    Gotoxy(1, 22);
    killit(ecode, 'Thank you for using another fine KludgeWare! Product.');

End;   {  Shut_Down  }

{    }

Begin  {  rDoor  }

{$IFDEF Beta}
    assign (output, '');
    rewrite(output);
    Writeln('+ Calling Initialzation procedure.');
{$ENDIF}
    Fluff := Start_Up(dSyspath, uDatpath, ecode);
{$IFDEF Beta}
    writeln('+ Calling main action procedure.');
{$ENDIF}
    if fluff then
        Action(dSyspath, uDatpath, ecode);
{$IFDEF Beta}
    writeln('+ Calling shut down procedure.');
{$ENDIF}
    Shut_Down(ecode);

End.   {  rDoor  }
