//*********************************************************************
//
//  CRSH.C - Example usage of Winsock RCMD32.DLL
//
//
//  Winsock RCMD32.DLL Copyright (c) 1994 Denicomp Systems
//
// 
//  Usage:
//
//     CRSH host command
//
//  Where:
//     host - host name of the remote host
//     command - the command to execute at the remote host.  Enclose in quotes
//               if the command contains special characters.
//
//  This program will execute the "command" specified on the "host" specified
//  display the output in a Windows NT console window.
//  When the command is complete, it will wait for you to press Return.
//
//  The command must be a non-interactive command; that is, it cannot require
//  any keyboard input.
//
//  The directory containing Winsock RCMD32.DLL must be in your PATH or
//  RCMD32.DLL must reside in the Windows directory.
//
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#include "rcmd32.h"

char cmd[256];
char errmsg[128];

int main (int argc, char *argv[])
{
	HANDLE hConsole;
	int a, hRCmd, len;
	char rbuf[65];

	// check if Win32s, if so, display notice and terminate
	if( GetVersion() & 0x80000000 && (GetVersion() & 0xFF) ==3)
	{
	  MessageBoxA(NULL,
		      "This application cannot run on Windows 3.1.\n"
		      "This application will now terminate.",
		      "CRSH",
		      MB_OK | MB_ICONSTOP | MB_SETFOREGROUND );
	  return(1);
	}

	// Open the current console input buffer
	if ((hConsole = CreateFile("CONOUT$", GENERIC_WRITE | GENERIC_READ,
            	        	   FILE_SHARE_READ | FILE_SHARE_WRITE, 0L,
				   OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
				   0L)) == INVALID_HANDLE_VALUE )
	{
	  printf("\nError: Unable to open console.\n");
	  return(-1);
	}

	// We must have at least two arguments on the command line
	if (argc < 3)
	{
	  printf("\nUsage: %s host command\n",argv[0]);
	  return(-1);
	}

	// The host is in argv[1].
	// Concatenate the remaining arguments into cmd, putting a space
	// between each.
	cmd[0] = '\0';
	for(a = 2; a < argc; a++)
	{
	  strcat(cmd,argv[a]);
	  strcat(cmd," ");
	}

	hRCmd = WinsockRCmd(argv[1],514,NULL,NULL,cmd,errmsg,sizeof(errmsg));

	if (hRCmd < 0)		// An error occurred, report it
	  printf("Error: %s\n",errmsg);
	else
	{
	  // Read the data 64 bytes at a time and display it
	  while((len = RCmdRead(hRCmd,rbuf,64)) > 0)
	  {
	    rbuf[len] = '\0';
	    printf("%s",rbuf);
	  }
	  printf("\nPress Return: ");
	  getchar();
	  RCmdClose(hRCmd);	// Close & free resources
	}

	return(0);
}

