unit Rchmov1;

{ This unit shows the application of the method RemoveLastToken
  two display moving graphics objects. Once a background is
  established (the dotted line) only the moving elements have to
  exhchanged on the linked list by first removing them and then
  redrawing them at another location }

{--------------------------------------------------------------}
interface
{--------------------------------------------------------------}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, RChart, ExtCtrls;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    ButDone: TBitBtn;
    ButStart: TBitBtn;
    ButStop: TBitBtn;
    Bevel1: TBevel;
    CBLogX: TCheckBox;
    CBLogY: TCheckBox;
    procedure ButStartClick(Sender: TObject);
    procedure ButDoneClick(Sender: TObject);
    procedure ButStopClick(Sender: TObject);
    procedure CBLogXClick(Sender: TObject);
    procedure CBLogYClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

{--------------------------------------------------------------}
implementation

uses LogWarn;
{--------------------------------------------------------------}

{$R *.DFM}

var
  RunMove : boolean;

(***************************************************************)
procedure TForm1.ButStartClick(Sender: TObject);
(***************************************************************)

const
  NPnts = 140;

var
  i,j : integer;

begin
ButStop.Enabled := true;
ButStart.Enabled := false;
ButDone.Enabled := false;
RChart1.RangeLoX := 0;
RChart1.RangeHiX := NPnts;
RChart1.RangeLoY := 10;
RChart1.RangeHiY := 1000;
(*
RChart1.RangeHiY := 2*NPnts;
*)
RChart1.DataColor := clBlack;
RChart1.ClearGraf;
for i:= 1 to NPnts do
  RChart1.MarkAt (i, NPnts+i*sin(i*0.1), 0);
RChart1.ShowGraf;
RunMove := True;
RChart1.DataColor := clBlue;
RChart1.MarkAt (0,0,12);
RChart1.DataColor := clRed;
RChart1.MarkAt (0,0,12);
RChart1.ShowGraf;
i := 0;
j := 0;
while RunMove do
  begin
  inc (j,2);
  if j > NPnts then
    j := 1;
  inc (i);
  if i > Npnts then
    i := 1;
  RChart1.RemoveLastItem;
  RChart1.RemoveLastItem;
  RChart1.DataColor := clRed;
  RChart1.MarkAt (i,NPnts+i*sin(i*0.1), 18);
  RChart1.DataColor := clBlue;
  RChart1.MarkAt (j,NPnts+j*sin(j*0.1), 18);
  RChart1.ShowGraf;
  Application.ProcessMessages;
  end;
end;


(***************************************************************)
procedure TForm1.ButDoneClick(Sender: TObject);
(***************************************************************)

begin
close;
end;


(***************************************************************)
procedure TForm1.ButStopClick(Sender: TObject);
(***************************************************************)

begin
ButStop.Enabled := false;
ButStart.Enabled := true;
ButDone.Enabled := true;
RunMove := False;
end;

(***************************************************************)
procedure TForm1.CBLogXClick(Sender: TObject);
(***************************************************************)

begin
if not CBLogX.Checked and (RChart1.RangeLoX <= 0)
  then begin
       LogWarnForm.ShowModal;
       CBLogX.Checked := false;
       end
  else begin
       RChart1.LogScaleX := CBLogX.Checked;
       CBLogX.Checked := RChart1.LogScaleX;
       end;
end;

(***************************************************************)
procedure TForm1.CBLogYClick(Sender: TObject);
(***************************************************************)

begin
if not CBLogY.Checked and (RChart1.RangeLoY <= 0)
  then begin
       LogWarnForm.ShowModal;
       CBLogY.Checked := false;
       end
  else begin
       RChart1.LogScaleY := CBLogY.Checked;
       CBLogY.Checked := RChart1.LogScaleY;
       end;
end;


end.
